/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.util.logger.jdk14;

import java.io.IOException;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.slide.util.logger.jdk14.ConsoleLogfileFormatter;
import org.apache.slide.util.logger.jdk14.LogfileFormatter;
import org.apache.slide.util.logger.jdk14.SimpleLogfileFormatter;

public class LoggerConfiguration {
    private static final Logger logger = Logger.getLogger((class$org$apache$slide$util$logger$jdk14$LoggerConfiguration == null ? (class$org$apache$slide$util$logger$jdk14$LoggerConfiguration = LoggerConfiguration.class$("org.apache.slide.util.logger.jdk14.LoggerConfiguration")) : class$org$apache$slide$util$logger$jdk14$LoggerConfiguration).getName());
    public static final String DEFAULT_LOG_FILE = "Slide.log";
    public static final Level DEFAULT_LOG_LEVEL = Level.ALL;
    public static final String DEFAULT_FORMAT_STRING = "MM dd HH:mm:ss";
    public static final Formatter DEFAULT_FORMATTER = new SimpleLogfileFormatter("MM dd HH:mm:ss");
    public static final Formatter DETAIL_FORMATTER = new LogfileFormatter("MM dd HH:mm:ss");
    private static boolean isConfigured = false;
    static /* synthetic */ Class class$org$apache$slide$util$logger$jdk14$LoggerConfiguration;

    public static final void configure() {
        LoggerConfiguration.configure(DEFAULT_LOG_FILE, DEFAULT_LOG_LEVEL, Level.INFO);
    }

    public static final void configure(String logFilePath, Level logLevel, Level logToConsoleThreshold) {
        try {
            if (isConfigured) {
                return;
            }
            isConfigured = true;
            Handler[] handlers = Logger.getLogger("").getHandlers();
            int i = 0;
            while (i < handlers.length) {
                Handler handler = handlers[i];
                if (handler instanceof ConsoleHandler) {
                    handler.setFormatter(new ConsoleLogfileFormatter());
                    handler.setLevel(logToConsoleThreshold);
                }
                ++i;
            }
            Logger.getLogger("").setLevel(logLevel);
            FileHandler fileHandler = new FileHandler(logFilePath);
            fileHandler.setFormatter(DETAIL_FORMATTER);
            Logger.getLogger("").addHandler(fileHandler);
            logger.log(Level.INFO, "Logging Service configured");
        }
        catch (IOException ioe) {
            logger.log(Level.WARNING, "Could not set logging configuration", ioe);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

