/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.util.logger.jdk14;

import java.util.logging.Level;
import org.apache.slide.util.logger.Logger;
import org.apache.slide.util.logger.jdk14.LoggerConfiguration;

public class Jdk14Logger
implements Logger {
    public static final int DEFAULT_LEVEL = 6;

    public Jdk14Logger() {
        LoggerConfiguration.configure();
    }

    public void log(Object data, Throwable throwable, String channel, int slideLevel) {
        java.util.logging.Logger logger = java.util.logging.Logger.getLogger(channel);
        Level level = this.getLevelForSlideLevel(slideLevel);
        logger.log(level, data.toString(), throwable);
    }

    public void log(Object data, String channel, int slideLevel) {
        java.util.logging.Logger logger = java.util.logging.Logger.getLogger(channel);
        Level level = this.getLevelForSlideLevel(slideLevel);
        if (data instanceof Throwable) {
            logger.log(level, data.toString(), (Throwable)data);
        } else {
            logger.log(level, data.toString());
        }
    }

    public void log(Object data, int level) {
        this.log(data, "org.apache.slide.util.logger", level);
    }

    public void log(Object data) {
        this.log(data, "org.apache.slide.util.logger", 6);
    }

    public int getLoggerLevel(String channel) {
        java.util.logging.Logger logger = java.util.logging.Logger.getLogger(channel);
        Level level = logger.getLevel();
        return this.getSlideLevelForLevel(level);
    }

    public int getLoggerLevel() {
        return this.getLoggerLevel("org.apache.slide.util.logger");
    }

    public void setLoggerLevel(int slideLevel) {
        java.util.logging.Logger.getLogger("").setLevel(this.getLevelForSlideLevel(slideLevel));
        this.setLoggerLevel("org.apache.slide.util.logger", slideLevel);
    }

    public void setLoggerLevel(String channel, int slideLevel) {
        java.util.logging.Logger logger = java.util.logging.Logger.getLogger(channel);
        Level level = this.getLevelForSlideLevel(slideLevel);
        logger.setLevel(level);
    }

    public boolean isEnabled(String channel, int slideLevel) {
        java.util.logging.Logger logger = java.util.logging.Logger.getLogger(channel);
        Level level = this.getLevelForSlideLevel(slideLevel);
        return logger.isLoggable(level);
    }

    public boolean isEnabled(int level) {
        return this.isEnabled("org.apache.slide.util.logger", level);
    }

    protected Level getLevelForSlideLevel(int slideLevel) {
        Level level = Level.ALL;
        switch (slideLevel) {
            case 0: {
                level = Level.SEVERE;
                break;
            }
            case 1: {
                level = Level.SEVERE;
                break;
            }
            case 2: {
                level = Level.SEVERE;
                break;
            }
            case 4: {
                level = Level.WARNING;
                break;
            }
            case 6: {
                level = Level.INFO;
                break;
            }
            case 7: {
                level = Level.FINE;
            }
        }
        return level;
    }

    protected int getSlideLevelForLevel(Level level) {
        if (level.equals(Level.ALL)) {
            return 7;
        }
        if (level.equals(Level.FINEST)) {
            return 7;
        }
        if (level.equals(Level.FINER)) {
            return 7;
        }
        if (level.equals(Level.FINE)) {
            return 7;
        }
        if (level.equals(Level.CONFIG)) {
            return 7;
        }
        if (level.equals(Level.INFO)) {
            return 6;
        }
        if (level.equals(Level.WARNING)) {
            return 4;
        }
        if (level.equals(Level.SEVERE)) {
            return 2;
        }
        if (level.equals(Level.OFF)) {
            return -1;
        }
        return 6;
    }
}

