/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.util.locking.impl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.slide.util.locking.MultiLevelLock;
import org.apache.slide.util.logger.StoreLogger;

public class GenericLock
implements MultiLevelLock {
    private Object resourceId;
    private Map owners = new HashMap();
    private int maxLockLevel;
    protected StoreLogger logger;

    public GenericLock(Object resourceId, int maxLockLevel, StoreLogger logger) {
        if (maxLockLevel < 1) {
            throw new IllegalArgumentException("The maximum lock level must be at least 1 (" + maxLockLevel + " was specified)");
        }
        this.resourceId = resourceId;
        this.maxLockLevel = maxLockLevel;
        this.logger = logger;
    }

    public synchronized boolean acquire(Object ownerId, int targetLockLevel, boolean wait, boolean reentrant, long timeoutMSecs) throws InterruptedException {
        this.logger.logFiner(ownerId.toString() + " trying to acquire lock for " + this.resourceId.toString() + " at level " + targetLockLevel + " at " + System.currentTimeMillis());
        if (this.tryLock(ownerId, targetLockLevel, reentrant)) {
            this.logger.logFiner(ownerId.toString() + " actually acquired lock for " + this.resourceId.toString() + " at " + System.currentTimeMillis());
            return true;
        }
        if (!wait) {
            return false;
        }
        long started = System.currentTimeMillis();
        long remaining = timeoutMSecs;
        while (remaining > 0L) {
            this.logger.logFiner(ownerId.toString() + " waiting on " + this.resourceId.toString() + " for msecs " + timeoutMSecs + " at " + System.currentTimeMillis());
            this.wait(remaining);
            if (this.tryLock(ownerId, targetLockLevel, reentrant)) {
                this.logger.logFiner(ownerId.toString() + " waiting on " + this.resourceId.toString() + " eventually got the lock at " + System.currentTimeMillis());
                return true;
            }
            remaining = timeoutMSecs - (System.currentTimeMillis() - started);
        }
        return false;
    }

    public synchronized void release(Object ownerId) {
        if (this.owners.remove(ownerId) != null) {
            this.logger.logFiner(ownerId.toString() + " releasing lock for " + this.resourceId.toString() + " at " + System.currentTimeMillis());
            this.notifyAll();
        }
    }

    public synchronized int getLockLevel(Object ownerId) {
        LockOwner owner = (LockOwner)this.owners.get(ownerId);
        if (owner == null) {
            return 0;
        }
        return owner.lockLevel;
    }

    public Object getResourceId() {
        return this.resourceId;
    }

    public int getLevelMinLock() {
        return 0;
    }

    public int getLevelMaxLock() {
        return this.maxLockLevel;
    }

    protected synchronized LockOwner getMaxLevelOwner() {
        return this.getMaxLevelOwnerNotMe(null);
    }

    protected synchronized LockOwner getMaxLevelOwnerNotMe(LockOwner me) {
        LockOwner maxOwner = null;
        Iterator it = this.owners.values().iterator();
        while (it.hasNext()) {
            LockOwner owner = (LockOwner)it.next();
            if (owner.equals(me) || maxOwner != null && maxOwner.lockLevel >= owner.lockLevel) continue;
            maxOwner = owner;
        }
        return maxOwner;
    }

    protected synchronized void setLockLevel(Object ownerId, LockOwner lock, int targetLockLevel) {
        if (lock != null) {
            this.logger.logFinest(ownerId.toString() + " upgrading lock for " + this.resourceId.toString() + " to level " + targetLockLevel + " at " + System.currentTimeMillis());
            lock.lockLevel = targetLockLevel;
        } else {
            this.logger.logFinest(ownerId.toString() + " getting new lock for " + this.resourceId.toString() + " at level " + targetLockLevel + " at " + System.currentTimeMillis());
            this.owners.put(ownerId, new LockOwner(ownerId, targetLockLevel));
        }
    }

    protected synchronized boolean tryLock(Object ownerId, int targetLockLevel, boolean reentrant) {
        LockOwner highestOwner;
        LockOwner myLock = (LockOwner)this.owners.get(ownerId);
        if (myLock != null && reentrant) {
            if (targetLockLevel <= myLock.lockLevel) {
                return true;
            }
            highestOwner = this.getMaxLevelOwnerNotMe(myLock);
        } else {
            highestOwner = this.getMaxLevelOwner();
        }
        int currentLockLevel = highestOwner != null ? highestOwner.lockLevel : this.getLevelMinLock();
        if (targetLockLevel <= this.getLevelMaxLock() - currentLockLevel) {
            this.setLockLevel(ownerId, myLock, targetLockLevel);
            return true;
        }
        return false;
    }

    private static class LockOwner {
        public Object ownerId;
        public int lockLevel;

        public LockOwner(Object ownerId, int lockLevel) {
            this.ownerId = ownerId;
            this.lockLevel = lockLevel;
        }
    }
}

