/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.structure;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.slide.common.ObjectValidationFailedException;
import org.apache.slide.common.UriPath;
import org.apache.slide.structure.LinkNode;
import org.apache.slide.structure.SubjectNode;
import org.apache.slide.util.Messages;

public abstract class ObjectNode
implements Serializable,
Cloneable {
    protected String uri;
    private String uuri;
    private Vector links = new Vector();
    private boolean linksShared;
    private BindingList bindings = new BindingList();
    private ParentBindingList parentBindings = new ParentBindingList();
    private boolean bindingsShared;
    private Vector childrenCache = null;
    private transient UriPath path = null;
    static /* synthetic */ Class class$org$apache$slide$structure$ObjectNode;

    public ObjectNode() {
    }

    public ObjectNode(String uri) {
        this();
        this.uri = uri;
    }

    public ObjectNode(String uri, Vector children, Vector links) {
        this(uri);
        this.links = links;
        this.addChildren(children);
    }

    public ObjectNode(String uuri, Vector bindings, Vector parentBindings, Vector links) {
        this();
        this.uuri = uuri;
        this.bindings = new BindingList(bindings);
        this.parentBindings = new ParentBindingList(parentBindings);
        this.links = links;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
        this.path = null;
    }

    public String getUuri() {
        if (this.uuri != null) {
            return this.uuri;
        }
        if (this.uri == null) {
            throw new IllegalStateException(this.toString());
        }
        return this.uri;
    }

    public void setUuri(String uuri) {
        if (uuri == null) {
            throw new IllegalArgumentException();
        }
        this.uuri = uuri;
    }

    public Vector getChildren() {
        if (this.childrenCache == null) {
            this.computeChildren();
        }
        return this.childrenCache;
    }

    public Enumeration enumerateChildren() {
        return this.getChildren().elements();
    }

    public Enumeration enumerateBindings() {
        return this.bindings.elements();
    }

    public Enumeration enumerateParentBindings() {
        return this.parentBindings.elements();
    }

    public String getBindingUuri(String bindingName) {
        String result = null;
        Binding b = this.bindings.get(bindingName);
        if (b != null) {
            result = b.getUuri();
        }
        return result;
    }

    public boolean hasChild(String uri) {
        return this.getChildren().contains(uri);
    }

    public boolean hasChild(ObjectNode child) {
        boolean result = false;
        if (child != null) {
            result = this.getChildren().contains(child.getUri());
        }
        return result;
    }

    public boolean hasBinding(String bindingName) {
        boolean result = false;
        if (bindingName != null) {
            result = this.bindings.get(bindingName) != null;
        }
        return result;
    }

    public boolean hasParentBinding(String bindingName) {
        boolean result = false;
        if (bindingName != null) {
            result = this.parentBindings.get(bindingName) != null;
        }
        return result;
    }

    public boolean hasBinding(ObjectNode child) {
        if (child != null) {
            Enumeration benum = this.enumerateBindings();
            while (benum.hasMoreElements()) {
                Binding b = (Binding)benum.nextElement();
                if (!b.getUuri().equals(child.getUuri())) continue;
                return true;
            }
        }
        return false;
    }

    public int numberOfParentBindings() {
        return this.parentBindings.size();
    }

    public boolean hasChildren() {
        return !this.getChildren().isEmpty();
    }

    public boolean hasLinks() {
        return !this.links.isEmpty();
    }

    public Enumeration enumerateLinks() {
        return this.links.elements();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ObjectNode) {
            return this.getPath().equals(((ObjectNode)obj).getPath());
        }
        return false;
    }

    public int hashCode() {
        return this.getPath().hashCode();
    }

    public ObjectNode cloneObject() {
        ObjectNode result = null;
        try {
            this.linksShared = true;
            this.bindingsShared = true;
            result = (ObjectNode)super.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return result;
    }

    public ObjectNode copyObject() {
        ObjectNode result = null;
        this.childrenCache = null;
        try {
            result = (ObjectNode)super.clone();
            result.linksShared = false;
            result.bindingsShared = false;
            result.links = new Vector();
            result.bindings = new BindingList();
            result.parentBindings = new ParentBindingList();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return result;
    }

    public void validate(String expectedUri) {
        if (this.uri == null) {
            throw new ObjectValidationFailedException(expectedUri, Messages.message((class$org$apache$slide$structure$ObjectNode == null ? (class$org$apache$slide$structure$ObjectNode = ObjectNode.class$("org.apache.slide.structure.ObjectNode")) : class$org$apache$slide$structure$ObjectNode).getName() + ".nullUri"));
        }
        if (!this.uri.equals(expectedUri) && !this.uuri.equals(expectedUri)) {
            throw new ObjectValidationFailedException(expectedUri, Messages.message((class$org$apache$slide$structure$ObjectNode == null ? (class$org$apache$slide$structure$ObjectNode = ObjectNode.class$("org.apache.slide.structure.ObjectNode")) : class$org$apache$slide$structure$ObjectNode).getName() + ".incorrectUri"));
        }
        if (this.bindings == null || this.parentBindings == null) {
            throw new ObjectValidationFailedException(this.uri, Messages.message((class$org$apache$slide$structure$ObjectNode == null ? (class$org$apache$slide$structure$ObjectNode = ObjectNode.class$("org.apache.slide.structure.ObjectNode")) : class$org$apache$slide$structure$ObjectNode).getName() + ".nullBindingsVector"));
        }
        if (this.links == null) {
            throw new ObjectValidationFailedException(this.uri, Messages.message((class$org$apache$slide$structure$ObjectNode == null ? (class$org$apache$slide$structure$ObjectNode = ObjectNode.class$("org.apache.slide.structure.ObjectNode")) : class$org$apache$slide$structure$ObjectNode).getName() + ".nullLinksVector"));
        }
    }

    public void addChild(ObjectNode child) {
        this.addBinding(child.getPath().lastSegment(), child);
    }

    public void addLink(LinkNode link) {
        this.links.add(link.getUri());
    }

    public void addBinding(String bindingName, ObjectNode source) {
        if (!this.hasBinding(bindingName)) {
            if (this.bindingsShared) {
                this.bindings = (BindingList)this.bindings.clone();
                this.parentBindings = (ParentBindingList)this.parentBindings.clone();
                this.bindingsShared = false;
            }
        } else {
            throw new IllegalStateException("Existing binding " + bindingName + " at " + this.uri + " has to be removed first");
        }
        this.bindings.put(bindingName, source);
        this.childrenCache = null;
        source.addParentBinding(bindingName, this);
    }

    public void removeChild(ObjectNode child) {
        if (child == null) {
            return;
        }
        if (this.bindingsShared) {
            this.bindings = (BindingList)this.bindings.clone();
            this.bindingsShared = false;
        }
        String bindingName = this.lastUriSegment(child.getUri());
        this.bindings.remove(bindingName);
        this.childrenCache = null;
        child.removeParentBinding(bindingName, this);
    }

    public void removeLink(LinkNode link) {
        this.links.remove(link.getUri());
    }

    public UriPath getPath() {
        if (this.path == null) {
            this.path = new UriPath(this.getUri());
        }
        return this.path;
    }

    private String lastUriSegment(String uri) {
        return new UriPath(uri).lastSegment();
    }

    private void computeChildren() {
        this.childrenCache = new Vector();
        Enumeration e = this.bindings.elements();
        while (e.hasMoreElements()) {
            Binding b = (Binding)e.nextElement();
            StringBuffer buf = new StringBuffer(this.uri);
            if (!this.uri.endsWith("/")) {
                buf.append("/");
            }
            buf.append(b.getName());
            this.childrenCache.add(buf.toString());
        }
    }

    private void addChildren(Vector children) {
        Enumeration ch = children.elements();
        while (ch.hasMoreElements()) {
            String c = (String)ch.nextElement();
            SubjectNode s = new SubjectNode(c);
            s.setUuri(s.getUri());
            this.addBinding(this.lastUriSegment(c), s);
        }
        SubjectNode p = null;
        UriPath up = new UriPath(this.uri);
        UriPath pup = up.parent();
        if (pup != null) {
            String pUri = pup.toString();
            p = new SubjectNode(pUri);
            p.setUuri(p.getUri());
        }
        this.addParentBinding(this.getPath().lastSegment(), p);
    }

    public void addParentBinding(String bindingName, ObjectNode parent) {
        if (this.bindingsShared) {
            this.bindings = (BindingList)this.bindings.clone();
            this.parentBindings = (ParentBindingList)this.parentBindings.clone();
            this.bindingsShared = false;
        }
        this.parentBindings.put(bindingName, parent);
    }

    private void removeParentBinding(String bindingName, ObjectNode parent) {
        if (this.bindingsShared) {
            this.bindings = (BindingList)this.bindings.clone();
            this.parentBindings = (ParentBindingList)this.parentBindings.clone();
            this.bindingsShared = false;
        }
        this.parentBindings.remove(bindingName, parent.getUuri());
    }

    public String toString() {
        StringBuffer b = new StringBuffer(this.getUri());
        if (!this.getUri().equals(this.getUuri())) {
            b.append(" [").append(this.getUuri()).append("]");
        }
        return b.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class BindingList
    implements Serializable,
    Cloneable {
        protected Vector container;

        private BindingList() {
            this.container = new Vector();
        }

        public BindingList(Vector container) {
            this.container = container;
        }

        private Enumeration elements() {
            return this.container.elements();
        }

        public Binding get(String bindingName) {
            Binding b = null;
            int i = this.container.indexOf(new Binding(bindingName, null));
            if (i >= 0) {
                b = (Binding)this.container.get(i);
            }
            return b;
        }

        private Binding put(String bindingName, ObjectNode source) {
            int i;
            Binding result = null;
            String uuri = "";
            if (source != null && source.getUuri() != null) {
                uuri = source.getUuri();
            }
            if ((i = this.container.indexOf(new Binding(bindingName, null))) >= 0) {
                result = (Binding)this.container.get(i);
                this.container.set(i, new Binding(bindingName, uuri));
            } else {
                this.container.add(new Binding(bindingName, uuri));
            }
            return result;
        }

        private void remove(String bindingName) {
            this.container.removeElement(new Binding(bindingName, null));
        }

        public synchronized Object clone() {
            return new BindingList((Vector)this.container.clone());
        }

        public String toString() {
            return String.valueOf(this.container);
        }

        public int size() {
            return this.container.size();
        }
    }

    public static class ParentBindingList
    extends BindingList {
        private ParentBindingList() {
        }

        public ParentBindingList(Vector container) {
            super(container);
        }

        private Enumeration elements() {
            return this.container.elements();
        }

        private ParentBinding put(String bindingName, ObjectNode source) {
            String uuri = "";
            if (source != null && source.getUuri() != null) {
                uuri = source.getUuri();
            }
            int i = this.container.indexOf(new ParentBinding(bindingName, uuri));
            ParentBinding result = null;
            if (i >= 0) {
                result = (ParentBinding)this.container.get(i);
                this.container.set(i, new ParentBinding(bindingName, uuri));
            } else {
                this.container.add(new ParentBinding(bindingName, uuri));
            }
            return result;
        }

        private void remove(String bindingName, String uuri) {
            this.container.removeElement(new ParentBinding(bindingName, uuri));
        }

        public synchronized Object clone() {
            return new ParentBindingList((Vector)this.container.clone());
        }

        public String toString() {
            return String.valueOf(this.container);
        }

        public int size() {
            return this.container.size();
        }
    }

    public static class ParentBinding
    extends Binding {
        public ParentBinding(String bindingName, String bindingUuri) {
            super(bindingName, bindingUuri);
        }

        public boolean equals(Object o) {
            boolean result = false;
            if (o instanceof ParentBinding) {
                ParentBinding b = (ParentBinding)o;
                result = this.getName().equals(b.getName()) && this.getUuri().equals(b.getUuri());
            }
            return result;
        }

        public String toString() {
            return this.bName + ":" + this.bUuri;
        }
    }

    public static class Binding
    implements Serializable,
    Cloneable {
        final String bName;
        final String bUuri;

        public Binding(String bindingName, String bindingUuri) {
            this.bName = bindingName;
            this.bUuri = bindingUuri;
        }

        public String getName() {
            return this.bName;
        }

        public String getUuri() {
            return this.bUuri;
        }

        public boolean equals(Object o) {
            boolean result = false;
            if (o instanceof Binding) {
                Binding b = (Binding)o;
                result = this.getName().equals(b.getName());
            }
            return result;
        }

        public String toString() {
            return this.bName + "->" + this.bUuri;
        }
    }
}

