/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.store.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class FileHelper {
    private static int BUF_SIZE = 50000;
    private static byte[] BUF = new byte[BUF_SIZE];

    public static void removeRec(File toRemove) {
        if (toRemove.isDirectory()) {
            File[] fileList = toRemove.listFiles();
            int a = 0;
            while (a < fileList.length) {
                FileHelper.removeRec(fileList[a]);
                ++a;
            }
        }
        toRemove.delete();
    }

    public static void moveRec(File sourceDir, File targetDir) throws IOException {
        byte[] sharedBuffer = new byte[BUF_SIZE];
        FileHelper.moveRec(sourceDir, targetDir, sharedBuffer);
    }

    static void moveRec(File sourceDir, File targetDir, byte[] sharedBuffer) throws IOException {
        if (sourceDir.isDirectory() && targetDir.isDirectory()) {
            File[] files = sourceDir.listFiles();
            int i = 0;
            while (i < files.length) {
                File file = files[i];
                File targetFile = new File(targetDir, file.getName());
                if (file.isFile()) {
                    if (targetFile.exists()) {
                        targetFile.delete();
                    }
                    if (!file.renameTo(targetFile)) {
                        FileHelper.copy(file, targetFile, sharedBuffer);
                        file.delete();
                    }
                } else {
                    targetFile.mkdirs();
                    FileHelper.moveRec(file, targetFile);
                }
                ++i;
            }
            sourceDir.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long copy(File input, File output) throws IOException {
        long l;
        block5: {
            FileInputStream in = null;
            try {
                in = new FileInputStream(input);
                l = FileHelper.copy((InputStream)in, output);
                Object var6_4 = null;
                if (in == null) break block5;
            }
            catch (Throwable throwable) {
                block6: {
                    Object var6_5 = null;
                    if (in == null) break block6;
                    try {
                        in.close();
                    }
                    catch (IOException e) {}
                }
                throw throwable;
            }
            try {
                in.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long copy(File input, File output, byte[] copyBuffer) throws IOException {
        long l;
        FileOutputStream out;
        block12: {
            FileInputStream in = null;
            out = null;
            try {
                in = new FileInputStream(input);
                out = new FileOutputStream(output);
                l = FileHelper.copy(in, out, copyBuffer);
                if (in == null) break block12;
            }
            catch (Throwable throwable) {
                block13: {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                    }
                    if (out == null) break block13;
                    try {
                        out.close();
                    }
                    catch (IOException e) {}
                }
                throw throwable;
            }
            try {
                in.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (out != null) {
            try {
                out.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long copy(InputStream in, File outputFile) throws IOException {
        long l;
        block5: {
            FileOutputStream out = null;
            try {
                out = new FileOutputStream(outputFile);
                l = FileHelper.copy(in, out);
                Object var6_4 = null;
                if (out == null) break block5;
            }
            catch (Throwable throwable) {
                block6: {
                    Object var6_5 = null;
                    if (out == null) break block6;
                    try {
                        out.close();
                    }
                    catch (IOException e) {}
                }
                throw throwable;
            }
            try {
                out.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return l;
    }

    public static long copy(InputStream in, OutputStream out) throws IOException {
        byte[] buf = new byte[BUF_SIZE];
        return FileHelper.copy(in, out, buf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long globalBufferCopy(InputStream in, OutputStream out) throws IOException {
        byte[] byArray = BUF;
        synchronized (BUF) {
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return FileHelper.copy(in, out, BUF);
        }
    }

    public static long copy(InputStream in, OutputStream out, byte[] copyBuffer) throws IOException {
        long bytesCopied = 0L;
        int read = -1;
        while ((read = in.read(copyBuffer, 0, copyBuffer.length)) != -1) {
            out.write(copyBuffer, 0, read);
            bytesCopied += (long)read;
        }
        return bytesCopied;
    }
}

