/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.store.txfile;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.slide.common.ServiceAccessException;
import org.apache.slide.common.Uri;
import org.apache.slide.content.NodeRevisionContent;
import org.apache.slide.content.NodeRevisionDescriptor;
import org.apache.slide.content.RevisionAlreadyExistException;
import org.apache.slide.content.RevisionNotFoundException;
import org.apache.slide.store.ContentStore;
import org.apache.slide.store.txfile.AbstractTxFileStoreService;
import org.apache.slide.store.txfile.rm.ResourceManagerException;
import org.apache.slide.store.util.FileHelper;

public class TxFileContentStore
extends AbstractTxFileStoreService
implements ContentStore {
    protected static final String LOG_CHANNEL = (class$org$apache$slide$store$txfile$TxFileContentStore == null ? (class$org$apache$slide$store$txfile$TxFileContentStore = TxFileContentStore.class$("org.apache.slide.store.txfile.TxFileContentStore")) : class$org$apache$slide$store$txfile$TxFileContentStore).getName();
    static /* synthetic */ Class class$org$apache$slide$store$txfile$TxFileContentStore;

    public NodeRevisionContent retrieveRevisionContent(Uri uri, NodeRevisionDescriptor revisionDescriptor) throws ServiceAccessException, RevisionNotFoundException {
        String revisionUri = uri.toString() + "_" + revisionDescriptor.getRevisionNumber();
        try {
            Object txId = this.getActiveTxId();
            InputStream is = txId != null ? this.rm.readResource(txId, revisionUri) : this.rm.readResource(revisionUri);
            NodeRevisionContent result = new NodeRevisionContent();
            result.setContent(is);
            return result;
        }
        catch (ResourceManagerException e) {
            if (e.getStatus() == 4002) {
                throw new RevisionNotFoundException(uri.toString(), revisionDescriptor.getRevisionNumber());
            }
            this.throwInternalError(e, uri.toString());
            return null;
        }
    }

    public void createRevisionContent(Uri uri, NodeRevisionDescriptor revisionDescriptor, NodeRevisionContent revisionContent) throws ServiceAccessException, RevisionAlreadyExistException {
        String revisionUri = uri.toString() + "_" + revisionDescriptor.getRevisionNumber();
        try {
            this.rm.createResource(this.getActiveTxId(), revisionUri, false);
            this.storeRevisionContent(uri, revisionDescriptor, revisionContent);
        }
        catch (RevisionNotFoundException e) {
            this.throwInternalError(e, uri.toString());
        }
        catch (ResourceManagerException e) {
            if (e.getStatus() == 4001) {
                throw new RevisionAlreadyExistException(uri.toString(), revisionDescriptor.getRevisionNumber());
            }
            this.throwInternalError(e, uri.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeRevisionContent(Uri uri, NodeRevisionDescriptor revisionDescriptor, NodeRevisionContent revisionContent) throws ServiceAccessException, RevisionNotFoundException {
        String revisionUri = uri.toString() + "_" + revisionDescriptor.getRevisionNumber();
        OutputStream os = null;
        InputStream is = null;
        try {
            os = this.rm.writeResource(this.getActiveTxId(), revisionUri);
            is = revisionContent.streamContent();
            if (is != null) {
                long contentBytes = FileHelper.copy(is, os);
                long contentLength = revisionDescriptor.getContentLength();
                revisionDescriptor.setContentLength(contentBytes);
                if (contentLength != -1L && contentBytes != contentLength) {
                    this.rm.deleteResource(this.getActiveTxId(), revisionUri);
                    this.throwInternalError("Content length does not match expected");
                }
            }
        }
        catch (IOException e) {
            this.throwInternalError(e, uri.toString());
        }
        catch (ResourceManagerException e) {
            if (e.getStatus() == 4002) {
                throw new RevisionNotFoundException(uri.toString(), revisionDescriptor.getRevisionNumber());
            }
            this.throwInternalError(e, uri.toString());
        }
        finally {
            try {
                if (os != null) {
                    os.close();
                }
            }
            catch (IOException e) {}
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {}
        }
    }

    public void removeRevisionContent(Uri uri, NodeRevisionDescriptor revisionDescriptor) throws ServiceAccessException {
        String revisionUri = uri.toString() + "_" + revisionDescriptor.getRevisionNumber();
        try {
            this.rm.deleteResource(this.getActiveTxId(), revisionUri);
        }
        catch (ResourceManagerException e) {
            this.throwInternalError(e, uri.toString());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

