/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.store.impl.rdbms;

import java.lang.reflect.Constructor;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.slide.common.Service;
import org.apache.slide.common.ServiceAccessException;
import org.apache.slide.common.Uri;
import org.apache.slide.content.NodeProperty;
import org.apache.slide.content.NodeRevisionContent;
import org.apache.slide.content.NodeRevisionDescriptor;
import org.apache.slide.content.NodeRevisionDescriptors;
import org.apache.slide.content.NodeRevisionNumber;
import org.apache.slide.content.RevisionAlreadyExistException;
import org.apache.slide.content.RevisionDescriptorNotFoundException;
import org.apache.slide.content.RevisionNotFoundException;
import org.apache.slide.lock.LockTokenNotFoundException;
import org.apache.slide.lock.NodeLock;
import org.apache.slide.security.NodePermission;
import org.apache.slide.store.impl.rdbms.AbstractRDBMSAdapter;
import org.apache.slide.structure.LinkNode;
import org.apache.slide.structure.ObjectAlreadyExistsException;
import org.apache.slide.structure.ObjectNode;
import org.apache.slide.structure.ObjectNotFoundException;
import org.apache.slide.util.logger.Logger;

public class OldJDBCAdapter
extends AbstractRDBMSAdapter {
    protected static final String LOG_CHANNEL = (class$org$apache$slide$store$impl$rdbms$StandardRDBMSAdapter == null ? (class$org$apache$slide$store$impl$rdbms$StandardRDBMSAdapter = OldJDBCAdapter.class$("org.apache.slide.store.impl.rdbms.StandardRDBMSAdapter")) : class$org$apache$slide$store$impl$rdbms$StandardRDBMSAdapter).getName();
    protected static final int OBJECTS_URI = 1;
    protected static final int OBJECTS_CLASS = 2;
    protected static final int CHILDREN_URI = 1;
    protected static final int CHILDREN_CHILDURI = 2;
    protected static final int LINKS_LINK = 1;
    protected static final int LINKS_LINKTO = 2;
    protected static final int PERMISSIONS_OBJECT = 1;
    protected static final int PERMISSIONS_REVISION_NUMBER = 2;
    protected static final int PERMISSIONS_SUBJECT = 3;
    protected static final int PERMISSIONS_ACTION = 4;
    protected static final int PERMISSIONS_INHERITABLE = 5;
    protected static final int PERMISSIONS_NEGATIVE = 6;
    protected static final int LOCKS_ID = 1;
    protected static final int LOCKS_OBJECT = 2;
    protected static final int LOCKS_SUBJECT = 3;
    protected static final int LOCKS_TYPE = 4;
    protected static final int LOCKS_EXPIRATIONDATE = 5;
    protected static final int LOCKS_INHERITABLE = 6;
    protected static final int LOCKS_EXCLUSIVE = 7;
    protected static final int LOCKS_OWNER = 8;
    protected static final int REVISIONS_URI = 1;
    protected static final int REVISIONS_ISVERSIONED = 2;
    protected static final int REVISIONS_INITIALREVISION = 3;
    protected static final int WORKINGREVISION_URI = 1;
    protected static final int WORKINGREVISION_BASEREVISION = 2;
    protected static final int WORKINGREVISION_NUMBER = 3;
    protected static final int LATESTREVISIONS_URI = 1;
    protected static final int LATESTREVISIONS_BRANCHNAME = 2;
    protected static final int LATESTREVISIONS_NUMBER = 3;
    protected static final int BRANCHES_URI = 1;
    protected static final int BRANCHES_NUMBER = 2;
    protected static final int BRANCHES_CHILDNUMBER = 3;
    protected static final int REVISION_URI = 1;
    protected static final int REVISION_NUMBER = 2;
    protected static final int REVISION_BRANCHNAME = 3;
    protected static final int LABEL_URI = 1;
    protected static final int LABEL_NUMBER = 2;
    protected static final int LABEL_LABEL = 3;
    protected static final int PROPERTY_URI = 1;
    protected static final int PROPERTY_NUMBER = 2;
    protected static final int PROPERTY_NAME = 3;
    protected static final int PROPERTY_VALUE = 4;
    protected static final int PROPERTY_NAMESPACE = 5;
    protected static final int PROPERTY_TYPE = 6;
    protected static final int PROPERTY_PROTECTED = 7;
    static /* synthetic */ Class class$org$apache$slide$store$impl$rdbms$StandardRDBMSAdapter;

    public OldJDBCAdapter(Service service, Logger logger) {
        super(service, logger);
    }

    public ObjectNode retrieveObject(Connection connection, Uri uri) throws ServiceAccessException, ObjectNotFoundException {
        ObjectNode result = null;
        PreparedStatement statement = null;
        try {
            try {
                statement = connection.prepareStatement("select * from objects where uri= ?");
                statement.setString(1, uri.toString());
                ResultSet res = statement.executeQuery();
                if (!res.next()) {
                    throw new ObjectNotFoundException(uri);
                }
                String className = res.getString(2);
                this.closeStatement(statement);
                statement = connection.prepareStatement("select * from children where uri= ?");
                statement.setString(1, uri.toString());
                res = statement.executeQuery();
                Vector<String> childrenVector = new Vector<String>();
                while (res.next()) {
                    childrenVector.addElement(res.getString(2));
                }
                this.closeStatement(statement);
                statement = connection.prepareStatement("select * from links where linkto= ?");
                statement.setString(1, uri.toString());
                res = statement.executeQuery();
                Vector<String> linksVector = new Vector<String>();
                while (res.next()) {
                    linksVector.addElement(res.getString(2));
                }
                this.closeStatement(statement);
                if (className.equals("org.apache.slide.structure.LinkNode")) {
                    String linkTo = new String();
                    statement = connection.prepareStatement("select * from links where link= ?");
                    statement.setString(1, uri.toString());
                    res = statement.executeQuery();
                    if (res.next()) {
                        linkTo = res.getString(2);
                    }
                    this.closeStatement(statement);
                    result = new LinkNode(uri.toString(), childrenVector, linksVector, linkTo);
                } else {
                    try {
                        Class<?> objclass = Class.forName(className);
                        Class[] argClasses = new Class[]{Class.forName("java.lang.String"), Class.forName("java.util.Vector"), Class.forName("java.util.Vector")};
                        Object[] arguments = new Object[]{uri.toString(), childrenVector, linksVector};
                        Constructor<?> constructor = objclass.getConstructor(argClasses);
                        result = (ObjectNode)constructor.newInstance(arguments);
                    }
                    catch (Exception e) {
                        throw this.createException(e, uri);
                    }
                }
                Object var14_16 = null;
                this.closeStatement(statement);
            }
            catch (SQLException e) {
                throw this.createException(e, uri);
            }
        }
        catch (Throwable throwable) {
            Object var14_17 = null;
            this.closeStatement(statement);
            throw throwable;
        }
        return result;
    }

    public void storeObject(Connection connection, Uri uri, ObjectNode object) throws ServiceAccessException, ObjectNotFoundException {
        PreparedStatement statement = null;
        try {
            block7: {
                try {
                    statement = connection.prepareStatement("select * from objects where uri= ?");
                    statement.setString(1, uri.toString());
                    ResultSet res = statement.executeQuery();
                    if (!res.next()) {
                        throw new ObjectNotFoundException(uri);
                    }
                    this.closeStatement(statement);
                    statement = connection.prepareStatement("delete from children where uri= ?");
                    statement.setString(1, object.getUri());
                    statement.execute();
                    this.closeStatement(statement);
                    statement = null;
                    Enumeration children = object.enumerateChildren();
                    while (children.hasMoreElements()) {
                        if (statement == null) {
                            statement = connection.prepareStatement("insert into children values(?, ?)");
                        }
                        statement.setString(1, object.getUri());
                        statement.setString(2, (String)children.nextElement());
                        statement.execute();
                    }
                    this.closeStatement(statement);
                    statement = connection.prepareStatement("delete from links where link= ?");
                    statement.setString(1, object.getUri());
                    statement.execute();
                    this.closeStatement(statement);
                    if (!(object instanceof LinkNode)) break block7;
                    statement = connection.prepareStatement("insert into links values(?,?)");
                    statement.setString(1, object.getUri());
                    statement.setString(2, ((LinkNode)object).getLinkedUri());
                    statement.execute();
                    this.closeStatement(statement);
                }
                catch (SQLException e) {
                    throw this.createException(e, uri);
                }
            }
            Object var8_8 = null;
            this.closeStatement(statement);
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            this.closeStatement(statement);
            throw throwable;
        }
    }

    public void createObject(Connection connection, Uri uri, ObjectNode object) throws ServiceAccessException, ObjectAlreadyExistsException {
        PreparedStatement statement = null;
        try {
            block7: {
                try {
                    String className = object.getClass().getName();
                    statement = connection.prepareStatement("select * from objects where uri= ?");
                    statement.setString(1, uri.toString());
                    ResultSet res = statement.executeQuery();
                    if (res.next()) {
                        throw new ObjectAlreadyExistsException(uri.toString());
                    }
                    this.closeStatement(statement);
                    statement = connection.prepareStatement("insert into objects values(?,?)");
                    statement.setString(1, uri.toString());
                    statement.setString(2, className);
                    statement.execute();
                    this.closeStatement(statement);
                    statement = null;
                    Enumeration children = object.enumerateChildren();
                    while (children.hasMoreElements()) {
                        if (statement == null) {
                            statement = connection.prepareStatement("insert into children values(?,?)");
                        }
                        statement.setString(1, uri.toString());
                        statement.setString(2, (String)children.nextElement());
                        statement.execute();
                    }
                    this.closeStatement(statement);
                    if (!(object instanceof LinkNode)) break block7;
                    statement = connection.prepareStatement("insert into links values(?,?)");
                    statement.setString(1, uri.toString());
                    statement.setString(2, ((LinkNode)object).getLinkedUri());
                    statement.execute();
                    this.closeStatement(statement);
                }
                catch (SQLException e) {
                    throw this.createException(e, uri);
                }
            }
            Object var9_9 = null;
            this.closeStatement(statement);
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            this.closeStatement(statement);
            throw throwable;
        }
    }

    public void removeObject(Connection connection, Uri uri, ObjectNode object) throws ServiceAccessException, ObjectNotFoundException {
        PreparedStatement statement = null;
        try {
            statement = connection.prepareStatement("delete from objects where uri= ?");
            statement.setString(1, object.getUri());
            statement.execute();
            this.closeStatement(statement);
            statement = connection.prepareStatement("delete from children where uri=?");
            statement.setString(1, object.getUri());
            statement.execute();
            this.closeStatement(statement);
            statement = connection.prepareStatement("delete from links where link= ?");
            statement.setString(1, object.getUri());
            statement.execute();
            this.closeStatement(statement);
        }
        catch (SQLException e) {
            throw this.createException(e, uri);
        }
    }

    public void grantPermission(Connection connection, Uri uri, NodePermission permission) throws ServiceAccessException {
        PreparedStatement statement = null;
        try {
            try {
                NodeRevisionNumber revisionNumber;
                int inheritable = 0;
                if (permission.isInheritable()) {
                    inheritable = 1;
                }
                int negative = 0;
                if (permission.isNegative()) {
                    negative = 1;
                }
                String revisionNumberStr = (revisionNumber = permission.getRevisionNumber()) == null ? null : revisionNumber.toString();
                statement = connection.prepareStatement("insert into permissions values(?,?,?,?,?,?)");
                statement.setString(1, permission.getObjectUri());
                statement.setString(2, revisionNumberStr);
                statement.setString(3, permission.getSubjectUri());
                statement.setString(4, permission.getActionUri());
                statement.setInt(5, inheritable);
                statement.setInt(6, negative);
                statement.execute();
            }
            catch (SQLException e) {
                throw this.createException(e, uri);
            }
            Object var10_10 = null;
            this.closeStatement(statement);
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            this.closeStatement(statement);
            throw throwable;
        }
    }

    public void revokePermission(Connection connection, Uri uri, NodePermission permission) throws ServiceAccessException {
        PreparedStatement statement = null;
        try {
            try {
                NodeRevisionNumber revisionNumber = permission.getRevisionNumber();
                if (revisionNumber != null) {
                    statement = connection.prepareStatement("delete from permissions where object= ? and subject = ? and action = ?  and revisionnumber = ? ");
                    statement.setString(4, revisionNumber.toString());
                } else {
                    statement = connection.prepareStatement("delete from permissions where object = ? and subject = ? and action = ? and revisionnumber is NULL");
                }
                statement.setString(1, permission.getObjectUri());
                statement.setString(2, permission.getSubjectUri());
                statement.setString(3, permission.getActionUri());
                statement.execute();
            }
            catch (SQLException e) {
                throw this.createException(e, uri);
            }
            Object var7_7 = null;
            this.closeStatement(statement);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.closeStatement(statement);
            throw throwable;
        }
    }

    public void revokePermissions(Connection connection, Uri uri) throws ServiceAccessException {
        PreparedStatement statement = null;
        try {
            try {
                statement = connection.prepareStatement("delete from permissions where object= ?");
                statement.setString(1, uri.toString());
                statement.execute();
            }
            catch (SQLException e) {
                throw this.createException(e, uri);
            }
            Object var6_4 = null;
            this.closeStatement(statement);
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            this.closeStatement(statement);
            throw throwable;
        }
    }

    public Enumeration enumeratePermissions(Connection connection, Uri uri) throws ServiceAccessException {
        Vector<NodePermission> permissionVector = new Vector<NodePermission>();
        PreparedStatement statement = null;
        try {
            try {
                statement = connection.prepareStatement("select * from permissions where object= ?");
                statement.setString(1, uri.toString());
                ResultSet res = statement.executeQuery();
                while (res.next()) {
                    String object = res.getString(1);
                    String revision = res.getString(2);
                    String subject = res.getString(3);
                    String action = res.getString(4);
                    boolean inheritable = false;
                    if (res.getInt(5) == 1) {
                        inheritable = true;
                    }
                    boolean negative = false;
                    if (res.getInt(6) == 1) {
                        negative = true;
                    }
                    NodePermission permission = new NodePermission(object, revision, subject, action, inheritable, negative);
                    permissionVector.addElement(permission);
                }
            }
            catch (SQLException e) {
                throw this.createException(e, uri);
            }
            Object var14_14 = null;
            this.closeStatement(statement);
        }
        catch (Throwable throwable) {
            Object var14_15 = null;
            this.closeStatement(statement);
            throw throwable;
        }
        return permissionVector.elements();
    }

    public void putLock(Connection connection, Uri uri, NodeLock lock) throws ServiceAccessException {
        PreparedStatement statement = null;
        try {
            try {
                int inheritable = 0;
                if (lock.isInheritable()) {
                    inheritable = 1;
                }
                int exclusive = 0;
                if (lock.isExclusive()) {
                    exclusive = 1;
                }
                statement = connection.prepareStatement("insert into locks values(?,?,?,?,?,?,?,?)");
                statement.setString(1, lock.getLockId());
                statement.setString(2, lock.getObjectUri());
                statement.setString(3, lock.getSubjectUri());
                statement.setString(4, lock.getTypeUri());
                statement.setString(5, String.valueOf(lock.getExpirationDate().getTime()));
                statement.setInt(6, inheritable);
                statement.setInt(7, exclusive);
                statement.setString(8, lock.getOwnerInfo());
                statement.execute();
            }
            catch (SQLException e) {
                throw this.createException(e, uri);
            }
            Object var8_8 = null;
            this.closeStatement(statement);
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            this.closeStatement(statement);
            throw throwable;
        }
    }

    public void renewLock(Connection connection, Uri uri, NodeLock lock) throws ServiceAccessException, LockTokenNotFoundException {
        PreparedStatement statement = null;
        try {
            try {
                int inheritable = 0;
                if (lock.isInheritable()) {
                    inheritable = 1;
                }
                int exclusive = 0;
                if (lock.isExclusive()) {
                    exclusive = 1;
                }
                statement = connection.prepareStatement("delete from locks where id=?");
                statement.setString(1, lock.getLockId());
                statement.execute();
                this.closeStatement(statement);
                statement = connection.prepareStatement("insert into locks values(?,?,?,?,?,?,?,?)");
                statement.setString(1, lock.getLockId());
                statement.setString(2, lock.getObjectUri());
                statement.setString(3, lock.getSubjectUri());
                statement.setString(4, lock.getTypeUri());
                statement.setString(5, String.valueOf(lock.getExpirationDate().getTime()));
                statement.setInt(6, inheritable);
                statement.setInt(7, exclusive);
                statement.setString(8, lock.getOwnerInfo());
                statement.execute();
            }
            catch (SQLException e) {
                throw this.createException(e, uri);
            }
            Object var8_8 = null;
            this.closeStatement(statement);
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            this.closeStatement(statement);
            throw throwable;
        }
    }

    public void removeLock(Connection connection, Uri uri, NodeLock lock) throws ServiceAccessException, LockTokenNotFoundException {
        Statement statement = null;
        try {
            try {
                statement = connection.createStatement();
                String s = null;
                s = "delete from locks where id='" + lock.getLockId() + "'";
                statement.execute(s);
            }
            catch (SQLException e) {
                throw this.createException(e, uri);
            }
            Object var7_7 = null;
            this.closeStatement(statement);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.closeStatement(statement);
            throw throwable;
        }
    }

    public void killLock(Connection connection, Uri uri, NodeLock lock) throws ServiceAccessException, LockTokenNotFoundException {
        this.removeLock(connection, uri, lock);
    }

    public Enumeration enumerateLocks(Connection connection, Uri uri) throws ServiceAccessException {
        Vector<NodeLock> lockVector = new Vector<NodeLock>();
        PreparedStatement statement = null;
        try {
            try {
                statement = connection.prepareStatement("select * from locks where object= ?");
                statement.setString(1, uri.toString());
                statement.execute();
                ResultSet res = statement.getResultSet();
                while (res.next()) {
                    Date expirationDate = null;
                    try {
                        Long timeValue = new Long(res.getString(5));
                        expirationDate = new Date(timeValue);
                    }
                    catch (NumberFormatException e) {
                        expirationDate = new Date();
                    }
                    NodeLock lock = new NodeLock(res.getString(1), res.getString(2), res.getString(3), res.getString(4), expirationDate, res.getInt(6) == 1, res.getInt(7) == 1, res.getString(8));
                    lockVector.addElement(lock);
                }
            }
            catch (SQLException e) {
                throw this.createException(e, uri);
            }
            Object var9_10 = null;
            this.closeStatement(statement);
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            this.closeStatement(statement);
            throw throwable;
        }
        return lockVector.elements();
    }

    public NodeRevisionDescriptors retrieveRevisionDescriptors(Connection connection, Uri uri) throws ServiceAccessException, RevisionDescriptorNotFoundException {
        NodeRevisionDescriptors revisionDescriptors = null;
        PreparedStatement statement = null;
        PreparedStatement statement2 = null;
        try {
            try {
                ResultSet res = null;
                NodeRevisionNumber initialRevision = new NodeRevisionNumber();
                Hashtable workingRevisions = new Hashtable();
                Hashtable<String, NodeRevisionNumber> latestRevisionNumbers = new Hashtable<String, NodeRevisionNumber>();
                Hashtable branches = new Hashtable();
                boolean isVersioned = false;
                statement = connection.prepareStatement("select * from revisions where uri= ?");
                statement.setString(1, uri.toString());
                res = statement.executeQuery();
                if (res.next()) {
                    int isVersionedInt = res.getInt(2);
                    if (isVersionedInt == 1) {
                        isVersioned = true;
                    }
                } else {
                    throw new RevisionDescriptorNotFoundException(uri.toString());
                }
                this.closeStatement(statement);
                statement = connection.prepareStatement("select * from workingrevision where uri= ?");
                statement.setString(1, uri.toString());
                res = statement.executeQuery();
                while (res.next()) {
                }
                this.closeStatement(statement);
                statement = connection.prepareStatement("select * from latestrevisions where uri=?");
                statement.setString(1, uri.toString());
                res = statement.executeQuery();
                while (res.next()) {
                    latestRevisionNumbers.put(res.getString(2), new NodeRevisionNumber(res.getString(3)));
                }
                this.closeStatement(statement);
                statement = connection.prepareStatement("select * from revision where uri= ?");
                statement.setString(1, uri.toString());
                res = statement.executeQuery();
                while (res.next()) {
                    String currentRevisionNumber = res.getString(2);
                    if (statement2 == null) {
                        statement2 = connection.prepareStatement("select * from branches where uri = ? and xnumber = ?");
                    }
                    statement2.setString(1, uri.toString());
                    statement2.setString(2, currentRevisionNumber);
                    ResultSet res2 = statement2.executeQuery();
                    Vector<NodeRevisionNumber> childList = new Vector<NodeRevisionNumber>();
                    while (res2.next()) {
                        childList.addElement(new NodeRevisionNumber(res2.getString(3)));
                    }
                    branches.put(new NodeRevisionNumber(currentRevisionNumber), childList);
                    res2.close();
                }
                this.closeStatement(statement2);
                revisionDescriptors = new NodeRevisionDescriptors(uri.toString(), initialRevision, workingRevisions, latestRevisionNumbers, branches, isVersioned);
            }
            catch (SQLException e) {
                throw this.createException(e, uri);
            }
            Object var16_17 = null;
            this.closeStatement(statement);
            this.closeStatement(statement2);
        }
        catch (Throwable throwable) {
            Object var16_18 = null;
            this.closeStatement(statement);
            this.closeStatement(statement2);
            throw throwable;
        }
        return revisionDescriptors;
    }

    public void createRevisionDescriptors(Connection connection, Uri uri, NodeRevisionDescriptors revisionDescriptors) throws ServiceAccessException {
        PreparedStatement statement = null;
        try {
            block5: {
                try {
                    int isVersioned = 0;
                    if (revisionDescriptors.isVersioned()) {
                        isVersioned = 1;
                    }
                    statement = connection.prepareStatement("insert into revisions values(?,?,?)");
                    statement.setString(1, uri.toString());
                    statement.setInt(2, isVersioned);
                    statement.setString(3, revisionDescriptors.getInitialRevision().toString());
                    statement.execute();
                    this.closeStatement(statement);
                    if (revisionDescriptors.getLatestRevision() == null) break block5;
                    statement = connection.prepareStatement("insert into latestrevisions values(?,?,?)");
                    statement.setString(1, uri.toString());
                    statement.setString(2, "main".toString());
                    statement.setString(3, revisionDescriptors.getLatestRevision().toString());
                    statement.execute();
                    this.closeStatement(statement);
                }
                catch (SQLException e) {
                    throw this.createException(e, uri);
                }
            }
            Object var7_7 = null;
            this.closeStatement(statement);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.closeStatement(statement);
            throw throwable;
        }
    }

    public void storeRevisionDescriptors(Connection connection, Uri uri, NodeRevisionDescriptors revisionDescriptors) throws ServiceAccessException, RevisionDescriptorNotFoundException {
        this.removeRevisionDescriptors(connection, uri);
        this.createRevisionDescriptors(connection, uri, revisionDescriptors);
    }

    public void removeRevisionDescriptors(Connection connection, Uri uri) throws ServiceAccessException {
        PreparedStatement statement = null;
        try {
            try {
                statement = connection.prepareStatement("delete from revisions where uri= ?");
                statement.setString(1, uri.toString());
                statement.execute();
                this.closeStatement(statement);
                statement = connection.prepareStatement("delete from workingrevision where uri= ?");
                statement.setString(1, uri.toString());
                statement.execute();
                this.closeStatement(statement);
                statement = connection.prepareStatement("delete from latestrevisions where uri= ?");
                statement.setString(1, uri.toString());
                statement.execute();
                this.closeStatement(statement);
                statement = connection.prepareStatement("delete from branches where uri= ?");
                statement.setString(1, uri.toString());
                statement.execute();
                this.closeStatement(statement);
            }
            catch (SQLException e) {
                throw this.createException(e, uri);
            }
            Object var6_4 = null;
            this.closeStatement(statement);
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            this.closeStatement(statement);
            throw throwable;
        }
    }

    public NodeRevisionDescriptor retrieveRevisionDescriptor(Connection connection, Uri uri, NodeRevisionNumber revisionNumber) throws ServiceAccessException, RevisionDescriptorNotFoundException {
        NodeRevisionDescriptor revisionDescriptor = null;
        PreparedStatement statement = null;
        if (revisionNumber == null) {
            throw new RevisionDescriptorNotFoundException(uri.toString());
        }
        try {
            try {
                ResultSet res = null;
                String branchName = null;
                Vector<String> labels = new Vector<String>();
                Hashtable<String, NodeProperty> properties = new Hashtable<String, NodeProperty>();
                statement = connection.prepareStatement("select * from revision where uri= ? and xnumber = ?");
                statement.setString(1, uri.toString());
                statement.setString(2, revisionNumber.toString());
                res = statement.executeQuery();
                if (!res.next()) {
                    throw new RevisionDescriptorNotFoundException(uri.toString());
                }
                branchName = res.getString(3);
                this.closeStatement(statement);
                statement = connection.prepareStatement("select * from label where uri= ? and xnumber = ?");
                statement.setString(1, uri.toString());
                statement.setString(2, revisionNumber.toString());
                res = statement.executeQuery();
                while (res.next()) {
                    labels.addElement(res.getString(3));
                }
                this.closeStatement(statement);
                statement = connection.prepareStatement("select * from property where uri= ? and xnumber = ?");
                statement.setString(1, uri.toString());
                statement.setString(2, revisionNumber.toString());
                res = statement.executeQuery();
                while (res.next()) {
                    String propertyName = res.getString(3);
                    String propertyNamespace = res.getString(5);
                    NodeProperty property = new NodeProperty(propertyName, res.getString(4), propertyNamespace, res.getString(6), res.getInt(7) == 1);
                    properties.put(propertyNamespace + propertyName, property);
                }
                revisionDescriptor = new NodeRevisionDescriptor(revisionNumber, branchName, labels, properties);
            }
            catch (SQLException e) {
                throw this.createException(e, uri);
            }
            Object var14_14 = null;
            this.closeStatement(statement);
        }
        catch (Throwable throwable) {
            Object var14_15 = null;
            this.closeStatement(statement);
            throw throwable;
        }
        return revisionDescriptor;
    }

    public void createRevisionDescriptor(Connection connection, Uri uri, NodeRevisionDescriptor revisionDescriptor) throws ServiceAccessException {
        PreparedStatement statement = null;
        try {
            try {
                statement = connection.prepareStatement("insert into revision values(?, ?, ?)");
                statement.setString(1, uri.toString());
                statement.setString(2, revisionDescriptor.getRevisionNumber().toString());
                statement.setString(3, revisionDescriptor.getBranchName());
                statement.execute();
                this.closeStatement(statement);
                statement = null;
                Enumeration labels = revisionDescriptor.enumerateLabels();
                while (labels.hasMoreElements()) {
                    if (statement == null) {
                        statement = connection.prepareStatement("insert into label values(?,?,?)");
                    }
                    statement.setString(1, uri.toString());
                    statement.setString(2, revisionDescriptor.getRevisionNumber().toString());
                    statement.setString(3, (String)labels.nextElement());
                    statement.execute();
                }
                this.closeStatement(statement);
                statement = null;
                Enumeration properties = revisionDescriptor.enumerateProperties();
                while (properties.hasMoreElements()) {
                    NodeProperty property = (NodeProperty)properties.nextElement();
                    int protectedProperty = 0;
                    if (property.isProtected()) {
                        protectedProperty = 1;
                    }
                    if (statement == null) {
                        statement = connection.prepareStatement("insert into property values(?,?,?,?,?,?,?)");
                    }
                    statement.setString(1, uri.toString());
                    statement.setString(2, revisionDescriptor.getRevisionNumber().toString());
                    statement.setString(3, property.getName());
                    statement.setString(4, property.getValue().toString());
                    statement.setString(5, property.getNamespace());
                    statement.setString(6, property.getType());
                    statement.setInt(7, protectedProperty);
                    statement.execute();
                }
                this.closeStatement(statement);
            }
            catch (SQLException e) {
                throw this.createException(e, uri);
            }
            Object var10_10 = null;
            this.closeStatement(statement);
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            this.closeStatement(statement);
            throw throwable;
        }
    }

    public void storeRevisionDescriptor(Connection connection, Uri uri, NodeRevisionDescriptor revisionDescriptor) throws ServiceAccessException, RevisionDescriptorNotFoundException {
        this.removeRevisionDescriptor(connection, uri, revisionDescriptor.getRevisionNumber());
        this.createRevisionDescriptor(connection, uri, revisionDescriptor);
    }

    public void removeRevisionDescriptor(Connection connection, Uri uri, NodeRevisionNumber number) throws ServiceAccessException {
        PreparedStatement statement = null;
        try {
            try {
                statement = connection.prepareStatement("delete from revision where uri= ? and xnumber = ?");
                statement.setString(1, uri.toString());
                statement.setString(2, number.toString());
                statement.execute();
                this.closeStatement(statement);
                statement = connection.prepareStatement("delete from label where uri= ? and xnumber = ?");
                statement.setString(1, uri.toString());
                statement.setString(2, number.toString());
                statement.execute();
                this.closeStatement(statement);
                statement = connection.prepareStatement("delete from property where uri= ? and xnumber = ?");
                statement.setString(1, uri.toString());
                statement.setString(2, number.toString());
                statement.execute();
            }
            catch (SQLException e) {
                throw this.createException(e, uri);
            }
            Object var7_5 = null;
            this.closeStatement(statement);
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            this.closeStatement(statement);
            throw throwable;
        }
    }

    protected void closeStatement(Statement statement) {
        try {
            if (statement != null) {
                statement.close();
            }
        }
        catch (SQLException e) {
            this.getLogger().log(e, LOG_CHANNEL, 4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void close(PreparedStatement statement, ResultSet resultSet) {
        try {
            if (resultSet != null) {
                resultSet.close();
            }
        }
        catch (SQLException e) {
            this.getLogger().log(this, e, LOG_CHANNEL, 4);
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException e) {
                this.getLogger().log(e, LOG_CHANNEL, 4);
            }
        }
    }

    protected ServiceAccessException createException(Exception e, Uri uri) {
        this.getLogger().log("Error  on " + uri.toString() + ": " + e.getMessage(), LOG_CHANNEL, 2);
        return new ServiceAccessException(this.service, (Throwable)e);
    }

    protected ServiceAccessException createException(SQLException e, Uri uri) {
        e.printStackTrace();
        this.getLogger().log("Error " + e.getErrorCode() + "," + e.getSQLState() + " on " + uri.toString() + ": " + e.getMessage(), LOG_CHANNEL, 2);
        return new ServiceAccessException(this.service, (Throwable)e);
    }

    public NodeRevisionContent retrieveRevisionContent(Connection conn, Uri uri, NodeRevisionDescriptor revisionDescriptor, boolean temporaryConnection) throws ServiceAccessException, RevisionNotFoundException {
        throw this.createException(new UnsupportedOperationException("ContentStore interface not suported"), uri);
    }

    public void createRevisionContent(Connection conn, Uri uri, NodeRevisionDescriptor revisionDescriptor, NodeRevisionContent revisionContent) throws ServiceAccessException, RevisionAlreadyExistException {
        throw this.createException(new UnsupportedOperationException("ContentStore interface not suported"), uri);
    }

    public void storeRevisionContent(Connection conn, Uri uri, NodeRevisionDescriptor revisionDescriptor, NodeRevisionContent revisionContent) throws ServiceAccessException, RevisionNotFoundException {
        throw this.createException(new UnsupportedOperationException("ContentStore interface not suported"), uri);
    }

    public void removeRevisionContent(Connection conn, Uri uri, NodeRevisionDescriptor revisionDescriptor) throws ServiceAccessException {
        throw this.createException(new UnsupportedOperationException("ContentStore interface not suported"), uri);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

