/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.store;

import java.util.Enumeration;
import org.apache.slide.common.Namespace;
import org.apache.slide.common.Scope;
import org.apache.slide.common.ScopeTokenizer;
import org.apache.slide.common.ServiceAccessException;
import org.apache.slide.common.ServiceConnectionFailedException;
import org.apache.slide.common.ServiceMissingOnRootNodeException;
import org.apache.slide.common.SlideToken;
import org.apache.slide.common.Uri;
import org.apache.slide.common.UriPath;
import org.apache.slide.content.NodeProperty;
import org.apache.slide.store.Store;
import org.apache.slide.util.Configuration;
import org.apache.slide.util.XMLValue;
import org.jdom.Element;

public final class ResourceId
extends Uri {
    public static String RESOURCE_ID_SCHEMA = "urn:uuid:";
    private static final String TIMESTAMP = String.valueOf(System.currentTimeMillis());
    private static int counter = 0;
    private final String uuri;
    static /* synthetic */ Class class$org$apache$slide$store$ResourceId;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResourceId createNew(Uri uri) {
        String newUuri;
        boolean useBinding = Configuration.useBinding(uri.getStore());
        if (useBinding) {
            String scopeSlash = uri.getScope().toString();
            if (!"/".equals(scopeSlash)) {
                scopeSlash = scopeSlash + "/";
            }
            Class clazz = class$org$apache$slide$store$ResourceId == null ? (class$org$apache$slide$store$ResourceId = ResourceId.class$("org.apache.slide.store.ResourceId")) : class$org$apache$slide$store$ResourceId;
            synchronized (clazz) {
                newUuri = uri.isStoreRoot() ? scopeSlash : scopeSlash + TIMESTAMP + "." + counter++;
            }
        } else {
            newUuri = uri.toString();
        }
        return new ResourceId(uri, newUuri);
    }

    public static ResourceId create(Uri uri, String uuri) {
        return new ResourceId(uri, uuri);
    }

    private static String resourceIdSchema(Store store) {
        if (Configuration.useBinding(store)) {
            return RESOURCE_ID_SCHEMA;
        }
        return "";
    }

    private ResourceId(Uri uri, String uuri) {
        super(uri.getToken(), uri.getNamespace(), uri.toString());
        this.uuri = uuri;
        this.parseUuri(uuri);
    }

    public boolean equals(Object obj) {
        if (obj instanceof ResourceId) {
            ResourceId resourceId = (ResourceId)obj;
            return this.getNamespace() == resourceId.getNamespace() && this.getStore() == resourceId.getStore() && this.uuri.equals(resourceId.uuri);
        }
        return false;
    }

    public String toString() {
        return this.uuri;
    }

    public String getUuri() {
        return this.uuri;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public Scope getScope() {
        return super.getScope();
    }

    public Store getStore() {
        return super.getStore();
    }

    public SlideToken getToken() {
        return super.getToken();
    }

    public Namespace getNamespace() {
        return super.getNamespace();
    }

    public boolean isStoreRoot() {
        UriPath thisPath = new UriPath(this.uuri);
        UriPath scopePath = new UriPath(this.scope.toString());
        return thisPath.equals(scopePath);
    }

    public void setUri(String uri) {
        throw new UnsupportedOperationException();
    }

    public Enumeration getScopes() {
        throw new UnsupportedOperationException();
    }

    public void setToken(SlideToken token) {
        throw new UnsupportedOperationException();
    }

    public Uri getParentUri() {
        throw new UnsupportedOperationException();
    }

    public void invalidateServices() {
        throw new UnsupportedOperationException();
    }

    public void reconnectServices() {
        throw new UnsupportedOperationException();
    }

    public String getRelative() {
        throw new UnsupportedOperationException();
    }

    public Uri cloneObject() {
        throw new UnsupportedOperationException();
    }

    public boolean isParent(Uri uri) {
        throw new UnsupportedOperationException();
    }

    public String asXml() {
        XMLValue r = new XMLValue();
        Element hrefElm = new Element("href", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
        hrefElm.setText(ResourceId.resourceIdSchema(this.getStore()) + this.getUuri());
        r.add(hrefElm);
        return r.toString();
    }

    private void parseUuri(String uuri) {
        this.scopes = new ScopeTokenizer(this.token, this.namespace, uuri);
        this.store = null;
        while (this.store == null && this.scopes.hasMoreElements()) {
            Scope courScope = this.scopes.nextScope();
            try {
                this.store = this.token == null ? this.namespace.retrieveStore(courScope, null) : this.namespace.retrieveStore(courScope, this.token.getCredentialsToken());
                if (this.store == null) continue;
                this.scope = courScope;
            }
            catch (ServiceConnectionFailedException e) {
            }
            catch (ServiceAccessException e) {
                // empty catch block
            }
        }
        if (this.store == null) {
            throw new ServiceMissingOnRootNodeException();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

