/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.store;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.apache.slide.common.ServiceAccessException;
import org.apache.slide.common.ServiceParameterErrorException;
import org.apache.slide.common.ServiceParameterMissingException;
import org.apache.slide.common.Uri;
import org.apache.slide.content.NodeRevisionContent;
import org.apache.slide.content.NodeRevisionDescriptor;
import org.apache.slide.content.NodeRevisionDescriptors;
import org.apache.slide.content.NodeRevisionNumber;
import org.apache.slide.content.RevisionAlreadyExistException;
import org.apache.slide.content.RevisionDescriptorNotFoundException;
import org.apache.slide.content.RevisionNotFoundException;
import org.apache.slide.lock.LockTokenNotFoundException;
import org.apache.slide.lock.NodeLock;
import org.apache.slide.security.NodePermission;
import org.apache.slide.store.AbstractStore;
import org.apache.slide.structure.LinkNode;
import org.apache.slide.structure.ObjectAlreadyExistsException;
import org.apache.slide.structure.ObjectNode;
import org.apache.slide.structure.ObjectNotFoundException;
import org.apache.slide.util.ByteSizeLimitedObjectCache;
import org.apache.slide.util.ObjectCache;
import org.apache.slide.util.TxLRUObjectCache;
import org.apache.slide.util.XidWrapper;

public class ExtendedStore
extends AbstractStore {
    private static final String LOG_CHANNEL = (class$org$apache$slide$store$ExtendedStore == null ? (class$org$apache$slide$store$ExtendedStore = ExtendedStore.class$("org.apache.slide.store.ExtendedStore")) : class$org$apache$slide$store$ExtendedStore).getName();
    private static final boolean globalCacheOff = false;
    protected static final int DEFAULT_OBJECT_GLOBAL_CACHE_SIZE = 10000;
    protected static final String GLOBAL_OBJECT_CACHE_SIZE_PARAMETER = "object-cache-size";
    protected static final int DEFAULT_GLOBAL_PERMISSION_CACHE_SIZE = 10000;
    protected static final String GLOBAL_PERMISSION_CACHE_SIZE_PARAMETER = "permission-cache-size";
    protected static final int DEFAULT_GLOBAL_LOCK_CACHE_SIZE = 100;
    protected static final String GLOBAL_LOCK_CACHE_SIZE_PARAMETER = "lock-cache-size";
    protected static final int DEFAULT_GLOBAL_DESCRIPTORS_CACHE_SIZE = 10000;
    protected static final String GLOBAL_DESCRIPTORS_CACHE_SIZE_PARAMETER = "descriptors-cache-size";
    protected static final int DEFAULT_GLOBAL_DESCRIPTOR_CACHE_SIZE = 10000;
    protected static final String GLOBAL_DESCRIPTOR_CACHE_SIZE_PARAMETER = "descriptor-cache-size";
    protected static final int DEFAULT_GLOBAL_CONTENT_CACHE_SIZE = 10000;
    protected static final String GLOBAL_CONTENT_CACHE_SIZE_PARAMETER = "content-cache-size";
    protected static final boolean DEFAULT_ENABLE_CONTENT_CACHING = false;
    protected static final String ENABLE_CONTENT_CACHING_PARAMETER = "enable-content-caching";
    protected static final int DEFAULT_TX_CONTENT_CACHE_SIZE = 1000;
    protected static final String TX_CONTENT_CACHE_SIZE_PARAMETER = "tx-content-cache-size";
    protected static final long DEFAULT_CONTENT_CACHE_BYTES = 10000000L;
    protected static final String CONTENT_CACHE_BYTES_PARAMETER = "content-cache-bytes";
    protected static final long DEFAULT_TX_CONTENT_CACHE_BYTES = 1000000L;
    protected static final String TX_CONTENT_CACHE_BYTES_PARAMETER = "tx-content-cache-bytes";
    protected static final long DEFAULT_MAX_CONTENT_BYTES_PER_ENTRY = 50000L;
    protected static final String MAX_CONTENT_BYTES_PER_ENTRY_PARAMETER = "max-content-bytes-per-entry";
    protected ThreadLocal activeTransactionBranch = new ThreadLocal();
    protected TxContentCacheWrapper contentCache;
    protected TxCacheWrapper objectsCache;
    protected TxCacheWrapper permissionsCache;
    protected TxCacheWrapper locksCache;
    protected TxCacheWrapper descriptorsCache;
    protected TxCacheWrapper descriptorCache;
    static /* synthetic */ Class class$org$apache$slide$store$ExtendedStore;

    public void setParameters(Hashtable parameters) throws ServiceParameterErrorException, ServiceParameterMissingException {
        super.setParameters(parameters);
        int globalObjectCacheSize = 10000;
        int globalPermissionCacheSize = 10000;
        int globalLockCacheSize = 100;
        int globalDescrtiptorsCacheSize = 10000;
        int globalDescrtiptorCacheSize = 10000;
        boolean contentCachingEnabled = false;
        int globalContentCacheSize = 10000;
        long contentCacheBytes = 10000000L;
        int txContentCacheSize = 1000;
        long txContentCacheBytes = 1000000L;
        long maxByteSizePerEntry = 50000L;
        String globalObjectCacheSizeString = (String)parameters.get(GLOBAL_OBJECT_CACHE_SIZE_PARAMETER);
        if (globalObjectCacheSizeString != null) {
            try {
                globalObjectCacheSize = Integer.parseInt(globalObjectCacheSizeString);
            }
            catch (NumberFormatException nfe) {
                this.getLogger().log("Cache size must be an integer! Using default size", LOG_CHANNEL, 4);
            }
        }
        this.getLogger().log("Setting object cache size for store " + this.getName() + " to " + globalObjectCacheSize, 6);
        String globalPermissionCacheSizeString = (String)parameters.get(GLOBAL_PERMISSION_CACHE_SIZE_PARAMETER);
        if (globalPermissionCacheSizeString != null) {
            try {
                globalPermissionCacheSize = Integer.parseInt(globalPermissionCacheSizeString);
            }
            catch (NumberFormatException nfe) {
                this.getLogger().log("Cache size must be an integer! Using default size", LOG_CHANNEL, 4);
            }
        }
        this.getLogger().log("Setting permission cache size for store " + this.getName() + " to " + globalPermissionCacheSize, LOG_CHANNEL, 6);
        String globalLockCacheSizeString = (String)parameters.get(GLOBAL_LOCK_CACHE_SIZE_PARAMETER);
        if (globalLockCacheSizeString != null) {
            try {
                globalLockCacheSize = Integer.parseInt(globalLockCacheSizeString);
            }
            catch (NumberFormatException nfe) {
                this.getLogger().log("Cache size must be an integer! Using default size", LOG_CHANNEL, 4);
            }
        }
        this.getLogger().log("Setting lock cache size for store " + this.getName() + " to " + globalLockCacheSize, LOG_CHANNEL, 6);
        String globalDescriptorsCacheSizeString = (String)parameters.get(GLOBAL_DESCRIPTORS_CACHE_SIZE_PARAMETER);
        if (globalDescriptorsCacheSizeString != null) {
            try {
                globalDescrtiptorsCacheSize = Integer.parseInt(globalDescriptorsCacheSizeString);
            }
            catch (NumberFormatException nfe) {
                this.getLogger().log("Cache size must be an integer! Using default size", LOG_CHANNEL, 4);
            }
        }
        this.getLogger().log("Setting descriptors cache size for store " + this.getName() + " to " + globalDescrtiptorsCacheSize, LOG_CHANNEL, 6);
        String globalDescriptorCacheSizeString = (String)parameters.get(GLOBAL_DESCRIPTOR_CACHE_SIZE_PARAMETER);
        if (globalDescriptorCacheSizeString != null) {
            try {
                globalDescrtiptorCacheSize = Integer.parseInt(globalDescriptorCacheSizeString);
            }
            catch (NumberFormatException nfe) {
                this.getLogger().log("Cache size must be an integer! Using default size", LOG_CHANNEL, 4);
            }
        }
        this.getLogger().log("Setting descriptor cache size for store " + this.getName() + " to " + globalDescrtiptorCacheSize, LOG_CHANNEL, 6);
        String enableContentCachingString = (String)parameters.get(ENABLE_CONTENT_CACHING_PARAMETER);
        if (enableContentCachingString != null) {
            contentCachingEnabled = Boolean.valueOf(enableContentCachingString);
        }
        this.getLogger().log("Setting content caching for store " + this.getName() + " to " + contentCachingEnabled, LOG_CHANNEL, 6);
        String globalContentCacheSizeString = (String)parameters.get(GLOBAL_CONTENT_CACHE_SIZE_PARAMETER);
        if (globalContentCacheSizeString != null) {
            try {
                globalContentCacheSize = Integer.parseInt(globalContentCacheSizeString);
            }
            catch (NumberFormatException nfe) {
                this.getLogger().log("Cache size must be an integer! Using default size", LOG_CHANNEL, 4);
            }
        }
        this.getLogger().log("Setting content cache size for store " + this.getName() + " to " + globalContentCacheSize, LOG_CHANNEL, 6);
        String contentCacheBytesString = (String)parameters.get(CONTENT_CACHE_BYTES_PARAMETER);
        if (contentCacheBytesString != null) {
            try {
                contentCacheBytes = Long.parseLong(contentCacheBytesString);
            }
            catch (NumberFormatException nfe) {
                this.getLogger().log("Content cache byte size must be an integer! Using default size", LOG_CHANNEL, 4);
            }
        }
        this.getLogger().log("Setting content cache byte size for store " + this.getName() + " to " + contentCacheBytes, LOG_CHANNEL, 6);
        String txContentCacheSizeString = (String)parameters.get(TX_CONTENT_CACHE_SIZE_PARAMETER);
        if (txContentCacheSizeString != null) {
            try {
                txContentCacheSize = Integer.parseInt(txContentCacheSizeString);
            }
            catch (NumberFormatException nfe) {
                this.getLogger().log("Content transaction cache size must be an integer! Using default size", LOG_CHANNEL, 4);
            }
        }
        this.getLogger().log("Setting transaction content cache size for store " + this.getName() + " to " + txContentCacheSize, LOG_CHANNEL, 6);
        String txContentCacheBytesString = (String)parameters.get(TX_CONTENT_CACHE_BYTES_PARAMETER);
        if (txContentCacheBytesString != null) {
            try {
                txContentCacheBytes = Long.parseLong(txContentCacheBytesString);
            }
            catch (NumberFormatException nfe) {
                this.getLogger().log("Transaction content cache byte size must be an integer! Using default size", LOG_CHANNEL, 4);
            }
        }
        this.getLogger().log("Setting transaction content cache byte size for store " + this.getName() + " to " + txContentCacheBytes, LOG_CHANNEL, 6);
        String maxByteSizePerEntryString = (String)parameters.get(MAX_CONTENT_BYTES_PER_ENTRY_PARAMETER);
        if (maxByteSizePerEntryString != null) {
            try {
                maxByteSizePerEntry = Long.parseLong(maxByteSizePerEntryString);
            }
            catch (NumberFormatException nfe) {
                this.getLogger().log("Maximum byte size for content cache entry must be an integer! Using default size", LOG_CHANNEL, 4);
            }
        }
        this.getLogger().log("Setting maximum byte size for content cache entry for store " + this.getName() + " to " + maxByteSizePerEntry, LOG_CHANNEL, 6);
        this.init(globalObjectCacheSize, globalPermissionCacheSize, globalLockCacheSize, globalDescrtiptorsCacheSize, globalDescrtiptorCacheSize, contentCachingEnabled, globalContentCacheSize, contentCacheBytes, txContentCacheSize, txContentCacheBytes, maxByteSizePerEntry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeRevisionContent retrieveRevisionContent(Uri uri, NodeRevisionDescriptor revisionDescriptor) throws ServiceAccessException, RevisionNotFoundException {
        if (this.contentStore.cacheResults() && this.contentCache != null && !this.omitCachingBecauseOfEvilHistoryHack(uri)) {
            String key;
            block8: {
                NodeRevisionContent nodeRevisionContent;
                if (this.isForceStoreEnlistment(uri)) {
                    this.enlist(this);
                }
                try {
                    key = uri.toString() + "_" + revisionDescriptor.getRevisionNumber();
                    Object result = this.contentCache.get(key);
                    if (result == null) break block8;
                    this.getLogger().log("Retrieving content at '" + key + "' from cache", LOG_CHANNEL, 7);
                    nodeRevisionContent = (NodeRevisionContent)result;
                    Object var10_7 = null;
                }
                catch (Throwable throwable) {
                    Object var10_9 = null;
                    if (this.isForceStoreEnlistment(uri)) {
                        this.delist(this);
                    }
                    throw throwable;
                }
                if (this.isForceStoreEnlistment(uri)) {
                    this.delist(this);
                }
                return nodeRevisionContent;
            }
            NodeRevisionContent revisionContent = super.retrieveRevisionContent(uri, revisionDescriptor);
            long size = revisionDescriptor.getContentLength();
            this.contentCache.put(key, revisionContent, size);
            NodeRevisionContent nodeRevisionContent = revisionContent;
            Object var10_8 = null;
            if (this.isForceStoreEnlistment(uri)) {
                this.delist(this);
            }
            return nodeRevisionContent;
        }
        return super.retrieveRevisionContent(uri, revisionDescriptor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createRevisionContent(Uri uri, NodeRevisionDescriptor revisionDescriptor, NodeRevisionContent revisionContent) throws ServiceAccessException, RevisionAlreadyExistException {
        long size = -1L;
        if (this.contentStore.cacheResults() && this.contentCache != null) {
            size = revisionDescriptor.getContentLength();
            this.contentCache.precache(revisionContent, size);
        }
        super.createRevisionContent(uri, revisionDescriptor, revisionContent);
        if (this.contentStore.cacheResults() && this.contentCache != null) {
            this.enlist(this);
            try {
                String key = uri.toString() + "_" + revisionDescriptor.getRevisionNumber();
                this.contentCache.put(key, revisionContent, size);
                Object var8_6 = null;
            }
            catch (Throwable throwable) {
                Object var8_7 = null;
                this.delist(this);
                throw throwable;
            }
            this.delist(this);
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeRevisionContent(Uri uri, NodeRevisionDescriptor revisionDescriptor, NodeRevisionContent revisionContent) throws ServiceAccessException, RevisionNotFoundException {
        long size = -1L;
        if (this.contentStore.cacheResults() && this.contentCache != null) {
            size = revisionDescriptor.getContentLength();
            this.contentCache.precache(revisionContent, size);
        }
        super.storeRevisionContent(uri, revisionDescriptor, revisionContent);
        if (this.contentStore.cacheResults() && this.contentCache != null) {
            this.enlist(this);
            try {
                String key = uri.toString() + "_" + revisionDescriptor.getRevisionNumber();
                this.contentCache.put(key, revisionContent, size);
                Object var8_6 = null;
            }
            catch (Throwable throwable) {
                Object var8_7 = null;
                this.delist(this);
                throw throwable;
            }
            this.delist(this);
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRevisionContent(Uri uri, NodeRevisionDescriptor revisionDescriptor) throws ServiceAccessException {
        if (this.contentStore.cacheResults() && this.contentCache != null) {
            this.enlist(this);
            try {
                String key = uri.toString() + "_" + revisionDescriptor.getRevisionNumber();
                this.contentCache.remove(key);
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                this.delist(this);
                throw throwable;
            }
            this.delist(this);
            {
            }
        }
        super.removeRevisionContent(uri, revisionDescriptor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectNode retrieveObject(Uri uri) throws ServiceAccessException, ObjectNotFoundException {
        if (this.nodeStore.cacheResults() && !this.omitCachingBecauseOfEvilHistoryHack(uri)) {
            block8: {
                ObjectNode objectNode;
                if (this.isForceStoreEnlistment(uri)) {
                    this.enlist(this);
                }
                try {
                    Object tempObject = this.objectsCache.get(uri.toString());
                    if (tempObject == null) break block8;
                    objectNode = ((ObjectNode)tempObject).cloneObject();
                    Object var6_5 = null;
                }
                catch (Throwable throwable) {
                    Object var6_7 = null;
                    if (this.isForceStoreEnlistment(uri)) {
                        this.delist(this);
                    }
                    throw throwable;
                }
                if (this.isForceStoreEnlistment(uri)) {
                    this.delist(this);
                }
                return objectNode;
            }
            ObjectNode objectNode = super.retrieveObject(uri);
            objectNode.validate(uri.toString());
            this.objectsCache.put(uri.toString(), objectNode);
            ObjectNode objectNode2 = objectNode.cloneObject();
            Object var6_6 = null;
            if (this.isForceStoreEnlistment(uri)) {
                this.delist(this);
            }
            return objectNode2;
        }
        return super.retrieveObject(uri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeObject(Uri uri, ObjectNode object) throws ServiceAccessException, ObjectNotFoundException {
        super.storeObject(uri, object);
        if (this.nodeStore.cacheResults()) {
            this.enlist(this);
            try {
                this.objectsCache.put(uri.toString(), object.cloneObject());
                Object var4_3 = null;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                this.delist(this);
                throw throwable;
            }
            this.delist(this);
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createObject(Uri uri, ObjectNode object) throws ServiceAccessException, ObjectAlreadyExistsException {
        super.createObject(uri, object);
        if (this.nodeStore.cacheResults()) {
            this.enlist(this);
            try {
                String linkedUri;
                ObjectNode linkedObject;
                if (object instanceof LinkNode && (linkedObject = (ObjectNode)this.objectsCache.get(linkedUri = ((LinkNode)object).getLinkedUri())) != null) {
                    linkedObject.addLink((LinkNode)object);
                }
                this.objectsCache.put(uri.toString(), object.cloneObject());
                Object var6_5 = null;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                this.delist(this);
                throw throwable;
            }
            this.delist(this);
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeObject(Uri uri, ObjectNode object) throws ServiceAccessException, ObjectNotFoundException {
        super.removeObject(uri, object);
        if (this.nodeStore.cacheResults()) {
            this.enlist(this);
            try {
                ObjectNode linkedObject;
                if (object instanceof LinkNode && (linkedObject = (ObjectNode)this.objectsCache.get(((LinkNode)object).getLinkedUri())) != null) {
                    linkedObject.removeLink((LinkNode)object);
                }
                this.objectsCache.remove(uri.toString());
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                this.delist(this);
                throw throwable;
            }
            this.delist(this);
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void grantPermission(Uri uri, NodePermission permission) throws ServiceAccessException {
        super.grantPermission(uri, permission);
        if (this.securityStore.cacheResults()) {
            this.enlist(this);
            try {
                NodePermission tempPermission = permission.cloneObject();
                Object value = this.permissionsCache.get(uri.toString());
                if (value == null) {
                    this.enumeratePermissions(uri);
                    value = this.permissionsCache.get(uri.toString());
                    if (value == null) {
                        Vector<NodePermission> permissionsVector = new Vector<NodePermission>();
                        permissionsVector.addElement(tempPermission);
                        this.permissionsCache.put(uri.toString(), permissionsVector);
                    }
                } else {
                    Vector<NodePermission> permissionsVector = new Vector<NodePermission>((Vector)value);
                    permissionsVector.addElement(tempPermission);
                    this.permissionsCache.put(uri.toString(), permissionsVector);
                }
                Object var7_7 = null;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                this.delist(this);
                throw throwable;
            }
            this.delist(this);
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void revokePermission(Uri uri, NodePermission permission) throws ServiceAccessException {
        super.revokePermission(uri, permission);
        if (this.securityStore.cacheResults()) {
            this.enlist(this);
            try {
                Object value = this.permissionsCache.get(uri.toString());
                Vector permissionsVector = null;
                if (value != null) {
                    permissionsVector = new Vector((Vector)value);
                    permissionsVector.removeElement(permission);
                    this.permissionsCache.put(uri.toString(), permissionsVector);
                }
                Object var6_5 = null;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                this.delist(this);
                throw throwable;
            }
            this.delist(this);
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void revokePermissions(Uri uri) throws ServiceAccessException {
        super.revokePermissions(uri);
        if (this.securityStore.cacheResults()) {
            this.enlist(this);
            try {
                Object value = this.permissionsCache.get(uri.toString());
                if (value != null) {
                    this.permissionsCache.put(uri.toString(), new Vector());
                }
                Object var4_3 = null;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                this.delist(this);
                throw throwable;
            }
            this.delist(this);
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration enumeratePermissions(Uri uri) throws ServiceAccessException {
        if (this.securityStore.cacheResults()) {
            Enumeration enumeration;
            if (this.isForceStoreEnlistment(uri)) {
                this.enlist(this);
            }
            try {
                Object value = this.permissionsCache.get(uri.toString());
                Vector<NodePermission> permissionsVector = null;
                if (value != null) {
                    permissionsVector = (Vector<NodePermission>)value;
                } else {
                    permissionsVector = new Vector<NodePermission>();
                    Enumeration tempEnum = this.securityStore.enumeratePermissions(uri);
                    while (tempEnum.hasMoreElements()) {
                        NodePermission tempPermission = (NodePermission)tempEnum.nextElement();
                        tempPermission.validate(uri.toString());
                        permissionsVector.addElement(tempPermission);
                    }
                    this.permissionsCache.put(uri.toString(), permissionsVector);
                }
                enumeration = ((Vector)permissionsVector.clone()).elements();
                Object var7_6 = null;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                if (this.isForceStoreEnlistment(uri)) {
                    this.delist(this);
                }
                throw throwable;
            }
            if (this.isForceStoreEnlistment(uri)) {
                this.delist(this);
            }
            return enumeration;
        }
        return super.enumeratePermissions(uri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putLock(Uri uri, NodeLock lock) throws ServiceAccessException {
        super.putLock(uri, lock);
        if (this.lockStore.cacheResults()) {
            this.enlist(this);
            try {
                Object value = this.locksCache.get(uri.toString());
                Vector<NodeLock> locksVector = null;
                locksVector = value == null ? new Vector<NodeLock>() : new Vector((Vector)value);
                locksVector.addElement(lock.cloneObject());
                this.locksCache.put(uri.toString(), locksVector);
                Object var6_5 = null;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                this.delist(this);
                throw throwable;
            }
            this.delist(this);
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renewLock(Uri uri, NodeLock lock) throws ServiceAccessException, LockTokenNotFoundException {
        super.renewLock(uri, lock);
        if (this.lockStore.cacheResults()) {
            this.enlist(this);
            try {
                Object value = this.locksCache.get(uri.toString());
                Vector<NodeLock> locksVector = null;
                if (value != null) {
                    locksVector = new Vector<NodeLock>((Vector)value);
                    boolean wasPresent = locksVector.removeElement(lock);
                    if (!wasPresent) {
                        throw new LockTokenNotFoundException(lock);
                    }
                    locksVector.addElement(lock.cloneObject());
                    this.locksCache.put(uri.toString(), locksVector);
                }
                Object var7_6 = null;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                this.delist(this);
                throw throwable;
            }
            this.delist(this);
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLock(Uri uri, NodeLock lock) throws ServiceAccessException, LockTokenNotFoundException {
        super.removeLock(uri, lock);
        if (this.lockStore.cacheResults()) {
            this.enlist(this);
            try {
                boolean wasPresent;
                Object value = this.locksCache.get(uri.toString());
                Vector locksVector = null;
                if (value != null && !(wasPresent = (locksVector = new Vector((Vector)value)).removeElement(lock))) {
                    throw new LockTokenNotFoundException(lock);
                }
                this.locksCache.put(uri.toString(), locksVector);
                Object var7_6 = null;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                this.delist(this);
                throw throwable;
            }
            this.delist(this);
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void killLock(Uri uri, NodeLock lock) throws ServiceAccessException, LockTokenNotFoundException {
        super.killLock(uri, lock);
        if (this.lockStore.cacheResults()) {
            this.enlist(this);
            try {
                boolean wasPresent;
                Object value = this.locksCache.get(uri.toString());
                Vector locksVector = null;
                if (value != null && !(wasPresent = (locksVector = new Vector((Vector)value)).removeElement(lock))) {
                    throw new LockTokenNotFoundException(lock);
                }
                this.locksCache.put(uri.toString(), locksVector);
                Object var7_6 = null;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                this.delist(this);
                throw throwable;
            }
            this.delist(this);
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration enumerateLocks(Uri uri) throws ServiceAccessException {
        if (this.lockStore.cacheResults()) {
            Enumeration enumeration;
            if (this.isForceStoreEnlistment(uri)) {
                this.enlist(this);
            }
            try {
                Object value = this.locksCache.get(uri.toString());
                Vector<NodeLock> locksVector = null;
                if (value == null) {
                    locksVector = new Vector<NodeLock>();
                    Enumeration lockList = this.lockStore.enumerateLocks(uri);
                    while (lockList.hasMoreElements()) {
                        NodeLock tempLock = (NodeLock)lockList.nextElement();
                        tempLock.validate(uri.toString());
                        locksVector.addElement(tempLock);
                    }
                    this.locksCache.put(uri.toString(), locksVector);
                } else {
                    locksVector = (Vector<NodeLock>)value;
                }
                enumeration = ((Vector)locksVector.clone()).elements();
                Object var7_6 = null;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                if (this.isForceStoreEnlistment(uri)) {
                    this.delist(this);
                }
                throw throwable;
            }
            if (this.isForceStoreEnlistment(uri)) {
                this.delist(this);
            }
            return enumeration;
        }
        return super.enumerateLocks(uri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeRevisionDescriptors retrieveRevisionDescriptors(Uri uri) throws ServiceAccessException, RevisionDescriptorNotFoundException {
        if (this.revisionDescriptorsStore.cacheResults() && !this.omitCachingBecauseOfEvilHistoryHack(uri)) {
            block8: {
                NodeRevisionDescriptors nodeRevisionDescriptors;
                if (this.isForceStoreEnlistment(uri)) {
                    this.enlist(this);
                }
                try {
                    Object tempObject = this.descriptorsCache.get(uri.toString());
                    if (tempObject == null) break block8;
                    nodeRevisionDescriptors = ((NodeRevisionDescriptors)tempObject).cloneObject();
                    Object var6_5 = null;
                }
                catch (Throwable throwable) {
                    Object var6_7 = null;
                    if (this.isForceStoreEnlistment(uri)) {
                        this.delist(this);
                    }
                    throw throwable;
                }
                if (this.isForceStoreEnlistment(uri)) {
                    this.delist(this);
                }
                return nodeRevisionDescriptors;
            }
            NodeRevisionDescriptors revisionDescriptors = this.revisionDescriptorsStore.retrieveRevisionDescriptors(uri);
            this.descriptorsCache.put(uri.toString(), revisionDescriptors);
            revisionDescriptors.validate(uri.toString());
            NodeRevisionDescriptors nodeRevisionDescriptors = revisionDescriptors.cloneObject();
            Object var6_6 = null;
            if (this.isForceStoreEnlistment(uri)) {
                this.delist(this);
            }
            return nodeRevisionDescriptors;
        }
        return super.retrieveRevisionDescriptors(uri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createRevisionDescriptors(Uri uri, NodeRevisionDescriptors revisionDescriptors) throws ServiceAccessException {
        super.createRevisionDescriptors(uri, revisionDescriptors);
        if (this.revisionDescriptorsStore.cacheResults()) {
            this.enlist(this);
            try {
                this.descriptorsCache.put(uri.toString(), revisionDescriptors.cloneObject());
                Object var4_3 = null;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                this.delist(this);
                throw throwable;
            }
            this.delist(this);
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeRevisionDescriptors(Uri uri, NodeRevisionDescriptors revisionDescriptors) throws ServiceAccessException, RevisionDescriptorNotFoundException {
        super.storeRevisionDescriptors(uri, revisionDescriptors);
        if (this.revisionDescriptorsStore.cacheResults()) {
            this.enlist(this);
            try {
                this.descriptorsCache.put(uri.toString(), revisionDescriptors.cloneObject());
                Object var4_3 = null;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                this.delist(this);
                throw throwable;
            }
            this.delist(this);
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRevisionDescriptors(Uri uri) throws ServiceAccessException {
        if (this.revisionDescriptorsStore.cacheResults()) {
            this.enlist(this);
            try {
                this.descriptorsCache.remove(uri.toString());
                Object var3_2 = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.delist(this);
                throw throwable;
            }
            this.delist(this);
            {
            }
        }
        super.removeRevisionDescriptors(uri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeRevisionDescriptor retrieveRevisionDescriptor(Uri uri, NodeRevisionNumber revisionNumber) throws ServiceAccessException, RevisionDescriptorNotFoundException {
        if (this.revisionDescriptorStore.cacheResults() && !this.omitCachingBecauseOfEvilHistoryHack(uri)) {
            block8: {
                NodeRevisionDescriptor nodeRevisionDescriptor;
                if (this.isForceStoreEnlistment(uri)) {
                    this.enlist(this);
                }
                try {
                    Object result = this.descriptorCache.get(uri + "-" + revisionNumber);
                    if (result == null) break block8;
                    nodeRevisionDescriptor = ((NodeRevisionDescriptor)result).cloneObject();
                    Object var7_6 = null;
                }
                catch (Throwable throwable) {
                    Object var7_8 = null;
                    if (this.isForceStoreEnlistment(uri)) {
                        this.delist(this);
                    }
                    throw throwable;
                }
                if (this.isForceStoreEnlistment(uri)) {
                    this.delist(this);
                }
                return nodeRevisionDescriptor;
            }
            NodeRevisionDescriptor revisionDescriptor = this.revisionDescriptorStore.retrieveRevisionDescriptor(uri, revisionNumber);
            revisionDescriptor.validate();
            this.descriptorCache.put(uri + "-" + revisionNumber, revisionDescriptor);
            NodeRevisionDescriptor nodeRevisionDescriptor = revisionDescriptor.cloneObject();
            Object var7_7 = null;
            if (this.isForceStoreEnlistment(uri)) {
                this.delist(this);
            }
            return nodeRevisionDescriptor;
        }
        return super.retrieveRevisionDescriptor(uri, revisionNumber);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createRevisionDescriptor(Uri uri, NodeRevisionDescriptor revisionDescriptor) throws ServiceAccessException {
        super.createRevisionDescriptor(uri, revisionDescriptor);
        if (this.revisionDescriptorStore.cacheResults()) {
            this.enlist(this);
            try {
                this.descriptorCache.put(uri + "-" + revisionDescriptor.getRevisionNumber(), revisionDescriptor.cloneObject());
                Object var4_3 = null;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                this.delist(this);
                throw throwable;
            }
            this.delist(this);
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeRevisionDescriptor(Uri uri, NodeRevisionDescriptor revisionDescriptor) throws ServiceAccessException, RevisionDescriptorNotFoundException {
        super.storeRevisionDescriptor(uri, revisionDescriptor);
        if (this.revisionDescriptorStore.cacheResults()) {
            this.enlist(this);
            try {
                String key = uri + "-" + revisionDescriptor.getRevisionNumber();
                this.descriptorCache.put(key, revisionDescriptor.cloneObject());
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                this.delist(this);
                throw throwable;
            }
            this.delist(this);
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRevisionDescriptor(Uri uri, NodeRevisionNumber number) throws ServiceAccessException {
        super.removeRevisionDescriptor(uri, number);
        if (this.revisionDescriptorStore.cacheResults()) {
            this.enlist(this);
            try {
                this.descriptorCache.remove(uri + "-" + number);
                Object var4_3 = null;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                this.delist(this);
                throw throwable;
            }
            this.delist(this);
            {
            }
        }
    }

    public void forget(Xid xid) throws XAException {
        Xid txId = XidWrapper.wrap(xid);
        this.activeTransactionBranch.set(null);
        this.objectsCache.getTxCache().forget(txId);
        this.permissionsCache.getTxCache().forget(txId);
        this.locksCache.getTxCache().forget(txId);
        this.descriptorsCache.getTxCache().forget(txId);
        this.descriptorCache.getTxCache().forget(txId);
        if (this.contentCache != null) {
            this.contentCache.getTxCache().forget(txId);
        }
    }

    public void rollback(Xid xid) throws XAException {
        Xid txId = XidWrapper.wrap(xid);
        this.activeTransactionBranch.set(null);
        this.objectsCache.getTxCache().rollback(txId);
        this.permissionsCache.getTxCache().rollback(txId);
        this.locksCache.getTxCache().rollback(txId);
        this.descriptorsCache.getTxCache().rollback(txId);
        this.descriptorCache.getTxCache().rollback(txId);
        if (this.contentCache != null) {
            this.contentCache.getTxCache().rollback(txId);
        }
    }

    public void commit(Xid xid, boolean onePhase) throws XAException {
        Xid txId = XidWrapper.wrap(xid);
        this.activeTransactionBranch.set(null);
        this.objectsCache.getTxCache().commit(txId);
        this.permissionsCache.getTxCache().commit(txId);
        this.locksCache.getTxCache().commit(txId);
        this.descriptorsCache.getTxCache().commit(txId);
        this.descriptorCache.getTxCache().commit(txId);
        if (this.contentCache != null) {
            this.contentCache.getTxCache().commit(txId);
        }
    }

    public int prepare(Xid xid) throws XAException {
        return 0;
    }

    public void start(Xid xid, int flags) throws XAException {
        if (flags == 0 || flags == 0x200000) {
            Xid txId = XidWrapper.wrap(xid);
            this.activeTransactionBranch.set(txId);
            this.objectsCache.getTxCache().start(txId);
            this.permissionsCache.getTxCache().start(txId);
            this.locksCache.getTxCache().start(txId);
            this.descriptorsCache.getTxCache().start(txId);
            this.descriptorCache.getTxCache().start(txId);
            if (this.contentCache != null) {
                this.contentCache.getTxCache().start(txId);
            }
        }
    }

    public void end(Xid xid, int flags) throws XAException {
    }

    public String toString() {
        return this.getName() + "(" + this.getClass().getName() + ")";
    }

    protected void init(int globalObjectCacheSize, int globalPermissionCacheSize, int globalLockCacheSize, int globalDescrtiptorsCacheSize, int globalDescrtiptorCacheSize, boolean contentCachingEnabled, int globalContentCacheSize, long contentCacheBytes, int txContentCacheSize, long txContentCacheBytes, long maxByteSizePerEntry) {
        block4: {
            try {
                this.objectsCache = new TxCacheWrapper(globalObjectCacheSize, "object");
                this.permissionsCache = new TxCacheWrapper(globalPermissionCacheSize, "permission");
                this.locksCache = new TxCacheWrapper(globalLockCacheSize, "lock");
                this.descriptorsCache = new TxCacheWrapper(globalDescrtiptorsCacheSize, "descriptors");
                this.descriptorCache = new TxCacheWrapper(globalDescrtiptorCacheSize, "descriptor");
                if (contentCachingEnabled) {
                    this.contentCache = new TxContentCacheWrapper(new ByteSizeLimitedObjectCache(globalContentCacheSize, txContentCacheSize, contentCacheBytes, txContentCacheBytes, maxByteSizePerEntry, this.getName() + ".content", this.getLogger()));
                    break block4;
                }
                this.contentCache = null;
            }
            catch (Error e) {
                this.fatalError(e);
            }
            catch (RuntimeException re) {
                this.fatalError(re);
            }
        }
    }

    protected void fatalError(Error e) {
        this.getLogger().log("Fatal error: " + e, LOG_CHANNEL, 1);
        this.getLogger().log(e, LOG_CHANNEL, 1);
        this.setRollbackOnly();
        throw e;
    }

    protected void fatalError(RuntimeException re) {
        this.getLogger().log("Fatal error: " + re, LOG_CHANNEL, 1);
        this.getLogger().log(re, LOG_CHANNEL, 1);
        this.setRollbackOnly();
        throw re;
    }

    protected boolean omitCachingBecauseOfEvilHistoryHack(Uri uri) {
        return "/history".equals(uri.toString());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected class TxContentCacheWrapper
    extends TxCacheWrapper {
        public TxContentCacheWrapper(ByteSizeLimitedObjectCache txCache) {
            super(txCache);
        }

        public void precache(NodeRevisionContent revisionContent, long byteSize) {
            try {
                Xid txId = (Xid)ExtendedStore.this.activeTransactionBranch.get();
                if (((ByteSizeLimitedObjectCache)this.getTxCache()).canCache(txId, byteSize)) {
                    revisionContent.getContentBytes();
                }
            }
            catch (Error e) {
                ExtendedStore.this.fatalError(e);
            }
            catch (RuntimeException re) {
                ExtendedStore.this.fatalError(re);
            }
        }

        public void putForRead(Object key, NodeRevisionContent revisionContent, long byteSize) {
            try {
                if (((ByteSizeLimitedObjectCache)this.getTxCache()).canCache(null, byteSize)) {
                    revisionContent.getContentBytes();
                    ((ByteSizeLimitedObjectCache)this.getTxCache()).put(null, key, revisionContent, byteSize);
                    ExtendedStore.this.getLogger().log("Globally caching content at '" + key + "' with " + byteSize + " bytes", LOG_CHANNEL, 7);
                }
            }
            catch (Error e) {
                ExtendedStore.this.fatalError(e);
            }
            catch (RuntimeException re) {
                ExtendedStore.this.fatalError(re);
            }
        }

        public void put(Object key, NodeRevisionContent revisionContent, long byteSize) {
            block4: {
                try {
                    Xid txId = (Xid)ExtendedStore.this.activeTransactionBranch.get();
                    if (((ByteSizeLimitedObjectCache)this.getTxCache()).canCache(txId, byteSize)) {
                        revisionContent.getContentBytes();
                        ((ByteSizeLimitedObjectCache)this.getTxCache()).put(txId, key, revisionContent, byteSize);
                        ExtendedStore.this.getLogger().log("Caching content at '" + key + "' with " + byteSize + " bytes", LOG_CHANNEL, 7);
                        break block4;
                    }
                    this.getTxCache().remove(txId, key);
                }
                catch (Error e) {
                    ExtendedStore.this.fatalError(e);
                }
                catch (RuntimeException re) {
                    ExtendedStore.this.fatalError(re);
                }
            }
        }
    }

    protected class TxCacheWrapper
    implements ObjectCache {
        private TxLRUObjectCache txCache;

        public TxCacheWrapper(TxLRUObjectCache txCache) {
            this.txCache = txCache;
        }

        public TxCacheWrapper(int globalCacheSize, String name) {
            this(new TxLRUObjectCache(globalCacheSize, this$0.getName() + "." + name, this$0.getLogger()));
        }

        public Object get(Object key) {
            try {
                Xid txId = (Xid)ExtendedStore.this.activeTransactionBranch.get();
                return this.txCache.get(txId, key);
            }
            catch (Error e) {
                ExtendedStore.this.fatalError(e);
            }
            catch (RuntimeException re) {
                ExtendedStore.this.fatalError(re);
            }
            return null;
        }

        public void put(Object key, Object value) {
            try {
                Xid txId = (Xid)ExtendedStore.this.activeTransactionBranch.get();
                this.txCache.put(txId, key, value);
            }
            catch (Error e) {
                ExtendedStore.this.fatalError(e);
            }
            catch (RuntimeException re) {
                ExtendedStore.this.fatalError(re);
            }
        }

        public void remove(Object key) {
            try {
                Xid txId = (Xid)ExtendedStore.this.activeTransactionBranch.get();
                this.txCache.remove(txId, key);
                ExtendedStore.this.getLogger().log("Removing content at '" + key + "' from cache", LOG_CHANNEL, 7);
            }
            catch (Error e) {
                ExtendedStore.this.fatalError(e);
            }
            catch (RuntimeException re) {
                ExtendedStore.this.fatalError(re);
            }
        }

        public void clear() {
            try {
                this.txCache.clear();
            }
            catch (Error e) {
                ExtendedStore.this.fatalError(e);
            }
            catch (RuntimeException re) {
                ExtendedStore.this.fatalError(re);
            }
        }

        public TxLRUObjectCache getTxCache() {
            return this.txCache;
        }
    }
}

