/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.search.basic;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.slide.common.Scope;
import org.apache.slide.search.InvalidScopeException;

public class QueryTree {
    private TokenizedScope topNode;
    private List allQueryTreeNodes = new ArrayList();

    QueryTree(Enumeration stores, Scope scope, Scope[] excluded) throws InvalidScopeException {
        this.topNode = new TokenizedScope(scope);
        while (stores.hasMoreElements()) {
            Scope configuredStore = (Scope)stores.nextElement();
            TokenizedScope tConfStore = new TokenizedScope(configuredStore);
            if (!tConfStore.isChildOf(this.topNode) || !tConfStore.isNotExcluded(excluded)) continue;
            this.allQueryTreeNodes.add(configuredStore);
        }
        this.allQueryTreeNodes.add(scope);
    }

    public boolean hasChildren(Scope scopeToBeChecked) {
        boolean result = false;
        TokenizedScope tScopeToBeChecked = new TokenizedScope(scopeToBeChecked);
        Iterator it = this.allQueryTreeNodes.iterator();
        while (it.hasNext()) {
            TokenizedScope ts = new TokenizedScope((Scope)it.next());
            if (!ts.isChildOf(tScopeToBeChecked)) continue;
            return true;
        }
        return false;
    }

    public int relativeDepth(Scope scope) {
        TokenizedScope tScope = new TokenizedScope(scope);
        boolean contains = this.allQueryTreeNodes.contains(tScope);
        return tScope.depth - this.topNode.depth;
    }

    public Iterator iterator() {
        return this.allQueryTreeNodes.iterator();
    }

    class TokenizedScope {
        private int depth;
        Scope scope;

        TokenizedScope(Scope scope) {
            int noOfTokens;
            this.scope = scope;
            StringTokenizer st = new StringTokenizer(scope.toString(), "/");
            this.depth = noOfTokens = st.countTokens();
        }

        public boolean equals(Object o) {
            return this.scope.equals(o);
        }

        public String toString() {
            return this.scope.toString();
        }

        public boolean isChildOf(TokenizedScope tScope) {
            return this.depth > tScope.depth && this.toString().startsWith(tScope.toString());
        }

        public boolean isNotExcluded(Scope[] excluded) {
            int i = 0;
            while (i < excluded.length) {
                if (this.toString().startsWith(excluded[i].toString())) {
                    return false;
                }
                ++i;
            }
            return true;
        }
    }
}

