/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.search.basic;

import java.util.Iterator;
import java.util.List;
import org.apache.slide.content.NodeProperty;
import org.apache.slide.search.BadQueryException;
import org.apache.slide.search.InvalidQueryException;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jdom.Namespace;

public class NotNormalizer {
    public static final String BAD_NOT_EXPRESSION_EXCEPTION_MESSAGE = "not expression must contain exactly one nested expression";

    public Element getQueryWithoutNotExpression(Element expressionElement) throws BadQueryException {
        return this.getProcessedElement(expressionElement, false);
    }

    protected Element getProcessedElement(Element expressionElement, boolean negate) throws BadQueryException {
        Element result = null;
        if ("not".equals(expressionElement.getName()) && "DAV:".equals(expressionElement.getNamespaceURI())) {
            List children = expressionElement.getChildren();
            if (children.size() != 1) {
                throw new InvalidQueryException(BAD_NOT_EXPRESSION_EXCEPTION_MESSAGE);
            }
            return this.getProcessedElement((Element)children.get(0), !negate);
        }
        result = negate ? this.getNegatedQueryElement(expressionElement) : this.getNamedClone(expressionElement, expressionElement.getName(), expressionElement.getNamespace());
        Iterator childrenIterator = expressionElement.getChildren().iterator();
        while (childrenIterator.hasNext()) {
            result.addContent(this.getProcessedElement((Element)childrenIterator.next(), negate));
        }
        return result;
    }

    protected Element getNegatedQueryElement(Element expressionElement) throws BadQueryException {
        if ("DAV:".equals(expressionElement.getNamespaceURI())) {
            return this.getNegatedDAVQueryElement(expressionElement);
        }
        if ("http://jakarta.apache.org/slide/".equals(expressionElement.getNamespaceURI())) {
            return this.getNegatedSlideQueryElement(expressionElement);
        }
        return this.getNegatedUnknownQueryElement(expressionElement);
    }

    protected Element getNegatedUnknownQueryElement(Element expressionElement) throws BadQueryException {
        return this.getNamedClone(expressionElement, expressionElement.getName(), expressionElement.getNamespace());
    }

    protected Element getNegatedDAVQueryElement(Element expressionElement) throws BadQueryException {
        String name = expressionElement.getName();
        if ("and".equals(name)) {
            return this.getNamedClone(expressionElement, "or", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
        }
        if ("or".equals(name)) {
            return this.getNamedClone(expressionElement, "and", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
        }
        if ("gt".equals(name)) {
            return this.getNamedClone(expressionElement, "not-gt", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
        }
        if ("not-gt".equals(name)) {
            return this.getNamedClone(expressionElement, "gt", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
        }
        if ("gte".equals(name)) {
            return this.getNamedClone(expressionElement, "not-gte", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
        }
        if ("not-gte".equals(name)) {
            return this.getNamedClone(expressionElement, "gte", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
        }
        if ("lt".equals(name)) {
            return this.getNamedClone(expressionElement, "not-lt", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
        }
        if ("not-lt".equals(name)) {
            return this.getNamedClone(expressionElement, "lt", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
        }
        if ("lte".equals(name)) {
            return this.getNamedClone(expressionElement, "not-lte", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
        }
        if ("not-lte".equals(name)) {
            return this.getNamedClone(expressionElement, "lte", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
        }
        if ("eq".equals(name)) {
            return this.getNamedClone(expressionElement, "not-eq", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
        }
        if ("not-eq".equals(name)) {
            return this.getNamedClone(expressionElement, "eq", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
        }
        if ("contains".equals(name)) {
            return this.getNamedClone(expressionElement, "not-contains", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
        }
        if ("not-contains".equals(name)) {
            return this.getNamedClone(expressionElement, "contains", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
        }
        if ("is-collection".equals(name)) {
            return this.getNamedClone(expressionElement, "not-is-collection", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
        }
        if ("not-is-collection".equals(name)) {
            return this.getNamedClone(expressionElement, "is-collection", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
        }
        if ("isdefined".equals(name)) {
            return this.getNamedClone(expressionElement, "not-isdefined", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
        }
        if ("not-isdefined".equals(name)) {
            return this.getNamedClone(expressionElement, "isdefined", NodeProperty.NamespaceCache.DEFAULT_NAMESPACE);
        }
        return this.getNamedClone(expressionElement, expressionElement.getName(), expressionElement.getNamespace());
    }

    protected Element getNegatedSlideQueryElement(Element expressionElement) throws BadQueryException {
        String name = expressionElement.getName();
        if ("is-principal".equals(name)) {
            return this.getNamedClone(expressionElement, "not-is-principal", NodeProperty.NamespaceCache.SLIDE_NAMESPACE);
        }
        if ("not-is-principal".equals(name)) {
            return this.getNamedClone(expressionElement, "is-principal", NodeProperty.NamespaceCache.SLIDE_NAMESPACE);
        }
        if ("propcontains".equals(name)) {
            return this.getNamedClone(expressionElement, "not-propcontains", NodeProperty.NamespaceCache.SLIDE_NAMESPACE);
        }
        if ("not-propcontains".equals(name)) {
            return this.getNamedClone(expressionElement, "propcontains", NodeProperty.NamespaceCache.SLIDE_NAMESPACE);
        }
        return this.getNamedClone(expressionElement, expressionElement.getName(), expressionElement.getNamespace());
    }

    protected Element getNamedClone(Element source, String newName, Namespace newNamespace) {
        Element copy = new Element(newName, newNamespace);
        copy.setText(source.getText());
        Iterator it = source.getAttributes().iterator();
        while (it.hasNext()) {
            Attribute attr = (Attribute)it.next();
            copy.setAttribute((Attribute)attr.clone());
        }
        return copy;
    }
}

