/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.common;

import java.util.StringTokenizer;

public final class UriPath {
    private String[] tokens;

    private UriPath() {
    }

    private UriPath(String[] tokens) {
        this.tokens = tokens;
    }

    public UriPath(String uri) {
        StringTokenizer t = new StringTokenizer(uri, "/");
        this.tokens = new String[t.countTokens()];
        int i = 0;
        while (t.hasMoreTokens()) {
            this.tokens[i] = t.nextToken();
            ++i;
        }
    }

    public String[] tokens() {
        return this.tokens;
    }

    public String lastSegment() {
        return this.tokens.length > 0 ? this.tokens[this.tokens.length - 1] : null;
    }

    public UriPath parent() {
        if (this.tokens.length == 0) {
            return null;
        }
        return this.subUriPath(0, this.tokens.length - 1);
    }

    public UriPath child(String segment) {
        String[] ctokens = new String[this.tokens.length + 1];
        int i = 0;
        while (i < this.tokens.length) {
            ctokens[i] = this.tokens[i];
            ++i;
        }
        ctokens[this.tokens.length] = segment;
        return new UriPath(ctokens);
    }

    public UriPath subUriPath(int start, int end) {
        UriPath result = new UriPath();
        result.tokens = new String[end - start];
        System.arraycopy(this.tokens, start, result.tokens, 0, result.tokens.length);
        return result;
    }

    public boolean equals(Object o) {
        boolean result = false;
        if (o instanceof UriPath) {
            UriPath other = (UriPath)o;
            if (other.tokens.length == this.tokens.length) {
                result = true;
                int i = 0;
                while (i < this.tokens.length) {
                    if (!other.tokens[i].equals(this.tokens[i])) {
                        result = false;
                        break;
                    }
                    ++i;
                }
            }
        }
        return result;
    }

    public int hashCode() {
        if (this.tokens.length > 0) {
            return this.tokens[this.tokens.length - 1].hashCode();
        }
        return 0;
    }

    public String toString() {
        if (this.tokens.length > 0) {
            StringBuffer b = new StringBuffer();
            int i = 0;
            while (i < this.tokens.length) {
                b.append("/").append(this.tokens[i]);
                ++i;
            }
            return b.toString();
        }
        return "/";
    }
}

