/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.common;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import org.apache.slide.authenticate.CredentialsToken;
import org.apache.slide.common.CacheInfoToken;
import org.apache.slide.common.SlideToken;
import org.apache.slide.common.Uri;
import org.apache.slide.store.ResourceId;
import org.apache.slide.structure.ActionNode;
import org.apache.slide.structure.ObjectNode;
import org.apache.slide.structure.SubjectNode;

public final class SlideTokenImpl
implements SlideToken {
    private CredentialsToken credentialsToken;
    private CacheInfoToken cacheInfoToken;
    private boolean enforceLockTokens = false;
    private boolean forceStoreEnlistment = false;
    private Hashtable lockTokens = new Hashtable();
    private Hashtable parameters = new Hashtable();
    private Hashtable permissionCache = new Hashtable();
    private Hashtable lockCache = new Hashtable();
    private Hashtable resolveCache = new Hashtable();
    private Hashtable matchPrincipalCache = new Hashtable();

    public SlideTokenImpl(CredentialsToken credentialsToken) {
        this.credentialsToken = credentialsToken;
    }

    public SlideTokenImpl() {
    }

    public SlideTokenImpl(CredentialsToken credentialsToken, Hashtable parameters) {
        this.credentialsToken = credentialsToken;
        this.parameters = parameters;
    }

    public CredentialsToken getCredentialsToken() {
        return this.credentialsToken;
    }

    public void setCredentialsToken(CredentialsToken credentialsToken) {
        this.credentialsToken = credentialsToken;
    }

    public CacheInfoToken getCacheInfoToken() {
        return this.cacheInfoToken;
    }

    public void setCacheInfoToken(CacheInfoToken cacheInfoToken) {
        this.cacheInfoToken = cacheInfoToken;
    }

    public boolean isEnforceLockTokens() {
        return this.enforceLockTokens;
    }

    public void setEnforceLockTokens(boolean enforceLockTokens) {
        this.enforceLockTokens = enforceLockTokens;
    }

    public boolean isForceStoreEnlistment() {
        return this.forceStoreEnlistment;
    }

    public void setForceStoreEnlistment(boolean forceStoreEnlistment) {
        this.forceStoreEnlistment = forceStoreEnlistment;
    }

    public void addLockToken(String lockId) {
        this.lockTokens.put(lockId, lockId);
    }

    public void removeLockToken(String lockId) {
        this.lockTokens.remove(lockId);
    }

    public void clearLockTokens() {
        this.lockTokens.clear();
    }

    public List showLockTokens() {
        return new ArrayList(this.lockTokens.keySet());
    }

    public boolean checkLockToken(String lockToken) {
        return this.lockTokens.containsKey(lockToken);
    }

    public void addParameter(String parameterName, Object parameterValue) {
        this.parameters.put(parameterName, parameterValue);
    }

    public void removeParameter(String parameterName) {
        this.parameters.remove(parameterName);
    }

    public void clearParameters() {
        this.parameters.clear();
    }

    public Enumeration getParameterNames() {
        return this.parameters.keys();
    }

    public void cachePermission(ObjectNode object, ActionNode action, boolean permission) {
        String key = new String(object.getUri() + action.getUri());
        Boolean perm = new Boolean(permission);
        this.permissionCache.put(key, perm);
    }

    public Boolean checkPermissionCache(ObjectNode object, ActionNode action) {
        String key = new String(object.getUri() + action.getUri());
        return (Boolean)this.permissionCache.get(key);
    }

    public boolean isForceSecurity() {
        return true;
    }

    public boolean isForceLock() {
        return true;
    }

    public void cacheLock(ObjectNode object, ActionNode action, boolean lock) {
        String key = new String(object.getUri() + action.getUri());
        Boolean locked = new Boolean(lock);
        this.lockCache.put(key, locked);
    }

    public Boolean checkLockCache(ObjectNode object, ActionNode action) {
        String key = new String(object.getUri() + action.getUri());
        return (Boolean)this.lockCache.get(key);
    }

    public void cacheResolve(Uri uri, ResourceId resourceId) {
        this.resolveCache.put(uri, resourceId);
    }

    public ResourceId checkResolveCache(Uri uri) {
        return (ResourceId)this.resolveCache.get(uri);
    }

    public void cacheMatchPrincipal(SubjectNode checkSubject, SubjectNode matchSubject, boolean match) {
        String key = String.valueOf(checkSubject) + String.valueOf(matchSubject);
        this.matchPrincipalCache.put(key, new Boolean(match));
    }

    public Boolean checkMatchPrincipalCache(SubjectNode checkSubject, SubjectNode matchSubject) {
        String key = String.valueOf(checkSubject) + String.valueOf(matchSubject);
        return (Boolean)this.matchPrincipalCache.get(key);
    }

    public void setForceLock(boolean forceLock) {
        throw new UnsupportedOperationException();
    }

    public void setForceSecurity(boolean forceSecurity) {
        throw new UnsupportedOperationException();
    }
}

