/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.compiler;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.codehaus.plexus.compiler.Compiler;
import org.codehaus.plexus.compiler.CompilerConfiguration;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.util.DirectoryScanner;

public abstract class AbstractCompiler
extends AbstractLogEnabled
implements Compiler {
    private static String PS = System.getProperty("path.separator");

    public String getClasspathString(List pathElements) throws Exception {
        return this.getPathString(pathElements);
    }

    public String getPathString(List pathElements) {
        StringBuffer sb = new StringBuffer();
        Iterator it = pathElements.iterator();
        while (it.hasNext()) {
            sb.append(it.next()).append(PS);
        }
        return sb.toString();
    }

    protected String[] getSourceFiles(CompilerConfiguration config) {
        Iterator it;
        HashSet<String> sources = new HashSet<String>();
        Set sourceFiles = config.getSourceFiles();
        if (sourceFiles != null && !sourceFiles.isEmpty()) {
            it = sourceFiles.iterator();
            while (it.hasNext()) {
                File sourceFile = (File)it.next();
                sources.add(sourceFile.getAbsolutePath());
            }
        } else {
            it = config.getSourceLocations().iterator();
            while (it.hasNext()) {
                String sourceLocation = (String)it.next();
                DirectoryScanner scanner = new DirectoryScanner();
                scanner.setBasedir(sourceLocation);
                Set includes = config.getIncludes();
                if (includes != null && !includes.isEmpty()) {
                    String[] inclStrs = includes.toArray(new String[includes.size()]);
                    scanner.setIncludes(inclStrs);
                } else {
                    scanner.setIncludes(new String[]{"**/*.java"});
                }
                Set excludes = config.getExcludes();
                if (excludes != null && !excludes.isEmpty()) {
                    String[] exclStrs = excludes.toArray(new String[excludes.size()]);
                    scanner.setIncludes(exclStrs);
                }
                scanner.scan();
                String[] sourceDirectorySources = scanner.getIncludedFiles();
                for (int j = 0; j < sourceDirectorySources.length; ++j) {
                    File f = new File(sourceLocation, sourceDirectorySources[j]);
                    sources.add(f.getPath());
                }
            }
        }
        String[] result = null;
        result = sources.isEmpty() ? new String[]{} : sources.toArray(new String[sources.size()]);
        return result;
    }

    protected String makeClassName(String fileName, String sourceDir) throws IOException {
        File origFile = new File(fileName);
        String canonical = null;
        if (origFile.exists()) {
            canonical = origFile.getCanonicalPath().replace('\\', '/');
        }
        String str = fileName;
        str = str.replace('\\', '/');
        if (sourceDir != null) {
            String prefix = new File(sourceDir).getCanonicalPath().replace('\\', '/');
            if (canonical != null) {
                if (canonical.startsWith(prefix)) {
                    String result = canonical.substring(prefix.length() + 1, canonical.length() - 5);
                    result = result.replace('/', '.');
                    return result;
                }
            } else {
                File t = new File(sourceDir, fileName);
                if (t.exists()) {
                    str = t.getCanonicalPath().replace('\\', '/');
                    String result = str.substring(prefix.length() + 1, str.length() - 5).replace('/', '.');
                    return result;
                }
            }
        }
        if (fileName.endsWith(".java")) {
            fileName = fileName.substring(0, fileName.length() - 5);
        }
        fileName = fileName.replace('\\', '.');
        return fileName.replace('/', '.');
    }

    protected String[] toStringArray(List arguments) {
        String[] args = new String[arguments.size()];
        for (int i = 0; i < arguments.size(); ++i) {
            args[i] = (String)arguments.get(i);
        }
        return args;
    }

    public abstract /* synthetic */ List compile(CompilerConfiguration var1) throws Exception;
}

