/*
 * Decompiled with CFR 0.152.
 */
package pl.project13.maven.git.util;

import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Pair<A, B> {
    @Nonnull
    public final A first;
    @Nonnull
    public final B second;

    public Pair(A first, B second) {
        Objects.requireNonNull(first, "The first parameter must not be null.");
        Objects.requireNonNull(second, "The second parameter must not be null.");
        this.first = first;
        this.second = second;
    }

    @Nonnull
    public static <A, B> Pair<A, B> of(A first, B second) {
        return new Pair<A, B>(first, second);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Pair pair = (Pair)o;
        if (!this.first.equals(pair.first)) {
            return false;
        }
        return this.second.equals(pair.second);
    }

    public int hashCode() {
        int result = this.first.hashCode();
        result = 31 * result + this.second.hashCode();
        return result;
    }

    @Nonnull
    public String toString() {
        return String.format("Pair(%s, %s)", this.first, this.second);
    }
}

