/*
 * Decompiled with CFR 0.152.
 */
package pl.project13.maven.git.util;

import com.google.common.base.Preconditions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Pair<A, B> {
    @NotNull
    public final A first;
    @NotNull
    public final B second;

    public Pair(A first, B second) {
        Preconditions.checkArgument((first != null ? 1 : 0) != 0, (Object)"The first parameter must not be null.");
        Preconditions.checkArgument((second != null ? 1 : 0) != 0, (Object)"The second parameter must not be null.");
        this.first = first;
        this.second = second;
    }

    @NotNull
    public static <A, B> Pair<A, B> of(A first, B second) {
        return new Pair<A, B>(first, second);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Pair pair = (Pair)o;
        if (!this.first.equals(pair.first)) {
            return false;
        }
        return this.second.equals(pair.second);
    }

    public int hashCode() {
        int result = this.first.hashCode();
        result = 31 * result + this.second.hashCode();
        return result;
    }

    @NotNull
    public String toString() {
        return String.format("Pair(%s, %s)", this.first, this.second);
    }
}

