/*
 * Decompiled with CFR 0.152.
 */
package pl.jalokim.utils.collection;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import pl.jalokim.utils.collection.CollectionUtils;
import pl.jalokim.utils.collection.IndexedElement;
import pl.jalokim.utils.string.StringUtils;

public final class Elements<T> {
    private final Stream<T> stream;

    private Elements(Stream<T> stream) {
        this.stream = stream;
    }

    public static <T> Elements<T> elements(Iterable<T> iterable) {
        return new Elements<T>(StreamSupport.stream(iterable.spliterator(), false));
    }

    public static <T> Elements<T> elements(T ... array) {
        return new Elements<T>(Stream.of(array));
    }

    public static <T> Elements<T> elements(Stream<T> stream) {
        return new Elements<T>(stream);
    }

    public Elements<T> filter(Predicate<T> predicate) {
        return new Elements<T>(this.stream.filter(predicate));
    }

    public <R> Elements<R> map(Function<? super T, ? extends R> mapper) {
        return new Elements<R>(this.stream.map(mapper));
    }

    public <R> Elements<R> flatMap(Function<? super T, ? extends Stream<? extends R>> mapper) {
        return new Elements(this.stream.flatMap(mapper));
    }

    public T getFirst() {
        return this.stream.findFirst().get();
    }

    public T getLast() {
        return CollectionUtils.getLast(this.asList());
    }

    public List<T> asList() {
        return Collections.unmodifiableList(new ArrayList(this.stream.collect(Collectors.toList())));
    }

    public Set<T> asSet() {
        return Collections.unmodifiableSet(new HashSet(this.stream.collect(Collectors.toSet())));
    }

    public <K> Map<K, T> asMap(Function<? super T, ? extends K> keyMapper) {
        return this.stream.collect(Collectors.toMap(keyMapper, Function.identity()));
    }

    public <K, V> Map<K, V> asMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends V> valueMapper) {
        return this.stream.collect(Collectors.toMap(keyMapper, valueMapper));
    }

    public T[] asArray(T[] array) {
        return this.stream.collect(Collectors.toList()).toArray(array);
    }

    public Stream<T> asStream() {
        return this.stream;
    }

    public String toString() {
        return this.asText();
    }

    public String asText(String joinText) {
        return StringUtils.concatElements("[", this.asList(), joinText, "]");
    }

    public String asText() {
        return this.asText(StringUtils.concat(",", " "));
    }

    public void forEach(BiConsumer<Integer, T> consumer) {
        AtomicInteger currentIndex = new AtomicInteger();
        this.stream.forEach((? super T element) -> consumer.accept(currentIndex.getAndIncrement(), element));
    }

    public void forEach(Consumer<IndexedElement<T>> consumer) {
        List<T> elements = this.asList();
        int index = 0;
        for (T element : elements) {
            consumer.accept(new IndexedElement<T>(index, element, index == 0, CollectionUtils.isLastIndex(elements, index)));
            ++index;
        }
    }
}

