/*
 * Decompiled with CFR 0.152.
 */
package pl.jalokim.utils.reflection;

import pl.jalokim.utils.string.StringUtils;

final class ClassNameFixer {
    private static final char DOLLAR_CHAR = '$';
    private static final int TWO = 2;
    private static final int ONE = 1;

    private ClassNameFixer() {
    }

    static String fixClassName(String someClassName) {
        int numberOfDollars = StringUtils.countSearchedChar(someClassName, '$');
        if (numberOfDollars == 0) {
            return someClassName;
        }
        int currentIndex = 0;
        for (char currentChar : someClassName.toCharArray()) {
            String textBeforeDollar;
            int sizeOfClassNamePart;
            String secondPart;
            if (currentChar == '$' && (secondPart = ClassNameFixer.getNewClassName(someClassName, currentIndex, sizeOfClassNamePart = (textBeforeDollar = someClassName.substring(0, currentIndex)).length())) != null) {
                return secondPart;
            }
            ++currentIndex;
        }
        return someClassName;
    }

    private static String getNewClassName(String someClassName, int currentIndex, int sizeOfClassNamePart) {
        String secondPart;
        int middleIndex;
        String firstPart;
        if (Math.abs(sizeOfClassNamePart) % 2 == 1 && (firstPart = someClassName.substring(0, middleIndex = sizeOfClassNamePart / 2)).equals(secondPart = someClassName.substring(middleIndex + 1, currentIndex))) {
            return secondPart + someClassName.substring(currentIndex);
        }
        return null;
    }
}

