/*
 * Decompiled with CFR 0.152.
 */
package pl.jalokim.utils.random;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import pl.jalokim.utils.random.RandomUtilImpl;

public final class RandomUtils {
    private static RandomUtilImpl impl = new RandomUtilImpl();

    private RandomUtils() {
    }

    public static void ownRandomImpl(RandomUtilImpl newImpl) {
        impl = newImpl;
    }

    public static int randomInRange(int min, int max) {
        return impl.randomInRangeImpl(min, max);
    }

    public static <T> int randomIndex(List<T> elements) {
        return RandomUtils.randomInRange(0, elements.size() - 1);
    }

    public static <T> int randomIndex(T ... elements) {
        return RandomUtils.randomInRange(0, elements.length - 1);
    }

    public static <T> T randomElement(Collection<T> elements) {
        Objects.requireNonNull(elements);
        return impl.randomElementImpl(elements);
    }

    public static <T> T randomElement(T ... elements) {
        return impl.randomElementImpl(Arrays.asList(elements));
    }

    public static boolean randomTrue() {
        return impl.randomTrue();
    }

    public static boolean randomTrue(int probabilityOfTrueInPercent) {
        return impl.randomTrueWithProbability(probabilityOfTrueInPercent);
    }
}

