/*
 * Decompiled with CFR 0.152.
 */
package pl.jalokim.utils.template;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import pl.jalokim.utils.collection.CollectionUtils;
import pl.jalokim.utils.file.FileUtils;

public class TemplateAsText {
    private static final String VAR_PATTERN = "\\$\\{%s}";
    private final boolean throwExceptionForNotResolved;
    private String templateText;

    private TemplateAsText(String templateText, boolean throwExceptionForNotResolved) {
        this.throwExceptionForNotResolved = throwExceptionForNotResolved;
        this.templateText = templateText;
    }

    private TemplateAsText(String templateText) {
        this(templateText, false);
    }

    public static TemplateAsText fromClassPath(String resourcePath) {
        return new TemplateAsText(FileUtils.loadFileFromClassPathAsText(resourcePath));
    }

    public static TemplateAsText fromClassPath(String resourcePath, boolean throwExceptionForNotResolved) {
        return new TemplateAsText(FileUtils.loadFileFromClassPathAsText(resourcePath), throwExceptionForNotResolved);
    }

    public static TemplateAsText fromFile(String filePath) {
        return new TemplateAsText(FileUtils.loadFileFromPathAsText(filePath));
    }

    public static TemplateAsText fromFile(String filePath, boolean throwExceptionForNotResolved) {
        return new TemplateAsText(FileUtils.loadFileFromPathAsText(filePath), throwExceptionForNotResolved);
    }

    public static TemplateAsText fromText(String templateText) {
        return new TemplateAsText(templateText);
    }

    public static TemplateAsText fromText(String templateText, boolean throwExceptionForNotResolved) {
        return new TemplateAsText(templateText, throwExceptionForNotResolved);
    }

    public void overrideVariable(String varName, String value) {
        if (value == null) {
            throw new NullPointerException("Value for variable: '" + varName + "' cannot be null");
        }
        this.templateText = this.templateText.replaceAll(String.format(VAR_PATTERN, varName), value.replace("$", "\\$"));
    }

    public String getCurrentTemplateText() {
        if (this.throwExceptionForNotResolved) {
            Pattern pattern = Pattern.compile(String.format(VAR_PATTERN, "(\\w|-)+"));
            Matcher matcher = pattern.matcher(this.templateText);
            ArrayList<String> notResolved = new ArrayList<String>();
            while (matcher.find()) {
                notResolved.add(matcher.group(0));
            }
            if (CollectionUtils.isNotEmpty(notResolved)) {
                throw new IllegalArgumentException("Not resolved placeholders: " + notResolved);
            }
        }
        return this.templateText;
    }
}

