/*
 * Decompiled with CFR 0.152.
 */
package pl.jalokim.utils.string;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import pl.jalokim.utils.constants.Constants;

public final class StringUtils {
    private StringUtils() {
    }

    public static boolean isEmpty(String text) {
        return text == null || text.isEmpty();
    }

    public static boolean isNotEmpty(String text) {
        return !StringUtils.isEmpty(text);
    }

    public static boolean isBlank(String text) {
        return text == null || StringUtils.isBlank(text.toCharArray());
    }

    public static boolean isNotBlank(String text) {
        return !StringUtils.isBlank(text);
    }

    private static boolean isBlank(char ... chars) {
        boolean result = true;
        for (char aChar : chars) {
            boolean bl = result = result && Character.isWhitespace(aChar);
            if (!result) break;
        }
        return result;
    }

    public static <E> String concatElementsAsLines(List<E> elements) {
        return StringUtils.concatElements(elements, Constants.NEW_LINE);
    }

    public static <E> String concatElementsAsLines(List<E> elements, Function<E, String> mapper) {
        return StringUtils.concatElements(elements, mapper, Constants.NEW_LINE);
    }

    public static String tabsNTimes(int tabsNumber) {
        return StringUtils.repeatTextNTimes(tabsNumber, "\t");
    }

    public static String repeatTextNTimes(int nTimes, String text) {
        return String.join((CharSequence)"", Collections.nCopies(nTimes, text));
    }

    public static <E> String concatElements(Collection<E> collection) {
        return StringUtils.concatElements(collection, "");
    }

    public static <E> String concatElements(Collection<E> collection, Function<E, String> mapper) {
        return StringUtils.concatElements(collection, mapper, "");
    }

    public static <E> String concatElements(Collection<E> collection, String joinText) {
        return StringUtils.concatElements(collection, Object::toString, joinText);
    }

    public static <E> String concatElements(Collection<E> collection, Function<E, String> mapper, String joinText) {
        return StringUtils.concatElements("", collection, mapper, joinText, "");
    }

    public static <E> String concatElements(String textPrefix, Collection<E> collection, Function<E, String> mapper, String joinText, String textSuffix) {
        return textPrefix.concat(collection.stream().map(mapper).collect(Collectors.joining(joinText))).concat(textSuffix);
    }

    public static String concatElements(String joinText, String ... texts) {
        return StringUtils.concatElements(Arrays.asList(texts), joinText);
    }

    public static String concat(String ... texts) {
        return StringUtils.concatElements(Arrays.asList(texts), "");
    }
}

