/*
 * Decompiled with CFR 0.152.
 */
package pl.jalokim.utils.file;

import com.google.common.io.Resources;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import pl.jalokim.utils.file.FileCursor;
import pl.jalokim.utils.file.FileException;
import pl.jalokim.utils.string.StringUtils;

public final class FileUtils {
    private FileUtils() {
    }

    public static String loadFileFromPathAsText(String path) {
        return FileUtils.loadFileFromPathAsText(path, StandardCharsets.UTF_8);
    }

    public static String loadFileFromPathAsText(String path, Charset charset) {
        return FileUtils.catchIoEx(() -> new String(Files.readAllBytes(Paths.get(path, new String[0])), charset));
    }

    public static String loadFileFromClassPathAsText(String path) {
        return FileUtils.loadFileFromClassPathAsText(path, StandardCharsets.UTF_8);
    }

    public static String loadFileFromClassPathAsText(String path, Charset charset) {
        return FileUtils.catchIoEx(() -> {
            URL url = Resources.getResource((String)path);
            return Resources.toString((URL)url, (Charset)charset);
        });
    }

    public static List<String> loadFileFromPathToList(String path) {
        ArrayList<String> lines = new ArrayList<String>();
        FileUtils.consumeEveryLineFromFile(path, lines::add);
        return lines;
    }

    public static void consumeEveryLineFromFile(String path, Consumer<String> consumerLine) {
        FileUtils.catchIoEx(() -> {
            try (BufferedReader br = new BufferedReader(new FileReader(path));){
                String line;
                while ((line = br.readLine()) != null) {
                    consumerLine.accept(line);
                }
            }
            return null;
        });
    }

    public static void consumeEveryLineWitNumberFromFile(String path, BiConsumer<Long, String> consumerLineIndex) {
        FileUtils.catchIoEx(() -> {
            long index = 0L;
            try (BufferedReader br = new BufferedReader(new FileReader(path));){
                String line;
                while ((line = br.readLine()) != null) {
                    consumerLineIndex.accept(++index, line);
                }
            }
            return null;
        });
    }

    public static FileCursor readFileFromPathToFileCursor(String path) {
        return new FileCursor(path);
    }

    public static void writeToFile(String filePath, String fileContent) {
        Path path = Paths.get(filePath, new String[0]);
        byte[] strToBytes = fileContent.getBytes(StandardCharsets.UTF_8);
        FileUtils.catchIoEx(() -> Files.write(path, strToBytes, new OpenOption[0]));
    }

    public static void appendToFile(String filePath, String fileContent) {
        Path path = Paths.get(filePath, new String[0]);
        byte[] strToBytes = fileContent.getBytes(StandardCharsets.UTF_8);
        FileUtils.catchIoEx(() -> Files.write(path, strToBytes, StandardOpenOption.APPEND));
    }

    public static void writeAllElementsAsLinesToFile(String filePath, List<String> elementToWrite) {
        Path path = Paths.get(filePath, new String[0]);
        String fileContent = StringUtils.concatElementsAsLines(elementToWrite);
        byte[] strToBytes = fileContent.getBytes(StandardCharsets.UTF_8);
        FileUtils.catchIoEx(() -> Files.write(path, strToBytes, new OpenOption[0]));
    }

    public static void appendAllElementsAsLinesToFile(String filePath, List<String> elementToWrite) {
        Path path = Paths.get(filePath, new String[0]);
        String fileContent = StringUtils.concatElementsAsLines(elementToWrite);
        byte[] strToBytes = fileContent.getBytes(StandardCharsets.UTF_8);
        FileUtils.catchIoEx(() -> Files.write(path, strToBytes, StandardOpenOption.APPEND));
    }

    static <T> T catchIoEx(IOExceptionSupplier<T> throwableSupplier) {
        try {
            return throwableSupplier.get();
        }
        catch (IOException ex) {
            throw new FileException(ex);
        }
    }

    @FunctionalInterface
    static interface IOExceptionSupplier<T> {
        public T get() throws IOException;
    }
}

