/*
 * Decompiled with CFR 0.152.
 */
package pl.jalokim.utils.collection;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class Elements<T> {
    private final Stream<T> stream;

    private Elements(Stream<T> stream) {
        this.stream = stream;
    }

    public static <T> Elements<T> elements(Iterable<T> iterable) {
        return new Elements<T>(StreamSupport.stream(iterable.spliterator(), false));
    }

    public static <T> Elements<T> elements(T ... array) {
        return new Elements<T>(Stream.of(array));
    }

    public static <T> Elements<T> elements(Stream<T> stream) {
        return new Elements<T>(stream);
    }

    public Elements<T> filter(Predicate<T> predicate) {
        return new Elements<T>(this.stream.filter(predicate));
    }

    public <R> Elements<R> map(Function<? super T, ? extends R> mapper) {
        return new Elements<R>(this.stream.map(mapper));
    }

    public List<T> asList() {
        return Collections.unmodifiableList(new ArrayList(this.stream.collect(Collectors.toList())));
    }

    public Set<T> asSet() {
        return Collections.unmodifiableSet(new HashSet(this.stream.collect(Collectors.toSet())));
    }

    public T[] asArray(T[] array) {
        return this.stream.collect(Collectors.toList()).toArray(array);
    }

    public Stream<T> asStream() {
        return this.stream;
    }
}

