/*
 * Decompiled with CFR 0.152.
 */
package pl.jalokim.utils.collection;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import pl.jalokim.utils.collection.CollectionUtilsException;

public final class CollectionUtils {
    private CollectionUtils() {
    }

    public static boolean isLastIndex(List<?> list, int index) {
        return CollectionUtils.getLastIndex(list) == index;
    }

    public static boolean isLastIndex(Object[] array, int index) {
        return CollectionUtils.getLastIndex(array) == index;
    }

    public static int getLastIndex(Collection<?> list) {
        return list.size() - 1;
    }

    public static int getLastIndex(Object[] array) {
        return array.length - 1;
    }

    public static <T> Set<T> filterToSet(Collection<T> collection, Predicate<T> filter) {
        return collection.stream().filter(filter).collect(Collectors.toSet());
    }

    public static <T, R> Set<R> mapToSet(Collection<T> collection, Function<T, R> mapFunc) {
        return collection.stream().map(mapFunc).collect(Collectors.toSet());
    }

    public static <T, R> Set<R> mapToSet(Collection<T> collection, Function<T, R> mapFunc, Predicate<R> filter) {
        return collection.stream().map(mapFunc).filter(filter).collect(Collectors.toSet());
    }

    public static <T, R> Set<R> filterToSet(Collection<T> collection, Predicate<T> filter, Function<T, R> mapFunc) {
        return collection.stream().filter(filter).map(mapFunc).collect(Collectors.toSet());
    }

    public static <T, R> List<R> mapToList(Collection<T> collection, Function<T, R> mapFunc) {
        return collection.stream().map(mapFunc).collect(Collectors.toList());
    }

    public static <T> List<T> filterToList(Collection<T> collection, Predicate<T> filter) {
        return collection.stream().filter(filter).collect(Collectors.toList());
    }

    public static <T, R> List<R> mapToList(Collection<T> collection, Function<T, R> mapFunc, Predicate<R> filter) {
        return collection.stream().map(mapFunc).filter(filter).collect(Collectors.toList());
    }

    public static <T, R> List<R> filterToList(Collection<T> collection, Predicate<T> filter, Function<T, R> mapFunc) {
        return collection.stream().filter(filter).map(mapFunc).collect(Collectors.toList());
    }

    public static <T, R> List<R> mapToList(Function<T, R> mapFunc, T ... array) {
        return CollectionUtils.mapToList(Arrays.asList(array), mapFunc);
    }

    public static <T, R> List<R> mapToList(Function<T, R> mapFunc, Predicate<R> predicate, T ... array) {
        return CollectionUtils.mapToList(Arrays.asList(array), mapFunc, predicate);
    }

    public static <T> List<T> filterToList(Predicate<T> predicate, T ... array) {
        return CollectionUtils.filterToList(Arrays.asList(array), predicate);
    }

    public static <T, R> List<R> filterToList(Predicate<T> predicate, Function<T, R> mapFunc, T ... array) {
        return CollectionUtils.filterToList(Arrays.asList(array), predicate, mapFunc);
    }

    public static <T extends Comparable<? super T>> List<T> sortAsNewList(Collection<T> list) {
        ArrayList<T> copyList = new ArrayList<T>(list);
        Collections.sort(copyList);
        return copyList;
    }

    public static <T> List<T> swapElementsAsNewList(List<T> sourceList, int indexToSwap, T newValue) {
        ArrayList<T> copyList = new ArrayList<T>(sourceList);
        copyList.set(indexToSwap, newValue);
        return copyList;
    }

    public static <T> T getFirst(List<T> list) {
        if (list.isEmpty()) {
            throw new CollectionUtilsException("cannot get first element from empty list: " + list);
        }
        return list.get(0);
    }

    public static <T> T getLast(List<T> list) {
        if (list.isEmpty()) {
            throw new CollectionUtilsException("cannot get last element from empty list: " + list);
        }
        return list.get(list.size() - 1);
    }

    public static <T> boolean addWhenNotExist(List<T> list, T element) {
        if (!list.contains(element)) {
            return list.add(element);
        }
        return false;
    }

    public static <T extends Comparable<? super T>> boolean hasTheSameElements(Collection<T> first, Collection<T> second) {
        return new HashSet<T>(first).equals(new HashSet<T>(second));
    }

    public static <T> boolean isEmpty(List<T> list) {
        return list == null || list.isEmpty();
    }

    public static <T> boolean isNotEmpty(List<T> list) {
        return !CollectionUtils.isEmpty(list);
    }

    public static <E> List<E> intersection(Collection<E> first, Collection<E> second) {
        ArrayList<E> list = new ArrayList<E>();
        for (E element : first) {
            if (!second.contains(element)) continue;
            list.add(element);
        }
        return Collections.unmodifiableList(list);
    }
}

