/*
 * Decompiled with CFR 0.152.
 */
package pl.grizzlysoftware.dotykacka.client.v1.facade;

import java.util.Collection;
import pl.grizzlysoftware.dotykacka.client.v1.api.dto.Warehouse;
import pl.grizzlysoftware.dotykacka.client.v1.api.service.WarehouseService;
import pl.grizzlysoftware.dotykacka.client.v1.facade.DotykackaApiServiceFacade;
import pl.grizzlysoftware.dotykacka.util.BatchLoader;

public class WarehouseServiceFacade
extends DotykackaApiServiceFacade<WarehouseService> {
    protected BatchLoader batchLoader = new BatchLoader(100);

    public WarehouseServiceFacade(Long cloudId, WarehouseService service) {
        super(cloudId, service);
    }

    public Warehouse getWarehouse(Long id) {
        Warehouse out = this.execute(((WarehouseService)this.service).getWarehouse(this.cloudId, id));
        return out;
    }

    public Collection<Warehouse> getAllWarehouses(int limit, int offset, String sortBy) {
        Collection<Warehouse> out = this.execute(((WarehouseService)this.service).getWarehouses(this.cloudId, limit, offset, sortBy));
        return out;
    }

    public Collection<Warehouse> getAllWarehouses(String sortBy) {
        Collection out = this.batchLoader.load(page -> this.getAllWarehouses(page.limit, page.offset, sortBy));
        return out;
    }

    public Collection<Warehouse> getAllWarehouses() {
        Collection<Warehouse> out = this.getAllWarehouses(null);
        return out;
    }

    public Collection<Warehouse> getWarehouses(int limit, int offset) {
        Collection<Warehouse> out = this.execute(((WarehouseService)this.service).getWarehouses(this.cloudId, limit, offset, null));
        return out;
    }

    public Warehouse updateWarehouse(Long id, Warehouse customer) {
        return this.execute(((WarehouseService)this.service).updateWarehouse(this.cloudId, id, customer));
    }

    public Warehouse createWarehouse(Warehouse customer) {
        return this.execute(((WarehouseService)this.service).createWarehouse(this.cloudId, customer));
    }

    public Warehouse deleteWarehouse(Long id) {
        return this.execute(((WarehouseService)this.service).deleteWarehouse(this.cloudId, id));
    }
}

