/*
 * Decompiled with CFR 0.152.
 */
package pl.grizzlysoftware.util;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import java.io.IOException;
import java.lang.reflect.Type;
import okhttp3.ResponseBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Converter;

public class LoggingJacksonResponseBodyConverter
implements Converter<ResponseBody, Object> {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoggingJacksonResponseBodyConverter.class);
    protected ObjectMapper mapper;
    protected Type type;

    public LoggingJacksonResponseBodyConverter(ObjectMapper mapper, Type type) {
        this.mapper = mapper;
        this.type = type;
    }

    public Object convert(ResponseBody value) throws IOException {
        JavaType javaType = this.mapper.getTypeFactory().constructType(this.type);
        ObjectReader reader = this.mapper.readerFor(javaType);
        String str = value.string();
        LOGGER.debug("Converting: {} body: '{}'", (Object)javaType.getRawClass().getSimpleName(), (Object)str);
        return reader.readValue(str);
    }
}

