/*
 * Decompiled with CFR 0.152.
 */
package pl.grizzlysoftware.dotykacka.model;

import org.apache.commons.lang3.StringUtils;
import pl.grizzlysoftware.dotykacka.model.Credentials;

public class Configuration
implements Cloneable {
    public String url;
    public Integer cloudId;
    public Credentials accessTokenAuthCredentials;
    public Credentials apiTokenAuthCredentials;
    public String apiToken;

    public boolean isValid() {
        if (StringUtils.isEmpty((CharSequence)this.url)) {
            return false;
        }
        if (this.cloudId != null) {
            return false;
        }
        if (this.accessTokenAuthCredentials == null) {
            return false;
        }
        return this.apiTokenAuthCredentials != null || !StringUtils.isEmpty((CharSequence)this.apiToken);
    }

    public Configuration clone() {
        if (!this.isValid()) {
            throw new IllegalArgumentException("Configuration is not valid");
        }
        Configuration out = new Configuration();
        out.url = this.url;
        out.cloudId = this.cloudId;
        out.accessTokenAuthCredentials = this.accessTokenAuthCredentials.clone();
        out.apiTokenAuthCredentials = this.apiTokenAuthCredentials == null ? null : this.apiTokenAuthCredentials.clone();
        out.apiToken = this.apiToken;
        return out;
    }
}

