/*
 * Decompiled with CFR 0.152.
 */
package pl.fhframework.app.menu;

import java.net.URL;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import pl.fhframework.ISystemUseCase;
import pl.fhframework.UserSession;
import pl.fhframework.annotations.Action;
import pl.fhframework.app.config.DefaultApplicationConfigurer;
import pl.fhframework.app.menu.INavbar;
import pl.fhframework.app.menu.MenuService;
import pl.fhframework.app.menu.NavbarForm;
import pl.fhframework.app.preferences.UserPreferencesUC;
import pl.fhframework.core.logging.FhLogger;
import pl.fhframework.core.rules.builtin.FhUserUtils;
import pl.fhframework.core.uc.IUseCaseNoCallback;
import pl.fhframework.core.uc.IUseCaseOutputCallback;
import pl.fhframework.core.uc.IUseCaseRefreshListener;
import pl.fhframework.core.uc.UseCase;
import pl.fhframework.core.util.LogUtils;
import pl.fhframework.core.util.StringUtils;
import pl.fhframework.event.EventRegistry;

@UseCase
public class NavbarUC
implements INavbar,
ISystemUseCase,
IUseCaseRefreshListener {
    public static final String NAVBAR_CONTAINER_ID = "navbarForm";
    private NavbarForm.Model model = new NavbarForm.Model();
    private static final String BOOTSWATCH_THEME_URL = "https://bootswatch.com/4/%s/bootstrap.css";
    @Autowired
    private MenuService menuService;
    @Autowired
    private EventRegistry eventRegistry;
    @Value(value="${server.servlet.context-path:/}")
    private String contextRoot;
    @Value(value="${server.logout.path:logout}")
    private String logoutPath;
    @Value(value="${server.login.path:login}")
    private String loginPath;
    @Value(value="${fh.application.default.css}")
    private String defaultCss;
    @Value(value="${fh.application.menu.hide}")
    private boolean menuHidden;
    @Value(value="${fhframework.language.default:pl}")
    private String defaultLanguage;
    @Autowired
    private DefaultApplicationConfigurer configurer;
    @Autowired
    private FhUserUtils userUtils;
    private Map<String, String> cssUrls;

    public void start() {
        this.model.setLogin(this.getUserSession().getSystemUser().getLogin());
        this.model.setMenuService(this.menuService);
        if (this.contextRoot.endsWith("/")) {
            this.model.setLogoutURL(this.contextRoot + this.logoutPath);
            this.model.setLoginURL(this.contextRoot + this.loginPath);
        } else {
            this.model.setLogoutURL(this.contextRoot + "/" + this.logoutPath);
            this.model.setLoginURL(this.contextRoot + "/" + this.loginPath);
        }
        this.model.setGuest(this.userUtils.userHasRole("Guest"));
        this.setLanguage(this.defaultLanguage);
        this.openDefaultStylesheet();
        if (this.menuHidden) {
            this.hideMenu();
        }
        this.showForm(NavbarForm.class, this.model);
    }

    private void openDefaultStylesheet() {
        this.cssUrls = this.configurer.getCssUrls();
        this.model.setCssIds(new ArrayList<String>(this.cssUrls.keySet()));
        this.model.setFhCss(this.model.getCssIds().remove("fh"));
        this.model.setFhCss(this.model.getCssIds().remove("materia"));
        this.model.setDefaultCss(this.model.getCssIds().remove("default"));
        if (Objects.equals("fh", this.defaultCss)) {
            this.openLocalStylesheet("fh");
        } else if (Objects.equals("materia", this.defaultCss)) {
            this.openLocalStylesheet("materia");
        } else if (Objects.equals("default", this.defaultCss)) {
            this.closeAlternativeStylesheet();
        } else {
            this.openStylesheet(this.defaultCss);
        }
    }

    @Action
    public void downloadUserLog() {
        FhLogger.info(this.getClass(), (String)"Flushing the log buffer out", (Object[])new Object[0]);
        URL log = LogUtils.getUserLogFile((UserSession)this.getUserSession());
        this.eventRegistry.fireDownloadEvent((Resource)new UrlResource(log));
    }

    public String getContainerId() {
        return NAVBAR_CONTAINER_ID;
    }

    @Action
    public void setLanguagePolish() {
        this.setLanguage(NavbarForm.Language.POLISH.getValue());
    }

    @Action
    public void openPreferences() {
        this.runUseCase(UserPreferencesUC.class, (IUseCaseOutputCallback)IUseCaseNoCallback.getCallback());
    }

    @Action
    public void setLanguageEnglish() {
        this.setLanguage(NavbarForm.Language.ENGLISH.getValue());
    }

    private void setLanguage(String lang) {
        this.getUserSession().setLanguage(this.getLocale(lang));
        this.model.setLanguage(lang);
    }

    @Action
    public void openLocalStylesheet(String id) {
        String style = this.contextRoot + (this.contextRoot.endsWith("/") ? "" : "/") + "css/" + id + ".css";
        this.model.setAlternativeStylesheet(style);
        this.eventRegistry.fireStylesheetChangeEvent(style);
    }

    @Action
    public void openStylesheet(String id) {
        this.model.setAlternativeStylesheet(this.cssUrls.get(id));
        this.eventRegistry.fireStylesheetChangeEvent(this.model.getAlternativeStylesheet());
    }

    @Action
    public void closeAlternativeStylesheet() {
        this.model.setAlternativeStylesheet(null);
        this.eventRegistry.fireStylesheetChangeEvent(null);
    }

    @Action
    public void toggleMenu() {
        if (this.menuService.isHidden()) {
            this.menuService.show();
        } else {
            this.menuService.hide();
        }
    }

    private Locale getLocale(String languageTag) {
        if (!StringUtils.isNullOrEmpty((String)languageTag)) {
            return Locale.forLanguageTag(languageTag);
        }
        return Locale.getDefault();
    }

    public void doAfterRefresh() {
        if (this.menuService.isHidden()) {
            this.menuService.hide();
        } else {
            this.menuService.show();
        }
    }

    @Override
    public void openMenu() {
        throw new IllegalStateException("Not implemented.");
    }

    @Override
    public void closeMenu() {
        throw new IllegalStateException("Not implemented.");
    }

    @Override
    public void showMenu() {
        this.menuService.show();
    }

    @Override
    public void hideMenu() {
        this.menuService.hide();
    }
}

