/*
 * Decompiled with CFR 0.152.
 */
package pl.fhframework.model.forms;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.springframework.util.CollectionUtils;
import pl.fhframework.BindingResult;
import pl.fhframework.annotations.Control;
import pl.fhframework.annotations.DesignerXMLProperty;
import pl.fhframework.annotations.DocumentedComponent;
import pl.fhframework.annotations.DocumentedComponentAttribute;
import pl.fhframework.annotations.OverridenPropertyAnnotations;
import pl.fhframework.annotations.XMLProperty;
import pl.fhframework.binding.ModelBinding;
import pl.fhframework.core.forms.IValidatedComponent;
import pl.fhframework.core.util.StringUtils;
import pl.fhframework.helper.AutowireHelper;
import pl.fhframework.model.PresentationStyleEnum;
import pl.fhframework.model.dto.ElementChanges;
import pl.fhframework.model.forms.AccessibilityEnum;
import pl.fhframework.model.forms.BaseInputField;
import pl.fhframework.model.forms.Column;
import pl.fhframework.model.forms.Component;
import pl.fhframework.model.forms.Form;
import pl.fhframework.model.forms.FormElement;
import pl.fhframework.model.forms.IComponentsReferrer;
import pl.fhframework.model.forms.IGroupingComponent;
import pl.fhframework.model.forms.MessageData;
import pl.fhframework.model.forms.OutputLabel;
import pl.fhframework.model.forms.Table;
import pl.fhframework.model.forms.TableCell;
import pl.fhframework.model.forms.attribute.CommaSeparatedStringListAttrConverter;
import pl.fhframework.model.forms.optimized.ColumnOptimized;
import pl.fhframework.model.forms.optimized.TableCellOptimized;
import pl.fhframework.model.forms.optimized.TableOptimized;
import pl.fhframework.validation.FieldValidationResult;
import pl.fhframework.validation.IValidationResults;

@OverridenPropertyAnnotations(property="htmlAccessibilityRole", designerXmlProperty={@DesignerXMLProperty(functionalArea=DesignerXMLProperty.PropertyFunctionalArea.SPECIFIC, priority=90)}, xmlProperty={@XMLProperty(value="htmlAccessibilityRole", defaultValue="status")})
@Control(parents={}, canBeDesigned=true)
@DocumentedComponent(category=DocumentedComponent.Category.INPUTS_AND_VALIDATION, documentationExample=true, value="Component to aggregate validation messages", icon="fa fa-exclamation")
public class ValidateMessages
extends FormElement
implements IComponentsReferrer {
    public static final String ANY_COMPONENT = "*";
    public static final String NOT_ASSIGNED_BUSINESS = "+";
    private List<MessageData> validateMessages = new ArrayList<MessageData>();
    @XMLProperty(required=true)
    @DesignerXMLProperty(commonUse=true)
    @DocumentedComponentAttribute(value="Represents level of displayed validation messages, like warning, error, information. Possible values: ok, info, warning, error, blocker")
    private PresentationStyleEnum level;
    @XMLProperty(defaultValue="false")
    @DocumentedComponentAttribute(value="Defines if display messages strictly from choosen level", defaultValue="false")
    private boolean strictLevel;
    @XMLProperty(converter=CommaSeparatedStringListAttrConverter.class, required=true)
    @DesignerXMLProperty(commonUse=true)
    @DocumentedComponentAttribute(value="Parent component list of ids that group components for validation delimited by \",\" or * to match all or + to include unassigned custom messages")
    private List<String> componentIds;
    @XMLProperty(defaultValue="true")
    @DocumentedComponentAttribute(value="Defines if field navigation should be handled", defaultValue="true")
    private boolean navigation = true;
    @JsonIgnore
    private boolean showAttributeAsLabel;

    public ValidateMessages(Form form) {
        super(form);
    }

    public void init() {
        super.init();
        this.htmlAccessibilityRole = "status";
        this.showAttributeAsLabel = !"false".equals(AutowireHelper.getApplicationProperty((String)"fhframework.validation.attributeAsLabel"));
    }

    protected ElementChanges updateView() {
        ElementChanges elementChanges = super.updateView();
        elementChanges.setFormElementId(this.getId());
        this.validateMessages.clear();
        this.validateMessages.addAll(this.processValidationResult());
        elementChanges.addChange("validateMessages", this.validateMessages);
        return elementChanges;
    }

    private List<MessageData> processValidationResult() {
        if (this.getForm().getViewMode() == Form.ViewMode.NORMAL) {
            IValidationResults validationResults = this.getForm().getAbstractUseCase().getUserSession().getValidationResults();
            return this.createMessagesForValidationErrors(validationResults);
        }
        return Arrays.asList(new MessageData("fake", "This is place", "for validation messages of: " + StringUtils.join(this.componentIds, (String)", ", (boolean)false)));
    }

    private List<MessageData> createMessagesForValidationErrors(IValidationResults validationResults) {
        ArrayList<MessageData> resolvedMessages = new ArrayList<MessageData>();
        for (Map.Entry entry : validationResults.getValidationErrors().entrySet()) {
            Map fieldsInModelWithValidationResults = (Map)entry.getValue();
            for (Map.Entry fieldWithValidation : fieldsInModelWithValidationResults.entrySet()) {
                String fieldName = (String)fieldWithValidation.getKey();
                Object parentModelName = entry.getKey();
                List validationResult = (List)fieldWithValidation.getValue();
                validationResult.stream().filter(x -> this.level.ordinal() == x.getPresentationStyleEnum().ordinal() || !this.strictLevel && this.level.ordinal() < x.getPresentationStyleEnum().ordinal()).forEach(x -> {
                    MessageData msg = this.createMessageData((FieldValidationResult)x, parentModelName, fieldName);
                    if (msg != null) {
                        resolvedMessages.add(msg);
                    }
                });
            }
        }
        return resolvedMessages;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private MessageData createMessageData(FieldValidationResult x, Object parentModelName, String fieldName) {
        Optional<FormElement> foundComponent;
        if (x.getKnownSourceComponentId() != null) {
            FormElement knownSourceComponent = this.getForm().getFormElement(x.getKnownSourceComponentId());
            if (knownSourceComponent == null) return null;
            foundComponent = Optional.of(knownSourceComponent);
        } else {
            foundComponent = this.findComponentBasedOnAttribute((Component)this.getForm(), fieldName, parentModelName);
        }
        MessageData msg = null;
        if (foundComponent.isPresent()) {
            String label;
            IValidatedComponent validationComponent;
            if (CollectionUtils.isEmpty(this.componentIds)) return msg;
            if (!ANY_COMPONENT.equals(this.componentIds.get(0))) {
                if (!this.isChildOfComponent(foundComponent.get())) return msg;
            }
            if ((validationComponent = (IValidatedComponent)foundComponent.get()).getValidationLabelModelBinding() != null) {
                label = (String)validationComponent.getValidationLabelModelBinding().getBindingResult().getValue();
                return new MessageData(validationComponent.getId(), label, x.getMessage());
            } else {
                FormElement labelComponent;
                label = validationComponent.getLabel();
                if (StringUtils.isNullOrEmpty((String)label) && validationComponent instanceof BaseInputField && !StringUtils.isNullOrEmpty((String)((BaseInputField)validationComponent).getLabelId()) && (labelComponent = this.getForm().getFormElement(((BaseInputField)validationComponent).getLabelId())) instanceof OutputLabel) {
                    label = ((OutputLabel)labelComponent).getValue();
                }
                if (StringUtils.isNullOrEmpty((String)label) && validationComponent instanceof BaseInputField && ((BaseInputField)validationComponent).getLabelModelBinding() != null) {
                    label = ((BaseInputField)validationComponent).convertBindingValueToString(((BaseInputField)validationComponent).getLabelModelBinding().getBindingResult());
                }
                if (validationComponent.getGroupingParentComponent() != null && validationComponent.getGroupingParentComponent() instanceof TableCell) {
                    int cellNunber;
                    int colNumber;
                    TableCell tableCell = (TableCell)validationComponent.getGroupingParentComponent();
                    String tableName = null;
                    if (validationComponent.getGroupingParentComponent() instanceof TableCellOptimized) {
                        ColumnOptimized tableColumn = (ColumnOptimized)tableCell.getGroupingParentComponent();
                        TableOptimized table = tableColumn.getTable();
                        tableName = StringUtils.isNullOrEmpty((String)table.getLabel()) ? table.getId() : table.getLabel();
                        colNumber = table.getColumns().indexOf((Object)tableColumn) + 1;
                        cellNunber = tableCell.getRowIndex() + 1;
                    } else {
                        Column tableColumn = (Column)tableCell.getGroupingParentComponent();
                        Table table = tableColumn.getTable();
                        tableName = StringUtils.isNullOrEmpty((String)table.getLabel()) ? table.getId() : table.getLabel();
                        colNumber = table.getColumns().indexOf((Object)tableColumn) + 1;
                        cellNunber = tableCell.getRowIndex() + 1;
                    }
                    label = this.getForm().getAbstractUseCase().getUserSession().getValidationResults().getErrorMessage("fh.core.validation.field.table_field_error", new Object[]{tableName, cellNunber, colNumber});
                    return new MessageData(validationComponent.getId(), label, x.getMessage());
                } else {
                    if (!StringUtils.isNullOrEmpty((String)label)) return new MessageData(validationComponent.getId(), label, x.getMessage());
                    if (!this.showAttributeAsLabel) return new MessageData(validationComponent.getId(), label, x.getMessage());
                    label = this.convertIdToLabel(validationComponent.getId());
                }
            }
            return new MessageData(validationComponent.getId(), label, x.getMessage());
        }
        if (CollectionUtils.isEmpty(this.componentIds)) return msg;
        if (!ANY_COMPONENT.equals(this.componentIds.get(0))) {
            if (x.isFormSource()) return msg;
            if (!this.componentIds.contains(NOT_ASSIGNED_BUSINESS)) return msg;
        }
        if (!this.showAttributeAsLabel) return new MessageData(null, null, x.getMessage());
        return new MessageData(null, fieldName, x.getMessage());
    }

    private Optional<FormElement> findComponentBasedOnAttribute(Component basicFormElement, String attribute, Object parentObject) {
        Optional<FormElement> foundElement;
        block3: {
            Component subComponent;
            Optional<FormElement> componentBasedOnAttribute;
            boolean foundMatchingBinding;
            if (attribute == null || parentObject == null) {
                return Optional.empty();
            }
            if (basicFormElement instanceof IValidatedComponent && (foundMatchingBinding = ((IValidatedComponent)basicFormElement).getAllBingings().stream().anyMatch(binding -> this.bindingMatches((ModelBinding<?>)binding, parentObject, attribute)))) {
                return Optional.ofNullable((FormElement)basicFormElement);
            }
            foundElement = Optional.empty();
            if (!(basicFormElement instanceof IGroupingComponent)) break block3;
            List subcomponents = ((IGroupingComponent)basicFormElement).getSubcomponents();
            Iterator iterator = subcomponents.iterator();
            while (iterator.hasNext() && (!(componentBasedOnAttribute = this.findComponentBasedOnAttribute(subComponent = (Component)iterator.next(), attribute, parentObject)).isPresent() || foundElement.isPresent() && componentBasedOnAttribute.get().getAvailability().ordinal() <= foundElement.get().getAvailability().ordinal() || (foundElement = componentBasedOnAttribute).get().getAvailability() != AccessibilityEnum.EDIT)) {
            }
        }
        return foundElement;
    }

    private boolean bindingMatches(ModelBinding<?> binding, Object parentObject, String attributeName) {
        if (binding == null) {
            return false;
        }
        BindingResult bindingResult = binding.getBindingResult();
        if (bindingResult == null) {
            return false;
        }
        return Objects.equals(attributeName, binding.getBindingResult().getAttributeName()) && Objects.equals(parentObject, binding.getBindingResult().getParent());
    }

    private String convertIdToLabel(String msg) {
        if (msg != null) {
            if (msg.contains("[") && msg.contains("]")) {
                String oldRowNum = msg.substring(msg.indexOf("[") + 1, msg.indexOf("]"));
                String newRowNum = String.valueOf(Integer.valueOf(oldRowNum) + 1);
                msg = msg.replace(oldRowNum, newRowNum);
                msg = msg.replace("[", " wiersz: ");
                msg = msg.replace("]", " - ");
            }
            if (msg.contains("_")) {
                msg = msg.replaceAll("_", " ");
            }
            if (msg.contains("  ")) {
                msg = msg.replaceAll("  ", " ");
            }
        }
        return msg;
    }

    private boolean isChildOfComponent(FormElement formElement) {
        if (formElement == null) {
            return false;
        }
        if (this.componentIds.contains(formElement.getId())) {
            return true;
        }
        return this.isChildOfComponent((FormElement)formElement.getGroupingParentComponent());
    }

    public List<MessageData> getValidateMessages() {
        return this.validateMessages;
    }

    public void setValidateMessages(List<MessageData> validateMessages) {
        this.validateMessages = validateMessages;
    }

    public PresentationStyleEnum getLevel() {
        return this.level;
    }

    public void setLevel(PresentationStyleEnum level) {
        this.level = level;
    }

    public boolean isStrictLevel() {
        return this.strictLevel;
    }

    public void setStrictLevel(boolean strictLevel) {
        this.strictLevel = strictLevel;
    }

    public List<String> getComponentIds() {
        return this.componentIds;
    }

    public void setComponentIds(List<String> componentIds) {
        this.componentIds = componentIds;
    }

    public boolean isNavigation() {
        return this.navigation;
    }

    public void setNavigation(boolean navigation) {
        this.navigation = navigation;
    }
}

