/*
 * Decompiled with CFR 0.152.
 */
package pl.fhframework.model.forms;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.ReflectionUtils;
import pl.fhframework.annotations.Control;
import pl.fhframework.annotations.DesignerControl;
import pl.fhframework.annotations.DocumentedComponent;
import pl.fhframework.annotations.DocumentedComponentAttribute;
import pl.fhframework.annotations.XMLMetadataSubelements;
import pl.fhframework.annotations.XMLProperty;
import pl.fhframework.binding.AdHocModelBinding;
import pl.fhframework.binding.ModelBinding;
import pl.fhframework.binding.StaticBinding;
import pl.fhframework.core.FhException;
import pl.fhframework.core.FhFormException;
import pl.fhframework.core.dynamic.DynamicClassName;
import pl.fhframework.core.events.OnEvent;
import pl.fhframework.core.logging.FhLogger;
import pl.fhframework.core.util.StringUtils;
import pl.fhframework.forms.IFormsUtils;
import pl.fhframework.helper.AutowireHelper;
import pl.fhframework.model.dto.ElementChanges;
import pl.fhframework.model.forms.Component;
import pl.fhframework.model.forms.CompositeForm;
import pl.fhframework.model.forms.Form;
import pl.fhframework.model.forms.FormElement;
import pl.fhframework.model.forms.Group;
import pl.fhframework.model.forms.GroupingComponent;
import pl.fhframework.model.forms.IGroupingComponent;
import pl.fhframework.model.forms.Includeable;
import pl.fhframework.model.forms.NonVisualFormElement;
import pl.fhframework.tools.loading.FormReader;

@Control(canBeDesigned=true)
@DesignerControl
@DocumentedComponent(category=DocumentedComponent.Category.ARRANGEMENT, documentationExample=true, value="Component used to include xml templates into main form view", icon="fa fa-cubes")
@JsonIgnoreType
@JsonSerialize(using=Serializer.class)
public class Include
extends GroupingComponent<Component>
implements Includeable {
    private static final String ATTR_REF = "ref";
    private static final String ATTR_MODEL = "model";
    private static final String ATTR_MODEL_VALUE = "modelValue";
    private static final String ATTR_VARIANT = "variant";
    @Autowired
    private IFormsUtils formsManager;
    private static AtomicLong incId = new AtomicLong(0L);
    @JsonIgnore
    @XMLProperty(value="ref", required=true)
    @DocumentedComponentAttribute(value="Reference to composite type")
    private ModelBinding<String> refBinding;
    protected String ref = "";
    @JsonIgnore
    @XMLProperty(value="model", aliases={"model"}, required=false)
    @DocumentedComponentAttribute(value="Reference to model instance (property path) as a String. It is recommended to use modelValue attribute instead.")
    private ModelBinding<String> modelRefBinding;
    protected String modelRef = "";
    @JsonIgnore
    @XMLProperty(value="modelValue", required=false)
    @DocumentedComponentAttribute(value="Model instance")
    private ModelBinding<?> modelValueBinding;
    @JsonIgnore
    @XMLProperty(value="variant", aliases={"variant"}, required=false)
    @DocumentedComponentAttribute(value="Reference to variant as a String.")
    private ModelBinding<String> variantBinding;
    protected String variant;
    protected Form includedComposite = null;
    @XMLMetadataSubelements
    private List<OnEvent> registeredEvents = new LinkedList<OnEvent>();

    public Include(Form form) {
        super(form);
    }

    public void init() {
        super.init();
        if (this.refBinding == null) {
            throw new FhException("No composite reference");
        }
        AutowireHelper.autowire((Object)((Object)this), (Object[])new Object[]{this.formsManager});
        this.resolveBinding();
        if (this.ref == null) {
            return;
        }
        this.readComposite();
        this.includedComposite.setId(this.getForm().getId());
        this.includedComposite.setGroupingParentComponent((IGroupingComponent)this);
        this.includedComposite.setUseCase(this.getForm().getAbstractUseCase());
        this.includedComposite.setModelProvider(this.resolveModelProvider());
        if (this.includedComposite instanceof CompositeForm) {
            ((CompositeForm)this.includedComposite).addRegisteredEvents(this.registeredEvents);
        }
        if (!this.includedComposite.isInitDone()) {
            this.includedComposite.init();
        }
        if (!this.getForm().getIncluded().contains((Object)this)) {
            this.getForm().getIncluded().add(this);
        }
        this.doActionForEverySubcomponent(component -> {
            if (!component.isInitDone()) {
                component.init();
            }
        });
        this.includedComposite.setVariant(this.variant != null ? this.variant : this.getForm().getVariant());
        this.includedComposite.setAvailabilityRules(this.includedComposite.getVariant());
        this.doActionForEverySubcomponent(c -> {
            if (c.getId() == null) {
                c.generateId();
            }
            if (!c.isGeneratedId()) {
                c.setRawId(c.getId());
                c.setId(c.getId() + "_" + incId.getAndIncrement());
            }
        });
        this.doActionForEverySubcomponent(c -> {
            if (c instanceof FormElement) {
                this.getForm().addToElementIdToFormElement((FormElement)c);
            }
        });
    }

    protected Supplier resolveModelProvider() {
        if (this.getForm().getModel() != null && this.getForm().getViewMode() == Form.ViewMode.NORMAL) {
            if (this.modelValueBinding != null) {
                return () -> this.modelValueBinding.getBindingResult().getValue();
            }
            if (this.modelRef != null) {
                return () -> {
                    String[] splittedModel = this.modelRef.split("\\.");
                    Object compositeModel = this.getForm().getModel();
                    Class<?> modelClass = this.getForm().getModel().getClass();
                    for (int i = 0; i < splittedModel.length; ++i) {
                        if (i == 0 && splittedModel[i].equals("THIS")) {
                            modelClass = compositeModel.getClass();
                            continue;
                        }
                        Method modelGetter = ReflectionUtils.findMethod(modelClass, (String)Include.toGetter(splittedModel[i]));
                        if (modelGetter != null && Modifier.isPublic(modelGetter.getModifiers())) {
                            compositeModel = ReflectionUtils.invokeMethod((Method)modelGetter, (Object)compositeModel);
                            modelClass = compositeModel.getClass();
                            continue;
                        }
                        throw new FhFormException(String.format("Composite model %s in %s not found or not accessible", this.modelRef, this.getForm().getModel().getClass().getSimpleName()));
                    }
                    return compositeModel;
                };
            }
        }
        return () -> null;
    }

    protected void readComposite() {
        FormReader formReader = FormReader.getInstance();
        Class compositeComponentClass = (Class)formReader.getCompositesClasses().get(this.ref);
        if (compositeComponentClass != null) {
            this.includedComposite = this.formsManager.createFormInstance(compositeComponentClass, this.getForm().getComponentBindingCreator(), this.getForm().getBindingMethodsCreator());
        } else {
            Class formClass = this.formsManager.getFormById(this.ref);
            if (formClass != null) {
                this.includedComposite = this.formsManager.createFormInstance(formClass, this.getForm().getComponentBindingCreator(), this.getForm().getBindingMethodsCreator());
            } else {
                FhLogger.error((String)(this.ref + " is not a valid included form."), (Object[])new Object[0]);
                return;
            }
        }
    }

    private void resolveBinding() {
        if (this.modelRefBinding != null) {
            this.modelRef = (String)this.modelRefBinding.resolveValue((Object)this.modelRef);
        }
        if (this.refBinding != null) {
            this.ref = (String)this.refBinding.resolveValue((Object)this.ref);
        }
        if (this.variantBinding != null) {
            this.variant = (String)this.variantBinding.resolveValue((Object)this.variant);
        }
    }

    public void doActionForEverySubcomponent(Consumer<Component> action) {
        this.getSubcomponents().stream().forEachOrdered(c -> {
            action.accept((Component)c);
            if (c instanceof IGroupingComponent) {
                ((IGroupingComponent)c).doActionForEverySubcomponent(action);
            }
        });
    }

    public void activateBindings() {
        if (this.includedComposite != null) {
            this.includedComposite.activateBindings();
        }
    }

    public void deactivateBindings() {
        if (this.includedComposite != null) {
            this.includedComposite.deactivateBindings();
        }
    }

    public void afterNestedComponentsProcess() {
        this.getForm().refreshElementIdToFormElement();
    }

    public void refreshView(Set<ElementChanges> changeSet) {
        super.refreshView(changeSet);
        if (this.includedComposite != null) {
            this.includedComposite.getSubcomponents().forEach(c -> ((Component)c).refreshView(changeSet));
        }
    }

    public void addSubcomponent(Component component) {
        if (this.includedComposite != null) {
            this.includedComposite.addSubcomponent(component);
        }
    }

    public void removeSubcomponent(Component removedComponent) {
        if (this.includedComposite != null) {
            this.includedComposite.removeSubcomponent(removedComponent);
        }
    }

    public IGroupingComponent getGroupingComponent(Component component) {
        if (this.includedComposite != null) {
            return this.includedComposite.getGroupingParentComponent();
        }
        return this.getGroupingParentComponent();
    }

    public List<Component> getSubcomponents() {
        if (this.includedComposite != null) {
            return this.includedComposite.getSubcomponents();
        }
        return new LinkedList<Component>();
    }

    public List<NonVisualFormElement> getNonVisualSubcomponents() {
        return Collections.emptyList();
    }

    public List<Component> getIncludedComponents() {
        return this.getSubcomponents();
    }

    public void addRegisteredEvent(OnEvent onEvent) {
        this.registeredEvents.add(onEvent);
    }

    private static String toGetter(String fieldName) {
        StringBuilder sb = new StringBuilder();
        return sb.append("get").append(fieldName.substring(0, 1).toUpperCase()).append(fieldName.substring(1, fieldName.length())).toString();
    }

    public void preConfigureClear() {
        super.preConfigureClear();
        this.includedComposite = null;
        this.resetInitDone();
    }

    public String getStaticRef() {
        if (!StringUtils.isNullOrEmpty((String)this.ref)) {
            return this.ref;
        }
        String staticRefForm = null;
        if (this.refBinding instanceof StaticBinding) {
            staticRefForm = (String)((StaticBinding)this.refBinding).getStaticValue();
        } else if (this.refBinding instanceof AdHocModelBinding && ((AdHocModelBinding)this.refBinding).isStaticValue()) {
            staticRefForm = ((AdHocModelBinding)this.refBinding).getStaticValueText();
        }
        if (!StringUtils.isNullOrEmpty((String)staticRefForm)) {
            Class compositeForm = (Class)FormReader.getInstance().getCompositesClasses().get(((AdHocModelBinding)this.refBinding).getStaticValueText());
            if (compositeForm != null) {
                return DynamicClassName.forClassName((String)compositeForm.getName()).toFullClassName();
            }
            return staticRefForm;
        }
        return null;
    }

    public void calculateAvailability() {
        super.calculateAvailability();
        if (this.includedComposite != null) {
            this.includedComposite.calculateAvailability();
        }
    }

    public ModelBinding<String> getRefBinding() {
        return this.refBinding;
    }

    public void setRefBinding(ModelBinding<String> refBinding) {
        this.refBinding = refBinding;
    }

    public String getRef() {
        return this.ref;
    }

    public ModelBinding<String> getModelRefBinding() {
        return this.modelRefBinding;
    }

    public void setModelRefBinding(ModelBinding<String> modelRefBinding) {
        this.modelRefBinding = modelRefBinding;
    }

    public String getModelRef() {
        return this.modelRef;
    }

    public ModelBinding<?> getModelValueBinding() {
        return this.modelValueBinding;
    }

    public void setModelValueBinding(ModelBinding<?> modelValueBinding) {
        this.modelValueBinding = modelValueBinding;
    }

    public ModelBinding<String> getVariantBinding() {
        return this.variantBinding;
    }

    public void setVariantBinding(ModelBinding<String> variantBinding) {
        this.variantBinding = variantBinding;
    }

    public String getVariant() {
        return this.variant;
    }

    public List<OnEvent> getRegisteredEvents() {
        return this.registeredEvents;
    }

    public void setRegisteredEvents(List<OnEvent> registeredEvents) {
        this.registeredEvents = registeredEvents;
    }

    static class Serializer
    extends JsonSerializer<Include> {
        Serializer() {
        }

        public void serialize(Include tag, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            if (tag != null && tag.getSubcomponents() != null) {
                Group group = new Group(tag.getForm());
                group.setStyleClasses(((Object)((Object)tag)).getClass().getSimpleName());
                group.setId(tag.getId());
                group.getSubcomponents().addAll(tag.getSubcomponents());
                gen.writeObject((Object)group);
            }
        }
    }
}

