/*
 * Decompiled with CFR 0.152.
 */
package pl.fhframework.model.forms;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import pl.fhframework.BindingResult;
import pl.fhframework.annotations.CompilationNotSupportedIterable;
import pl.fhframework.annotations.Control;
import pl.fhframework.annotations.DesignerXMLProperty;
import pl.fhframework.annotations.DocumentedComponent;
import pl.fhframework.annotations.DocumentedComponentAttribute;
import pl.fhframework.annotations.XMLMetadataSubelement;
import pl.fhframework.annotations.XMLProperty;
import pl.fhframework.binding.ActionBinding;
import pl.fhframework.binding.AdHocActionBinding;
import pl.fhframework.binding.AdHocModelBinding;
import pl.fhframework.binding.ModelBinding;
import pl.fhframework.core.util.StringUtils;
import pl.fhframework.model.dto.ElementChanges;
import pl.fhframework.model.forms.Boundable;
import pl.fhframework.model.forms.Column;
import pl.fhframework.model.forms.CompactLayout;
import pl.fhframework.model.forms.Component;
import pl.fhframework.model.forms.Form;
import pl.fhframework.model.forms.FormElement;
import pl.fhframework.model.forms.Group;
import pl.fhframework.model.forms.GroupingComponent;
import pl.fhframework.model.forms.IGroupingComponent;
import pl.fhframework.model.forms.IRepeatableComponentsHolder;
import pl.fhframework.model.forms.PanelGroup;
import pl.fhframework.model.forms.Repeater;
import pl.fhframework.model.forms.Row;
import pl.fhframework.model.forms.Tab;
import pl.fhframework.model.forms.Table;
import pl.fhframework.model.forms.TreeElement;

@DocumentedComponent(category=DocumentedComponent.Category.TABLE_AND_TREE, documentationExample=true, ignoreFields={"width"}, value="Tree component is responsible for display certain relation between parent and childs. This component is similar too Repeater, but relation is visible.", icon="fa fa-tree")
@Control(parents={PanelGroup.class, Group.class, Column.class, Tab.class, Row.class, Form.class, Repeater.class}, invalidParents={Table.class}, canBeDesigned=true)
@CompilationNotSupportedIterable
public class Tree
extends GroupingComponent<TreeElement>
implements Boundable,
CompactLayout,
IRepeatableComponentsHolder {
    private static final String ATTR_LAZY = "lazy";
    private static final String ATTR_NEXT_LEVEL_ACTIVE = "nextLevelExpandableExpression";
    @JsonIgnore
    @XMLProperty(value="collection")
    @DesignerXMLProperty(allowedTypes={Collection.class}, commonUse=true)
    @DocumentedComponentAttribute(boundable=true, value="Collection of data to be displayed")
    private ModelBinding bindingForNodes;
    @JsonIgnore
    @DocumentedComponentAttribute(boundable=true, value="Name of the property in object, that should process nested relation")
    @XMLProperty
    @DesignerXMLProperty(commonUse=true)
    private String relation;
    @JsonIgnore
    @XMLProperty(value="nextLevelExpandableExpression", defaultValue="true")
    @DocumentedComponentAttribute(boundable=true, value="Current object based expression which checks if next level should be expandable, which means that state / type of the object suggests that it has / may have child nodes. Returned value may be false-positive which results in disapearing of expand icon after clicking on it. Used only when lazy=true.", defaultValue="true")
    private String nextLevelExpandableExpression;
    @JsonIgnore
    @XMLProperty
    @DesignerXMLProperty(commonUse=true)
    @DocumentedComponentAttribute(value="Name of the iterator variable used to refer each data")
    private String iterator;
    @JsonIgnore
    @XMLProperty(value="selected")
    @DocumentedComponentAttribute(boundable=true, value="Selected object")
    private ModelBinding selectedBinding;
    @XMLProperty(defaultValue="fas fa-caret-down")
    @DocumentedComponentAttribute(defaultValue="fas fa-caret-down", value="Collapse icon")
    private String nodeIcon = "fas fa-caret-down";
    @XMLProperty(defaultValue="fas fa-caret-right")
    @DocumentedComponentAttribute(defaultValue="fas fa-caret-right", value="Expand icon")
    private String collapsedNodeIcon = "fas fa-caret-right";
    @XMLProperty(defaultValue="hidden")
    @DocumentedComponentAttribute(value="Leaf icon, displayed when node has no children. Default is 'hidden'")
    private String leafIcon = "hidden";
    @XMLProperty(defaultValue="true")
    @DocumentedComponentAttribute(value="Draw lines between parent and children. Default is 'true'")
    private boolean lines = true;
    @XMLProperty(defaultValue="true")
    @DocumentedComponentAttribute(value="Is tree processing itself, once it was displayed.", defaultValue="true")
    private boolean dynamic = true;
    @XMLProperty(defaultValue="false")
    @DocumentedComponentAttribute(value="Are all levels already opened by default. This option is ignored when lazy = true.", defaultValue="false")
    private boolean expanded = false;
    @XMLProperty(value="lazy", defaultValue="false")
    @DocumentedComponentAttribute(value="Are tree node lazy loaded while user expands them.", defaultValue="false")
    private boolean lazy = false;
    @JsonIgnore
    private boolean childrenLoaded;
    @JsonIgnore
    @XMLMetadataSubelement
    private TreeElement templateTreeElement;

    public Tree(Form form) {
        super(form);
    }

    public void init() {
        super.init();
        if (this.templateTreeElement == null) {
            this.templateTreeElement = new TreeElement(this.getForm());
            this.templateTreeElement.setTree(this);
        }
        this.templateTreeElement.init();
    }

    public void setBindingForNodes(ModelBinding bindingForNodes) {
        this.bindingForNodes = bindingForNodes;
    }

    protected ElementChanges updateView() {
        return super.updateView();
    }

    public void processComponents() {
        if (this.childrenLoaded && !this.dynamic) {
            return;
        }
        this.processComponentsForLevel(new int[0], 0, (IGroupingComponent<TreeElement>)this);
        this.childrenLoaded = true;
    }

    void processComponentsForLevel(int[] parentIndices, int level, IGroupingComponent<TreeElement> groupingComponent) {
        block6: {
            Collection bindedCollection;
            block7: {
                if (this.getForm().getViewMode() != Form.ViewMode.NORMAL) {
                    return;
                }
                String collectionBinding = this.buildCollectionBinding(parentIndices, level);
                BindingResult bindingResult = this.getForm().getBindingResult(collectionBinding, (Component)groupingComponent);
                if (bindingResult == null || bindingResult.getValue() == null) break block6;
                bindedCollection = (Collection)bindingResult.getValue();
                if (bindedCollection.size() <= groupingComponent.getSubcomponents().size()) break block7;
                for (int i = groupingComponent.getSubcomponents().size(); i < bindedCollection.size(); ++i) {
                    String onClickIndexed;
                    TreeElement clonedTreeElement = (TreeElement)((Object)this.templateTreeElement.clone().get());
                    int[] indices = Arrays.copyOf(parentIndices, parentIndices.length + 1);
                    indices[level] = i;
                    clonedTreeElement.setId(this.generateId(clonedTreeElement.getId(), indices));
                    clonedTreeElement.setIndices(indices);
                    clonedTreeElement.setLevel(level);
                    clonedTreeElement.setIconBinding(this.replaceModelBinding(clonedTreeElement.getIconBinding(), indices, level, clonedTreeElement));
                    clonedTreeElement.setLabelModelBinding(this.replaceModelBinding(clonedTreeElement.getLabelModelBinding(), indices, level, clonedTreeElement));
                    clonedTreeElement.setUrlBinding(this.replaceModelBinding(clonedTreeElement.getUrlBinding(), indices, level, clonedTreeElement));
                    clonedTreeElement.setAvailabilityModelBinding(this.replaceModelBinding(clonedTreeElement.getAvailabilityModelBinding(), indices, level, clonedTreeElement));
                    if (clonedTreeElement.getOnLabelClick() != null) {
                        onClickIndexed = this.replaceBinding(clonedTreeElement.getOnLabelClick().getActionBindingExpression(), indices, level);
                        clonedTreeElement.setOnLabelClick((ActionBinding)new AdHocActionBinding(onClickIndexed, this.getForm(), (Component)clonedTreeElement));
                    }
                    if (clonedTreeElement.getOnIconClick() != null) {
                        onClickIndexed = this.replaceBinding(clonedTreeElement.getOnIconClick().getActionBindingExpression(), indices, level);
                        clonedTreeElement.setOnIconClick((ActionBinding)new AdHocActionBinding(onClickIndexed, this.getForm(), (Component)clonedTreeElement));
                    }
                    if (clonedTreeElement.getOnDesignerToolboxDrop() != null) {
                        String onDesignerToolboxDropIndexed = this.replaceBinding(clonedTreeElement.getOnDesignerToolboxDrop().getActionBindingExpression(), indices, level);
                        clonedTreeElement.setOnDesignerToolboxDrop((ActionBinding)new AdHocActionBinding(onDesignerToolboxDropIndexed, this.getForm(), (Component)clonedTreeElement));
                    }
                    clonedTreeElement.setCollectionBinding(collectionBinding);
                    clonedTreeElement.setElementBinding(this.buildElementBinding(indices, level));
                    groupingComponent.getSubcomponents().add(clonedTreeElement);
                    clonedTreeElement.setGroupingParentComponent(groupingComponent);
                    clonedTreeElement.getBindingContext().getIteratorContext().putAll(((Component)groupingComponent).getBindingContext().getIteratorContext());
                    clonedTreeElement.getBindingContext().setCachePrefix(((Component)groupingComponent).getBindingContext().getCachePrefix());
                    this.getForm().addToElementIdToFormElement((FormElement)clonedTreeElement);
                }
                break block6;
            }
            if (bindedCollection.size() >= groupingComponent.getSubcomponents().size()) break block6;
            while (bindedCollection.size() < groupingComponent.getSubcomponents().size()) {
                groupingComponent.getSubcomponents().remove(groupingComponent.getSubcomponents().size() - 1);
            }
        }
    }

    ModelBinding replaceModelBinding(ModelBinding binding, int[] indices, int level, TreeElement clonedTreeElement) {
        if (binding == null || !StringUtils.hasSurroundingBraces((String)binding.getBindingExpression())) {
            return binding;
        }
        return new AdHocModelBinding(this.getForm(), (Component)clonedTreeElement, this.replaceBinding(binding.getBindingExpression(), indices, level));
    }

    String replaceBinding(String binding, int[] indices, int level) {
        if (binding != null) {
            Matcher bindingMatcher;
            Pattern pattern = Pattern.compile("^(.*[\\(\\{\\s\\,])?(" + Matcher.quoteReplacement(this.iterator) + ")([\\,\\s\\}\\)\\.\\[].*)$");
            String elementBinding = this.buildElementBinding(indices, level);
            int counter = 0;
            while ((bindingMatcher = pattern.matcher(binding)).find()) {
                String prefix = bindingMatcher.group(1) != null ? bindingMatcher.group(1) : "";
                String suffix = bindingMatcher.group(3) != null ? bindingMatcher.group(3) : "";
                binding = prefix + elementBinding + suffix;
                if (counter++ < 20) continue;
            }
        }
        return binding;
    }

    private String buildElementBinding(int[] indices, int level) {
        return this.buildCollectionBinding(indices, level) + "[" + indices[level] + "]";
    }

    String buildCollectionBinding(int[] indices, int level) {
        String collectionBinding = StringUtils.removeSurroundingBraces((String)this.bindingForNodes.getBindingExpression());
        for (int i = 0; i < level; ++i) {
            collectionBinding = collectionBinding + "[" + indices[i] + "]." + StringUtils.removeSurroundingBraces((String)this.relation);
        }
        return collectionBinding;
    }

    private String generateId(String originalId, int[] indices) {
        for (int i : indices) {
            originalId = originalId + "[" + i + "]";
        }
        return originalId;
    }

    public void refreshView(Set<ElementChanges> changeSet) {
        super.refreshView(changeSet);
    }

    public void onSelectionClick(Object anObject) {
        if (this.selectedBinding == null) {
            return;
        }
        if (this.selectedBinding.getBindingResult() != null && this.selectedBinding.getBindingResult().getValue() instanceof Collection) {
            Collection col = (Collection)this.selectedBinding.getBindingResult().getValue();
            if (col.contains(anObject)) {
                col.remove(anObject);
            } else {
                col.add(anObject);
            }
        } else {
            this.getForm().activateBindings();
            this.updateBindingForValue(anObject, this.selectedBinding, this.selectedBinding.getBindingExpression(), Optional.empty());
            this.getForm().deactivateBindings();
        }
    }

    @JsonIgnore
    public boolean isSelected(Object anObject) {
        if (anObject == null) {
            return false;
        }
        if (this.selectedBinding == null || this.selectedBinding.getBindingResult() == null) {
            return false;
        }
        if (this.selectedBinding.getBindingResult().getValue() instanceof Collection) {
            return ((Collection)this.selectedBinding.getBindingResult()).contains(anObject);
        }
        return anObject.equals(this.selectedBinding.getBindingResult().getValue());
    }

    void deselectAll() {
        this.getSubcomponents().forEach(this::deselectAllChild);
    }

    private void deselectAllChild(TreeElement treeElement) {
        treeElement.setSelected(false);
        treeElement.getSubcomponents().forEach(this::deselectAllChild);
    }

    public boolean isSelectionOn() {
        return this.selectedBinding != null;
    }

    public List<TreeElement> getSubcomponents() {
        if (this.getForm().getViewMode() == Form.ViewMode.NORMAL) {
            return super.getSubcomponents();
        }
        return Arrays.asList(this.templateTreeElement);
    }

    public List<Component> getRepeatedComponents() {
        return Arrays.asList(new Component[]{this.templateTreeElement});
    }

    public ModelBinding getBindingForNodes() {
        return this.bindingForNodes;
    }

    public String getRelation() {
        return this.relation;
    }

    public void setRelation(String relation) {
        this.relation = relation;
    }

    public String getNextLevelExpandableExpression() {
        return this.nextLevelExpandableExpression;
    }

    public void setNextLevelExpandableExpression(String nextLevelExpandableExpression) {
        this.nextLevelExpandableExpression = nextLevelExpandableExpression;
    }

    public String getIterator() {
        return this.iterator;
    }

    public void setIterator(String iterator) {
        this.iterator = iterator;
    }

    public ModelBinding getSelectedBinding() {
        return this.selectedBinding;
    }

    public void setSelectedBinding(ModelBinding selectedBinding) {
        this.selectedBinding = selectedBinding;
    }

    public String getNodeIcon() {
        return this.nodeIcon;
    }

    public void setNodeIcon(String nodeIcon) {
        this.nodeIcon = nodeIcon;
    }

    public String getCollapsedNodeIcon() {
        return this.collapsedNodeIcon;
    }

    public void setCollapsedNodeIcon(String collapsedNodeIcon) {
        this.collapsedNodeIcon = collapsedNodeIcon;
    }

    public String getLeafIcon() {
        return this.leafIcon;
    }

    public void setLeafIcon(String leafIcon) {
        this.leafIcon = leafIcon;
    }

    public boolean isLines() {
        return this.lines;
    }

    public void setLines(boolean lines) {
        this.lines = lines;
    }

    public boolean isDynamic() {
        return this.dynamic;
    }

    public void setDynamic(boolean dynamic) {
        this.dynamic = dynamic;
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public void setExpanded(boolean expanded) {
        this.expanded = expanded;
    }

    public boolean isLazy() {
        return this.lazy;
    }

    public void setLazy(boolean lazy) {
        this.lazy = lazy;
    }

    public boolean isChildrenLoaded() {
        return this.childrenLoaded;
    }

    public TreeElement getTemplateTreeElement() {
        return this.templateTreeElement;
    }

    public void setTemplateTreeElement(TreeElement templateTreeElement) {
        this.templateTreeElement = templateTreeElement;
    }
}

