/*
 * Decompiled with CFR 0.152.
 */
package pl.fhframework.model.forms.validation.impl;

import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import pl.fhframework.core.i18n.MessageService;
import pl.fhframework.model.forms.BaseInputField;
import pl.fhframework.validation.ConstraintViolation;
import pl.fhframework.validation.Validator;

@Component
public class ValidationRule
implements Validator<BaseInputField> {
    @Autowired
    private MessageService messageService;

    public boolean canProcessValidation(Object object) {
        BaseInputField baseInputField = (BaseInputField)object;
        String validationRule = baseInputField.getValidationRule();
        return !StringUtils.isEmpty((Object)validationRule) && validationRule.startsWith("-");
    }

    public List<ConstraintViolation<BaseInputField>> validate(BaseInputField value) {
        ArrayList<ConstraintViolation<BaseInputField>> violations = new ArrayList<ConstraintViolation<BaseInputField>>();
        if (!this.canProcessValidation(value)) {
            return violations;
        }
        String validationRule = value.getValidationRule();
        String skipFirstChar = validationRule.substring(1);
        if (!value.getForm().expressionResult(skipFirstChar)) {
            String constraint = skipFirstChar.replace(" lt ", "<").replace(" eq ", "=").replace(" gt ", ">");
            Object[] args = new Object[]{constraint};
            this.addConstraintViolation(violations, value, this.messageService.getAllBundles().getMessage("fh.core.validation.field.validation_rule", args));
        }
        return violations;
    }
}

