/*
 * Decompiled with CFR 0.152.
 */
package pl.fhframework.model.forms;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.util.StringUtils;
import pl.fhframework.BindingResult;
import pl.fhframework.annotations.Control;
import pl.fhframework.annotations.DesignerControl;
import pl.fhframework.annotations.DesignerXMLProperty;
import pl.fhframework.annotations.DocumentedComponent;
import pl.fhframework.annotations.DocumentedComponentAttribute;
import pl.fhframework.annotations.TemplateControl;
import pl.fhframework.annotations.XMLProperty;
import pl.fhframework.binding.ActionBinding;
import pl.fhframework.binding.CallbackActionBinding;
import pl.fhframework.binding.IActionCallback;
import pl.fhframework.binding.IActionCallbackContext;
import pl.fhframework.binding.ModelBinding;
import pl.fhframework.core.forms.IHasBoundableLabel;
import pl.fhframework.model.dto.ElementChanges;
import pl.fhframework.model.dto.InMessageEventData;
import pl.fhframework.model.forms.ButtonGroup;
import pl.fhframework.model.forms.Column;
import pl.fhframework.model.forms.Component;
import pl.fhframework.model.forms.Footer;
import pl.fhframework.model.forms.Form;
import pl.fhframework.model.forms.FormElementWithConfirmationSupport;
import pl.fhframework.model.forms.Group;
import pl.fhframework.model.forms.PanelGroup;
import pl.fhframework.model.forms.Repeater;
import pl.fhframework.model.forms.Row;
import pl.fhframework.model.forms.Styleable;
import pl.fhframework.model.forms.Tab;
import pl.fhframework.model.forms.Table;
import pl.fhframework.model.forms.TableComponent;
import pl.fhframework.model.forms.designer.BindingExpressionDesignerPreviewProvider;
import pl.fhframework.model.forms.designer.ButtonStyleFixedValuesProvider;
import pl.fhframework.model.forms.optimized.ColumnOptimized;

@TemplateControl(tagName="fh-button")
@Control(parents={PanelGroup.class, Column.class, ColumnOptimized.class, Tab.class, Form.class, ButtonGroup.class, Group.class, Row.class, Footer.class, Repeater.class}, invalidParents={Table.class}, canBeDesigned=true)
@DocumentedComponent(category=DocumentedComponent.Category.BUTTONS_AND_OTHER, value="Button which represents HTML input", icon="fa fa-square")
@DesignerControl(defaultWidth=2)
public class Button
extends FormElementWithConfirmationSupport
implements TableComponent<Button>,
Styleable,
IHasBoundableLabel {
    public static final String ATTR_LABEL = "label";
    public static final String ATTR_STYLE = "style";
    public static final String ATTR_ON_CLICK = "onClick";
    public static final String TYPE_NAME = "Button";
    @XMLProperty
    @DesignerXMLProperty(commonUse=true, functionalArea=DesignerXMLProperty.PropertyFunctionalArea.BEHAVIOR, priority=90)
    @DocumentedComponentAttribute(value="If the button is clicked that method will be executed. Action is fired, while component is active.")
    private ActionBinding onClick;
    @JsonIgnore
    @XMLProperty(required=true, value="label")
    @DesignerXMLProperty(commonUse=true, functionalArea=DesignerXMLProperty.PropertyFunctionalArea.CONTENT, previewValueProvider=BindingExpressionDesignerPreviewProvider.class, priority=100)
    @DocumentedComponentAttribute(boundable=true, value="Component label")
    private ModelBinding labelModelBinding;
    private String label;
    private Styleable.Style style = Styleable.Style.PRIMARY;
    @XMLProperty
    @DocumentedComponentAttribute(defaultValue="test", value="test")
    @DesignerXMLProperty(functionalArea=DesignerXMLProperty.PropertyFunctionalArea.LOOK_AND_STYLE, priority=78, allowedTypes={String.class})
    private String leftPadding = null;
    @JsonIgnore
    @XMLProperty(value="style")
    @DocumentedComponentAttribute(boundable=true, defaultValue="primary", value="Determines style of a Button. It is possible to select one of six Bootstrap classes: default, primary, success, info, warning, danger or bind it with variable.")
    @DesignerXMLProperty(functionalArea=DesignerXMLProperty.PropertyFunctionalArea.LOOK_AND_STYLE, priority=77, fixedValuesProvider=ButtonStyleFixedValuesProvider.class)
    private ModelBinding styleModelBinding;

    public Button(Form form) {
        super(form);
    }

    public void init() {
        super.init();
        this.calculateAndSetDefaultSize();
    }

    private void calculateAndSetDefaultSize() {
        if (!StringUtils.hasText((String)this.getWidth())) {
            this.setWidth("md-3");
        }
    }

    public String getType() {
        return TYPE_NAME;
    }

    public Optional<ActionBinding> getEventHandler(InMessageEventData eventData) {
        if (eventData.getEventType().equals(ATTR_ON_CLICK)) {
            return Optional.ofNullable(this.onClick);
        }
        return super.getEventHandler(eventData);
    }

    public ElementChanges updateView() {
        ElementChanges elementChanges = super.updateView();
        if (this.labelModelBinding != null) {
            boolean refreshView;
            String newLabelValue;
            Object newLabelValueObj = this.labelModelBinding.getBindingResult().getValue();
            String string = newLabelValue = newLabelValueObj != null ? newLabelValueObj.toString() : null;
            if (!this.areValuesTheSame(newLabelValue, this.label)) {
                this.label = newLabelValue;
                elementChanges.addChange(ATTR_LABEL, (Object)this.label);
            }
            if (refreshView = this.processStyleBinding(elementChanges, false)) {
                this.refreshView();
            }
        }
        return elementChanges;
    }

    protected boolean processStyleBinding(ElementChanges elementChanges, boolean refreshView) {
        String newLabelValue;
        BindingResult labelBidingResult;
        BindingResult bindingResult = labelBidingResult = this.styleModelBinding != null ? this.styleModelBinding.getBindingResult() : null;
        if (labelBidingResult != null && !this.areValuesTheSame(newLabelValue = this.convertBindingValueToString(labelBidingResult), this.style.toValue())) {
            this.style = Styleable.Style.forValue(newLabelValue);
            elementChanges.addChange(ATTR_STYLE, (Object)this.style);
            refreshView = true;
        }
        return refreshView;
    }

    @Override
    public Button createNewSameComponent() {
        return new Button(this.getForm());
    }

    @Override
    public void doCopy(Table table, Map<String, String> iteratorReplacements, Button clonedButton) {
        TableComponent.super.doCopy(table, iteratorReplacements, clonedButton);
        clonedButton.setLeftPadding(this.getLeftPadding());
        clonedButton.setOnClick(table.getRowBinding(this.getOnClick(), (Component)clonedButton, iteratorReplacements));
        clonedButton.setLabelModelBinding(table.getRowBinding(this.getLabelModelBinding(), (Component)clonedButton, iteratorReplacements));
        clonedButton.setStyleModelBinding(table.getRowBinding(this.getStyleModelBinding(), (Component)clonedButton, iteratorReplacements));
        clonedButton.setAriaLabelBinding(table.getRowBinding(this.getAriaLabelBinding(), (Component)clonedButton, iteratorReplacements));
    }

    protected List<ActionBinding> getAvailablityAffectingActions() {
        return Arrays.asList(this.onClick);
    }

    public IActionCallbackContext setOnClick(IActionCallback callback) {
        return CallbackActionBinding.createAndSet((IActionCallback)callback, this::setOnClick);
    }

    public void setOnClick(ActionBinding onClick) {
        this.onClick = onClick;
    }

    public ActionBinding getOnClick() {
        return this.onClick;
    }

    public ModelBinding getLabelModelBinding() {
        return this.labelModelBinding;
    }

    public void setLabelModelBinding(ModelBinding labelModelBinding) {
        this.labelModelBinding = labelModelBinding;
    }

    public String getLabel() {
        return this.label;
    }

    public Styleable.Style getStyle() {
        return this.style;
    }

    public String getLeftPadding() {
        return this.leftPadding;
    }

    public void setLeftPadding(String leftPadding) {
        this.leftPadding = leftPadding;
    }

    public ModelBinding getStyleModelBinding() {
        return this.styleModelBinding;
    }

    public void setStyleModelBinding(ModelBinding styleModelBinding) {
        this.styleModelBinding = styleModelBinding;
    }
}

