/*
 * Decompiled with CFR 0.152.
 */
package pl.fhframework.model.forms;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.expression.Expression;
import pl.fhframework.BindingResult;
import pl.fhframework.annotations.Control;
import pl.fhframework.annotations.DesignerControl;
import pl.fhframework.annotations.DesignerXMLProperty;
import pl.fhframework.annotations.DocumentedComponent;
import pl.fhframework.annotations.DocumentedComponentAttribute;
import pl.fhframework.annotations.XMLProperty;
import pl.fhframework.binding.ActionBinding;
import pl.fhframework.binding.CallbackActionBinding;
import pl.fhframework.binding.IActionCallback;
import pl.fhframework.binding.IActionCallbackContext;
import pl.fhframework.binding.ModelBinding;
import pl.fhframework.core.FhBindingException;
import pl.fhframework.core.forms.IValidatedComponent;
import pl.fhframework.core.util.JsonUtil;
import pl.fhframework.core.util.SpelUtils;
import pl.fhframework.core.util.StringUtils;
import pl.fhframework.model.PresentationStyleEnum;
import pl.fhframework.model.dto.ElementChanges;
import pl.fhframework.model.dto.InMessageEventData;
import pl.fhframework.model.dto.ValueChange;
import pl.fhframework.model.forms.AccessibilityEnum;
import pl.fhframework.model.forms.BaseInputField;
import pl.fhframework.model.forms.BaseInputFieldWithKeySupport;
import pl.fhframework.model.forms.Column;
import pl.fhframework.model.forms.Component;
import pl.fhframework.model.forms.Form;
import pl.fhframework.model.forms.FormElement;
import pl.fhframework.model.forms.Group;
import pl.fhframework.model.forms.IComboItem;
import pl.fhframework.model.forms.PanelGroup;
import pl.fhframework.model.forms.Repeater;
import pl.fhframework.model.forms.Row;
import pl.fhframework.model.forms.Tab;
import pl.fhframework.model.forms.Table;
import pl.fhframework.model.forms.optimized.ColumnOptimized;
import pl.fhframework.model.forms.validation.ValidationFactory;
import pl.fhframework.validation.FieldValidationResult;
import pl.fhframework.validation.FormFieldHints;
import pl.fhframework.validation.IValidationResults;
import pl.fhframework.validation.ValidationManager;

@DocumentedComponent(category=DocumentedComponent.Category.INPUTS_AND_VALIDATION, value="Enables users to quickly find and select from a pre-populated list of values as they type, leveraging searching and filtering.", icon="fa fa-outdent")
@DesignerControl(defaultWidth=3)
@Control(parents={PanelGroup.class, Group.class, Column.class, ColumnOptimized.class, Tab.class, Row.class, Form.class, Repeater.class}, invalidParents={Table.class}, canBeDesigned=true)
public class SelectComboMenu
extends BaseInputFieldWithKeySupport {
    private static final String ON_SPECIAL_KEY_ATTR = "onSpecialKey";
    private static final String ON_DBL_SPECIAL_KEY_ATTR = "onDblSpecialKey";
    private static final String ON_INPUT_ATTR = "onInput";
    private static final String ON_EMPTY_VALUE_ATTR = "onEmptyValue";
    private static final String VALUES_ATTR = "values";
    protected static final String TEXT = "text";
    private static final String FILTERED_VALUES = "filteredValues";
    private static final String HIGHLIGHTED_VALUE = "highlightedValue";
    private static final String FIRE_CHANGE_ACTION = "fireChange";
    private static final String FILTER_FUNCTION_ATTR = "filterFunction";
    protected static final String SELECTED_INDEX_ATTR = "selectedIndex";
    private static final String FORMATTER_ATTR = "formatter";
    private static final String FREE_TYPING = "freeTyping";
    private static final String DISPLAY_FUNCTION_ATTR = "displayFunction";
    private static final String DISPLAY_RULE_ATTR = "displayExpression";
    @XMLProperty
    @DocumentedComponentAttribute(defaultValue="false", value="Determines if empty value should be displayed on list of options.")
    @DesignerXMLProperty(priority=60, functionalArea=DesignerXMLProperty.PropertyFunctionalArea.CONTENT)
    protected boolean emptyLabel;
    @XMLProperty
    @DocumentedComponentAttribute(value="Determines empty value text displayed on list of options.")
    @DesignerXMLProperty(priority=60, functionalArea=DesignerXMLProperty.PropertyFunctionalArea.CONTENT)
    private String emptyLabelText;
    @XMLProperty(defaultValue="-")
    @DesignerXMLProperty(functionalArea=DesignerXMLProperty.PropertyFunctionalArea.BEHAVIOR)
    @DocumentedComponentAttribute(value="If there is some value, representing method in use case, then on every action in input,  that method will be executed. Action is fired, while component is active.", defaultValue="-")
    private ActionBinding onInput;
    @XMLProperty
    @DesignerXMLProperty(functionalArea=DesignerXMLProperty.PropertyFunctionalArea.BEHAVIOR)
    @DocumentedComponentAttribute(value="If there is some value, representing method in use case, then on clearing value,  that method will be executed. Action is fired, while component is active.")
    private ActionBinding onEmptyValue;
    @XMLProperty
    @DesignerXMLProperty(functionalArea=DesignerXMLProperty.PropertyFunctionalArea.BEHAVIOR)
    @DocumentedComponentAttribute(value="If there is some value, representing method in use case, that will be called every time a special key (Ctrl+Space) is pressed.")
    private ActionBinding onSpecialKey;
    @XMLProperty
    @DesignerXMLProperty(functionalArea=DesignerXMLProperty.PropertyFunctionalArea.BEHAVIOR)
    @DocumentedComponentAttribute(value="If there is some value, representing method in use case, that will be called every time a special key (Ctrl+Space) is pressed 2 times.")
    private ActionBinding onDblSpecialKey;
    @JsonIgnore
    protected Object selectedItem;
    @JsonIgnore
    protected Integer selectedItemIndex;
    protected String rawValue;
    @JsonIgnore
    protected String filterText = "";
    @JsonIgnore
    protected List<Object> values = new LinkedList<Object>();
    @JsonIgnore
    protected List<Object> filteredObjectValues = new LinkedList<Object>();
    protected List<SelectComboItemDTO> filteredValues = new LinkedList<SelectComboItemDTO>();
    @JsonIgnore
    private Object highlightedObjectValue = null;
    protected SelectComboItemDTO highlightedValue = null;
    @JsonIgnore
    @XMLProperty(value="values")
    @DesignerXMLProperty(commonUse=true, allowedTypes={Collection.class, String.class}, functionalArea=DesignerXMLProperty.PropertyFunctionalArea.CONTENT, priority=81)
    private ModelBinding valuesBinding;
    @JsonIgnore
    protected BiPredicate<Object, String> filterFunction;
    @JsonIgnore
    @XMLProperty(value="filterFunction")
    @DesignerXMLProperty(allowedTypes={BiPredicate.class})
    @DocumentedComponentAttribute(defaultValue="Default function: (model, value) -> ((String) model).toLowerCase().contains(value.toLowerCase())", boundable=true, value="Name of model object (java.util.function.BiPredicate) which will be used to filter items by text.")
    private ModelBinding filterFunctionBinding;
    @JsonIgnore
    protected boolean filterInvoked;
    @JsonIgnore
    protected boolean fireOnchange = false;
    @XMLProperty
    @DocumentedComponentAttribute(defaultValue="false", value="Defines if combo values should be present even if no text is typed")
    protected boolean preload;
    @JsonIgnore
    @XMLProperty(value="formatter")
    @DocumentedComponentAttribute(value="Id of formatter which will format object to String. It must be consistent with value of pl.fhframework.formatter.FhFormatter annotation.")
    private String formatter;
    @JsonIgnore
    protected boolean firstLoad = true;
    protected boolean freeTyping = false;
    @JsonIgnore
    @XMLProperty(value="freeTyping")
    @DocumentedComponentAttribute(boundable=true, defaultValue="false", value="Defines if new values could be typed be user.  Binding changes may not be respected after initially showing this control.")
    private ModelBinding<Boolean> freeTypingBinding;
    @JsonIgnore
    @XMLProperty(value="displayFunction")
    @DesignerXMLProperty(allowedTypes={Function.class})
    @DocumentedComponentAttribute(boundable=true, value="Name of model object (java.util.function.Function) which will be used to format items as text.")
    private ModelBinding displayFunctionBinding;
    @JsonIgnore
    @XMLProperty(value="displayExpression")
    @DesignerXMLProperty(commonUse=true, allowedTypes={String.class}, functionalArea=DesignerXMLProperty.PropertyFunctionalArea.CONTENT)
    @DocumentedComponentAttribute(boundable=true, value="Rule which will be used to format items as text.")
    private String displayExpression;
    @JsonIgnore
    private Function<Object, String> displayExpressionFunction;

    public SelectComboMenu(Form form) {
        super(form);
    }

    @Override
    public Optional<ActionBinding> getEventHandler(InMessageEventData eventData) {
        if (ON_INPUT_ATTR.equals(eventData.getEventType())) {
            return Optional.ofNullable(this.onInput);
        }
        if (ON_SPECIAL_KEY_ATTR.equals(eventData.getEventType())) {
            return Optional.ofNullable(this.onSpecialKey);
        }
        if (ON_DBL_SPECIAL_KEY_ATTR.equals(eventData.getEventType())) {
            return Optional.ofNullable(this.onDblSpecialKey);
        }
        if (ON_EMPTY_VALUE_ATTR.equals(eventData.getEventType())) {
            return Optional.ofNullable(this.onEmptyValue);
        }
        return super.getEventHandler(eventData);
    }

    @Override
    public void updateModel(ValueChange valueChange) {
        String textObj = valueChange.getStringAttribute(TEXT);
        if (textObj != null && textObj.equals("")) {
            this.filterText = "";
            this.processFiltering(this.filterText);
            this.selectedItemIndex = -1;
            this.selectedItem = null;
            this.rawValue = null;
            this.changeSelectedItemBinding();
        } else if (textObj != null) {
            String text;
            this.filterText = text = textObj;
            this.processFiltering(text);
            this.firstLoad = false;
            this.selectItemByFilterText();
            this.changeSelectedItemBinding();
            if (this.freeTyping) {
                this.selectedItem = StringUtils.emptyToNull((String)text);
                this.rawValue = (String)this.selectedItem;
                this.changeSelectedItemBinding();
            }
        }
        if (valueChange.hasAttributeChanged(SELECTED_INDEX_ATTR)) {
            this.selectedItemIndex = valueChange.getIntAttribute(SELECTED_INDEX_ATTR);
            this.selectedItem = this.selectedItemIndex >= 0 ? this.filteredObjectValues.get(this.selectedItemIndex) : null;
            this.changeSelectedItemBinding();
            this.rawValue = this.selectedItem != null ? this.toRawValue(this.selectedItem) : null;
            this.filterText = this.rawValue != null ? this.rawValue : "";
            this.processFiltering(this.filterText);
        }
    }

    private void selectItemByFilterText() {
        List<SelectComboItemDTO> entry = this.collectValues(this.filteredObjectValues);
        for (SelectComboItemDTO item : entry) {
            if (!Objects.equals(this.filterText, item.isDisplayAsTarget() ? item.getTargetValue() : item.getDisplayedValue())) continue;
            this.selectedItemIndex = entry.indexOf(item);
            this.selectedItem = this.filteredObjectValues.get(this.selectedItemIndex);
            this.rawValue = this.toRawValue(this.selectedItem);
            this.fireOnchange = true;
            return;
        }
    }

    @Override
    public void validate() {
        if (this.getModelBinding() != null && this.getModelBinding().getBindingResult() != null) {
            this.validConversion = Objects.equals(StringUtils.nullToEmpty((String)this.filterText), StringUtils.nullToEmpty((String)this.rawValue));
            ValidationManager<SelectComboMenu> vm = ValidationFactory.getInstance().getSelectComboValidationProcess();
            List formComponentValidationResult = vm.validate((Object)this);
            IValidationResults validationResults = this.getForm().getAbstractUseCase().getUserSession().getValidationResults();
            BindingResult bindingResult = this.getModelBinding().getBindingResult();
            formComponentValidationResult.forEach(x -> validationResults.addCustomMessageForComponent((IValidatedComponent)this, bindingResult.getParent(), bindingResult.getAttributeName(), x.getMessage(), PresentationStyleEnum.BLOCKER));
        }
    }

    @Override
    public void prepareComponentAfterValidation(ElementChanges elementChanges) {
        List fieldValidationResultFor;
        IValidationResults validationResults = this.getForm().getAbstractUseCase().getUserSession().getValidationResults();
        BindingResult bindingResult = this.getModelBinding() != null ? this.getModelBinding().getBindingResult() : null;
        List list = fieldValidationResultFor = bindingResult == null ? Collections.emptyList() : validationResults.getFieldValidationResultFor(bindingResult.getParent(), bindingResult.getAttributeName());
        if (this.getAvailability() != AccessibilityEnum.EDIT) {
            fieldValidationResultFor.removeIf(FieldValidationResult::isFormSource);
        }
        this.processStylesAndHints(elementChanges, fieldValidationResultFor);
    }

    @Override
    protected FormFieldHints processPresentationStyle(ElementChanges elementChanges, List<FieldValidationResult> fieldValidationResults) {
        BindingResult bindingResult;
        PresentationStyleEnum oldPresentationStyle = this.getPresentationStyle();
        FormFieldHints formFieldHints = null;
        BindingResult bindingResult2 = bindingResult = this.getModelBinding() != null ? this.getModelBinding().getBindingResult() : null;
        if (bindingResult != null) {
            formFieldHints = this.calculatePresentationStyle(this.getModelBinding().getBindingResult());
            this.setPresentationStyle(formFieldHints != null ? formFieldHints.getPresentationStyleEnum() : null);
        } else {
            this.setPresentationStyle(null);
        }
        if (!(fieldValidationResults.isEmpty() || this.getPresentationStyle() != null && this.getPresentationStyle() == PresentationStyleEnum.BLOCKER)) {
            this.setPresentationStyle(PresentationStyleEnum.BLOCKER);
        }
        if (oldPresentationStyle != this.getPresentationStyle()) {
            elementChanges.addChange("presentationStyle", (Object)this.getPresentationStyle());
        }
        return formFieldHints;
    }

    @Override
    @JsonIgnore
    public List<ModelBinding> getAllBingings() {
        ArrayList<ModelBinding> allBindings = new ArrayList<ModelBinding>();
        allBindings.add(this.getModelBinding());
        allBindings.add(this.getLabelModelBinding());
        allBindings.add(this.getModelBinding());
        return allBindings;
    }

    private void changeSelectedItemBinding() {
        if (this.getModelBinding() != null) {
            this.getModelBinding().setValue(this.selectedItem);
        }
    }

    private void processFiltering(String text) {
        this.filteredObjectValues.clear();
        this.filteredObjectValues.addAll(this.values);
        this.highlightedObjectValue = this.values.stream().filter(d -> this.filterFunction.test(d, text)).findAny().orElse(null);
        this.filterInvoked = true;
    }

    @Override
    public ElementChanges updateView() {
        ElementChanges elementChanges = super.updateView();
        boolean selectedBindingChanged = elementChanges.getChangedAttributes().containsKey("rawValue");
        if (this.freeTypingBinding != null) {
            this.freeTyping = this.freeTypingBinding.resolveValueAndAddChanges((FormElement)this, elementChanges, this.freeTyping, FREE_TYPING);
        }
        this.setFilterFunction();
        this.refreshAvailability(elementChanges);
        boolean valuesChanged = this.processValuesBinding();
        if (selectedBindingChanged || valuesChanged) {
            this.processFiltering(this.filterText);
        }
        this.processFilterBinding(elementChanges, valuesChanged);
        this.processLabelBinding(elementChanges);
        this.prepareComponentAfterValidation(elementChanges);
        if (elementChanges.containsAnyChanges()) {
            this.refreshView();
        }
        if (this.fireOnchange) {
            elementChanges.addChange(FIRE_CHANGE_ACTION, (Object)true);
            this.fireOnchange = false;
        }
        return elementChanges;
    }

    protected void setFilterFunction() {
        this.filterFunction = (model, value) -> {
            if (StringUtils.isNullOrEmpty((String)value)) {
                return false;
            }
            return this.objectToString(model).toLowerCase().startsWith(value.toLowerCase());
        };
    }

    protected boolean processValuesBinding() {
        BindingResult valuesBindingResult;
        boolean valuesChanged = false;
        if (this.valuesBinding != null && (valuesBindingResult = this.valuesBinding.getBindingResult()) != null) {
            Object value = valuesBindingResult.getValue();
            if (value instanceof String) {
                List newValues;
                String valuesAsString = (String)value;
                String[] allValues = valuesAsString.split("\\|");
                if (allValues.length > 0 && !Objects.equals(newValues = Arrays.stream(allValues).collect(Collectors.toList()), this.values)) {
                    this.values.clear();
                    this.values.addAll(newValues);
                    return true;
                }
            } else if (value instanceof List && !Objects.equals(value, this.values)) {
                List collection = (List)value;
                this.values.clear();
                this.values.addAll(new LinkedList(collection));
                return true;
            }
        }
        return valuesChanged;
    }

    private boolean processFilterBinding(ElementChanges elementChanges, boolean valuesChanged) {
        if (!this.preload && this.firstLoad && StringUtils.isNullOrEmpty((String)this.filterText) && !valuesChanged) {
            return false;
        }
        boolean result = false;
        if (valuesChanged) {
            this.filteredValues = this.collectValues(this.filteredObjectValues);
            elementChanges.addChange(FILTERED_VALUES, this.filteredValues);
            result = true;
        }
        if (this.filterInvoked) {
            this.highlightedValue = this.collectValue(this.highlightedObjectValue);
            elementChanges.addChange(HIGHLIGHTED_VALUE, (Object)this.highlightedValue);
            this.filterInvoked = false;
            result = true;
        }
        return result;
    }

    @Override
    protected boolean processValueBinding(ElementChanges elementChanges) {
        Object value;
        BindingResult selectedBindingResult;
        if (this.getModelBinding() != null && (selectedBindingResult = this.getModelBinding().getBindingResult()) != null && !Objects.equals(value = selectedBindingResult.getValue(), this.selectedItem)) {
            this.selectedItem = value;
            this.rawValue = this.toRawValue(value);
            elementChanges.addChange("rawValue", (Object)this.rawValue);
            this.filterText = this.rawValue != null ? this.rawValue : "";
            return true;
        }
        return false;
    }

    private List<SelectComboItemDTO> collectValues(List<Object> valuesToConvert) {
        LinkedList<SelectComboItemDTO> filteredConvertedValues = new LinkedList<SelectComboItemDTO>();
        AtomicReference<Long> idx = new AtomicReference<Long>(0L);
        valuesToConvert.forEach(value -> {
            SelectComboItemDTO item;
            if (value instanceof IComboItem) {
                item = new SelectComboItemDTO((IComboItem)value);
                item.targetId = (Long)idx.get();
            } else {
                item = new SelectComboItemDTO(this.objectToString(value), (Long)idx.get());
            }
            idx.getAndSet((Long)idx.get() + 1L);
            filteredConvertedValues.add(item);
        });
        return filteredConvertedValues;
    }

    private SelectComboItemDTO collectValue(Object value) {
        SelectComboItemDTO item;
        if (value == null) {
            if (this.emptyLabel) {
                return new SelectComboItemDTO(this.emptyLabelText, -1L);
            }
            return null;
        }
        AtomicReference<Long> idx = new AtomicReference<Long>(0L);
        if (value instanceof IComboItem) {
            item = new SelectComboItemDTO((IComboItem)value);
            item.targetId = idx.get();
        } else {
            item = new SelectComboItemDTO(this.objectToString(value), idx.get());
        }
        idx.getAndSet(idx.get() + 1L);
        return item;
    }

    private String toRawValue(Object s) {
        if (s instanceof List) {
            return JsonUtil.writeValue(((List)s).stream().map(this::toRawElementValue).collect(Collectors.toList()));
        }
        return this.toRawElementValue(s);
    }

    private String toRawElementValue(Object s) {
        if (s instanceof IComboItem) {
            return ((IComboItem)s).getTargetValue();
        }
        return this.objectToString(s);
    }

    private String objectToString(Object s) {
        Optional<String> formatter = this.getOptionalFormatter();
        if (formatter.isPresent()) {
            return this.convertValueToString(s, formatter.get());
        }
        if (this.displayFunctionBinding != null) {
            return this.objectToStringAsDisplayFunction(s);
        }
        if (this.displayExpression != null) {
            return this.objectToStringAsDisplayExpresssion(s);
        }
        return this.convertValueToString(s, "");
    }

    @Override
    protected String convertToRaw(BindingResult<?> bindingResult) {
        Object value;
        Object object = value = bindingResult == null ? null : bindingResult.getValue();
        if (value == null) {
            return "";
        }
        return this.toRawValue(value);
    }

    private String objectToStringAsDisplayExpresssion(Object item) {
        if (item instanceof String) {
            return (String)item;
        }
        if (this.displayExpressionFunction == null) {
            Expression exp = SpelUtils.parseExpression((String)this.displayExpression);
            this.displayExpressionFunction = obj -> this.convertValueToString(SpelUtils.evaluateExpression((Expression)exp, (Object)obj));
        }
        return this.displayExpressionFunction.apply(item);
    }

    private String objectToStringAsDisplayFunction(Object s) {
        BindingResult bindingResult = this.displayFunctionBinding.getBindingResult();
        if (bindingResult == null) {
            throw new FhBindingException("No binding function for " + this.displayFunctionBinding.getBindingExpression());
        }
        Function function = (Function)bindingResult.getValue();
        if (function == null) {
            throw new FhBindingException("No binding function for " + this.displayFunctionBinding.getBindingExpression());
        }
        return (String)function.apply(s);
    }

    public Optional<String> getOptionalFormatter() {
        return Optional.ofNullable(this.formatter);
    }

    public void setFormatter(String formatter) {
        this.formatter = formatter;
    }

    @Override
    public SelectComboMenu createNewSameComponent() {
        return new SelectComboMenu(this.getForm());
    }

    @Override
    public void doCopy(Table table, Map<String, String> iteratorReplacements, BaseInputField baseClone) {
        super.doCopy(table, iteratorReplacements, baseClone);
        SelectComboMenu clone = (SelectComboMenu)baseClone;
        clone.setOnInput(table.getRowBinding(this.getOnInput(), (Component)clone, iteratorReplacements));
        clone.setOnEmptyValue(table.getRowBinding(this.getOnEmptyValue(), (Component)clone, iteratorReplacements));
        clone.setOnSpecialKey(table.getRowBinding(this.getOnSpecialKey(), (Component)clone, iteratorReplacements));
        clone.setOnDblSpecialKey(table.getRowBinding(this.getOnDblSpecialKey(), (Component)clone, iteratorReplacements));
        clone.setValuesBinding(table.getRowBinding(this.getValuesBinding(), (Component)clone, iteratorReplacements));
        clone.setFilterFunctionBinding(table.getRowBinding(this.getFilterFunctionBinding(), (Component)clone, iteratorReplacements));
        clone.setDisplayFunctionBinding(table.getRowBinding(this.getDisplayFunctionBinding(), (Component)clone, iteratorReplacements));
        clone.setDisplayExpression(this.getDisplayExpression());
        clone.setPreload(this.isPreload());
        clone.setFormatter(this.getFormatter());
        clone.setEmptyLabel(this.isEmptyLabel());
        clone.setEmptyLabelText(this.getEmptyLabelText());
        clone.setFreeTypingBinding((ModelBinding<Boolean>)table.getRowBinding(this.getFreeTypingBinding(), (Component)clone, iteratorReplacements));
    }

    public void setOnInput(ActionBinding onInput) {
        this.onInput = onInput;
    }

    public IActionCallbackContext setOnInput(IActionCallback onInput) {
        return CallbackActionBinding.createAndSet((IActionCallback)onInput, this::setOnInput);
    }

    public void setOnEmptyValue(ActionBinding onEmptyValue) {
        this.onEmptyValue = onEmptyValue;
    }

    public IActionCallbackContext setOnEmptyValue(IActionCallback onEmptyValue) {
        return CallbackActionBinding.createAndSet((IActionCallback)onEmptyValue, this::setOnEmptyValue);
    }

    public void setOnSpecialKey(ActionBinding onSpecialKey) {
        this.onSpecialKey = onSpecialKey;
    }

    public void setOnDblSpecialKey(ActionBinding onDblSpecialKey) {
        this.onDblSpecialKey = onDblSpecialKey;
    }

    public IActionCallbackContext setOnSpecialKey(IActionCallback onSpecialKey) {
        return CallbackActionBinding.createAndSet((IActionCallback)onSpecialKey, this::setOnSpecialKey);
    }

    public boolean isEmptyLabel() {
        return this.emptyLabel;
    }

    public void setEmptyLabel(boolean emptyLabel) {
        this.emptyLabel = emptyLabel;
    }

    public String getEmptyLabelText() {
        return this.emptyLabelText;
    }

    public void setEmptyLabelText(String emptyLabelText) {
        this.emptyLabelText = emptyLabelText;
    }

    public ActionBinding getOnInput() {
        return this.onInput;
    }

    public ActionBinding getOnEmptyValue() {
        return this.onEmptyValue;
    }

    public ActionBinding getOnSpecialKey() {
        return this.onSpecialKey;
    }

    public ActionBinding getOnDblSpecialKey() {
        return this.onDblSpecialKey;
    }

    @Override
    public String getRawValue() {
        return this.rawValue;
    }

    public List<SelectComboItemDTO> getFilteredValues() {
        return this.filteredValues;
    }

    public SelectComboItemDTO getHighlightedValue() {
        return this.highlightedValue;
    }

    public ModelBinding getValuesBinding() {
        return this.valuesBinding;
    }

    public void setValuesBinding(ModelBinding valuesBinding) {
        this.valuesBinding = valuesBinding;
    }

    public ModelBinding getFilterFunctionBinding() {
        return this.filterFunctionBinding;
    }

    public void setFilterFunctionBinding(ModelBinding filterFunctionBinding) {
        this.filterFunctionBinding = filterFunctionBinding;
    }

    public boolean isPreload() {
        return this.preload;
    }

    public void setPreload(boolean preload) {
        this.preload = preload;
    }

    public String getFormatter() {
        return this.formatter;
    }

    public boolean isFreeTyping() {
        return this.freeTyping;
    }

    public ModelBinding<Boolean> getFreeTypingBinding() {
        return this.freeTypingBinding;
    }

    public void setFreeTypingBinding(ModelBinding<Boolean> freeTypingBinding) {
        this.freeTypingBinding = freeTypingBinding;
    }

    public ModelBinding getDisplayFunctionBinding() {
        return this.displayFunctionBinding;
    }

    public void setDisplayFunctionBinding(ModelBinding displayFunctionBinding) {
        this.displayFunctionBinding = displayFunctionBinding;
    }

    public String getDisplayExpression() {
        return this.displayExpression;
    }

    public void setDisplayExpression(String displayExpression) {
        this.displayExpression = displayExpression;
    }

    public Function<Object, String> getDisplayExpressionFunction() {
        return this.displayExpressionFunction;
    }

    public void setDisplayExpressionFunction(Function<Object, String> displayExpressionFunction) {
        this.displayExpressionFunction = displayExpressionFunction;
    }

    protected static class SelectComboItemDTO {
        private boolean displayAsTarget;
        private String targetValue;
        private String displayedValue;
        private Long targetId;

        public SelectComboItemDTO(String targetValue, Long targetId) {
            this.displayAsTarget = true;
            this.targetValue = targetValue;
            this.targetId = targetId;
        }

        public SelectComboItemDTO(IComboItem comboItem) {
            this.displayAsTarget = false;
            this.targetValue = comboItem.getTargetValue();
            this.targetId = comboItem.getTargetId();
            this.displayedValue = comboItem.getDisplayedValue();
        }

        public boolean isDisplayAsTarget() {
            return this.displayAsTarget;
        }

        public String getTargetValue() {
            return this.targetValue;
        }

        public String getDisplayedValue() {
            return this.displayedValue;
        }

        public Long getTargetId() {
            return this.targetId;
        }
    }
}

