/*
 * Decompiled with CFR 0.152.
 */
package pl.fhframework.model.forms;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import pl.fhframework.BindingResult;
import pl.fhframework.annotations.Control;
import pl.fhframework.annotations.DesignerXMLProperty;
import pl.fhframework.annotations.DocumentedComponent;
import pl.fhframework.annotations.DocumentedComponentAttribute;
import pl.fhframework.annotations.RepeaterTraversable;
import pl.fhframework.annotations.XMLProperty;
import pl.fhframework.binding.ActionBinding;
import pl.fhframework.binding.CallbackActionBinding;
import pl.fhframework.binding.IActionCallback;
import pl.fhframework.binding.IActionCallbackContext;
import pl.fhframework.binding.ModelBinding;
import pl.fhframework.binding.StaticBinding;
import pl.fhframework.core.FhException;
import pl.fhframework.model.dto.InMessageEventData;
import pl.fhframework.model.dto.ValueChange;
import pl.fhframework.model.forms.CompactLayout;
import pl.fhframework.model.forms.Form;
import pl.fhframework.model.forms.Group;
import pl.fhframework.model.forms.GroupingComponent;
import pl.fhframework.model.forms.IChangeableByClient;
import pl.fhframework.model.forms.IGroupingComponent;
import pl.fhframework.model.forms.OptionsListElement;
import pl.fhframework.model.forms.PanelGroup;
import pl.fhframework.model.forms.Repeater;
import pl.fhframework.model.forms.Table;
import pl.fhframework.model.forms.designer.OptionsListDesignerPreviewProvider;
import pl.fhframework.model.forms.model.OptionsListElementModel;

@Control(parents={Form.class, PanelGroup.class, Repeater.class, Group.class}, invalidParents={Table.class})
@DocumentedComponent(value="One column list of options to be selected. ", icon="fa fa-list-ul")
public class OptionsList
extends GroupingComponent<OptionsListElement>
implements IChangeableByClient,
CompactLayout {
    private static final String ON_ICON_CLICK_ATTR = "onIconClick";
    private static final String ATTR_TITLE = "title";
    private static final String ON_CHANGE_ATTR = "onChange";
    private static final String ATTR_EMPTY_VALUE_LABEL = "emptyValueLabel";
    @XMLProperty(value="values")
    @DesignerXMLProperty(commonUse=true, previewValueProvider=OptionsListDesignerPreviewProvider.class)
    @DocumentedComponentAttribute(value="Collection of elements displayed on the list", type=String.class, boundable=true)
    @JsonIgnore
    private ModelBinding valuesBinding = null;
    private Map<String, ModelElementWrapper> valuesCollection = null;
    @JsonIgnore
    @RepeaterTraversable
    @XMLProperty(value="title")
    @DocumentedComponentAttribute(value="List title displayed as the first element of the list", type=String.class, boundable=true)
    private ModelBinding titleBinding = null;
    private LinkedList<ModelElementWrapper> bindingCollection = null;
    @JsonProperty(value="title")
    private OptionsListElement titleLabel = null;
    @XMLProperty
    @DocumentedComponentAttribute(defaultValue="false", value="Defines if it possible to define empty element on the list")
    private boolean emptyValue;
    @JsonIgnore
    @RepeaterTraversable
    @XMLProperty(value="emptyValueLabel")
    @DocumentedComponentAttribute(value="Label of empty value", type=String.class, boundable=true)
    private ModelBinding emptyValueBinding = null;
    @JsonProperty(value="displayCheckbox")
    private boolean displayCheckbox = true;
    @XMLProperty
    @DocumentedComponentAttribute(value="Name of action which will be invoked after clicking on icon of element.")
    private ActionBinding onIconClick;
    @XMLProperty
    @DocumentedComponentAttribute(value="Name of action which will be invoked after clicking on element checkbox.")
    private ActionBinding onChange;

    public OptionsList(Form form) {
        super(form);
    }

    public void init() {
        StaticBinding staticBinding;
        String values;
        BindingResult bindingResult;
        super.init();
        if (this.titleBinding != null && (bindingResult = this.titleBinding.getBindingResult()) != null) {
            this.titleLabel = new OptionsListElement(this.getForm());
            this.titleLabel.setGroupingParentComponent((IGroupingComponent)this);
            this.titleLabel.setTitle(true);
            this.titleLabel.setValue(this.titleBinding.getBindingResult().getValue());
            this.titleLabel.setIcon("");
            this.titleLabel.init();
        }
        if (this.valuesBinding != null && this.valuesBinding instanceof StaticBinding && (values = (String)(staticBinding = (StaticBinding)this.valuesBinding).getStaticValue()) != null && !OptionsList.isBinding(values) && values.indexOf("|") > 0) {
            ArrayList<String> valuesList = new ArrayList<String>(Arrays.asList(values.split("\\|")));
            if (this.emptyValue) {
                BindingResult bindingResult2;
                String result = "";
                if (this.emptyValueBinding != null && (bindingResult2 = this.emptyValueBinding.getBindingResult()) != null) {
                    result = (String)this.emptyValueBinding.getBindingResult().getValue();
                }
                valuesList.add(0, result);
            }
            this.valuesCollection = Arrays.stream(valuesList.toArray(new String[0])).collect(Collectors.toMap(k -> k, this::createWrappedElement, (v1, v2) -> v1, LinkedHashMap::new));
            this.getSubcomponents().clear();
            this.valuesCollection.values().forEach(c -> this.getSubcomponents().add(c.getModelElementAsFormElement()));
        }
    }

    public void processComponents() {
        BindingResult titleResult;
        if (this.titleBinding != null && (titleResult = this.titleBinding.getBindingResult()) != null && titleResult.getValue() != null) {
            if (this.titleLabel != null) {
                if (!Objects.equals(this.titleLabel.getValue(), this.titleBinding.getBindingResult().getValue())) {
                    this.titleLabel.setValue(titleResult.getValue());
                }
            } else {
                this.titleLabel = new OptionsListElement(this.getForm());
                this.titleLabel.setGroupingParentComponent((IGroupingComponent)this);
                this.titleLabel.setTitle(true);
                this.titleLabel.setValue(this.titleBinding.getBindingResult().getValue());
                this.titleLabel.init();
            }
        }
        if (this.valuesBinding != null) {
            BindingResult valuesBindingResult = this.valuesBinding.getBindingResult();
            OptionsList.checkNotNull(this.valuesBinding.getBindingExpression(), valuesBindingResult);
            OptionsList.checkNotNull(this.valuesBinding.getBindingExpression(), valuesBindingResult.getValue());
            if (valuesBindingResult.getValue() != null && valuesBindingResult.getValue() instanceof List) {
                BindingResult bindingResult;
                List newCollection = (List)valuesBindingResult.getValue();
                LinkedList<ModelElementWrapper> oldCollection = this.bindingCollection;
                String result = "";
                if (this.emptyValueBinding != null && (bindingResult = this.emptyValueBinding.getBindingResult()) != null) {
                    result = (String)this.emptyValueBinding.getBindingResult().getValue();
                }
                OptionsListElementModel emptyElementModel = new OptionsListElementModel(-1, result);
                if (this.emptyValue && !newCollection.contains(emptyElementModel)) {
                    newCollection.add(0, emptyElementModel);
                }
                if (oldCollection != null) {
                    Iterator oldCollectionIterator = oldCollection.iterator();
                    while (oldCollectionIterator.hasNext()) {
                        ModelElementWrapper oldElement = (ModelElementWrapper)oldCollectionIterator.next();
                        boolean isInNewCollection = false;
                        for (OptionsListElementModel newElement : newCollection) {
                            if (!newElement.getId().equals(oldElement.getModelElementReference().getId())) continue;
                            isInNewCollection = true;
                            break;
                        }
                        if (isInNewCollection) continue;
                        oldCollectionIterator.remove();
                    }
                    int previousFoundIdx = -1;
                    for (OptionsListElementModel newElement : newCollection) {
                        boolean isInOldCollection = false;
                        for (int idx = 0; idx < oldCollection.size(); ++idx) {
                            ModelElementWrapper oldElement = (ModelElementWrapper)oldCollection.get(idx);
                            if (!newElement.getId().equals(oldElement.getModelElementReference().getId())) continue;
                            isInOldCollection = true;
                            previousFoundIdx = idx;
                            break;
                        }
                        if (isInOldCollection) continue;
                        if (previousFoundIdx + 1 > oldCollection.size()) {
                            oldCollection.add(this.createWrappedElement(newElement));
                        } else {
                            oldCollection.add(previousFoundIdx + 1, this.createWrappedElement(newElement));
                        }
                        ++previousFoundIdx;
                    }
                } else {
                    this.bindingCollection = new LinkedList();
                    for (OptionsListElementModel listElementModel : newCollection) {
                        this.bindingCollection.add(this.createWrappedElement(listElementModel));
                    }
                }
            }
        } else if (this.valuesCollection != null) {
            this.getSubcomponents().clear();
            this.valuesCollection.values().forEach(c -> this.getSubcomponents().add(c.getModelElementAsFormElement()));
        }
    }

    private static void checkNotNull(String cause, Object value) {
        if (Objects.isNull(value)) {
            throw new FhException(cause + " referenced from view is null or not found");
        }
    }

    public List<OptionsListElement> getSubcomponents() {
        if (this.bindingCollection != null) {
            LinkedList returnedCollection = this.bindingCollection.stream().map(ModelElementWrapper::getModelElementAsFormElement).collect(Collectors.toCollection(LinkedList::new));
            if (!this.getForm().getViewMode().equals((Object)Form.ViewMode.DESIGN) && this.titleLabel != null) {
                returnedCollection.addFirst(this.titleLabel);
            }
            return returnedCollection;
        }
        return super.getSubcomponents();
    }

    public void updateModel(ValueChange valueChange) {
        if (valueChange.getMainValue() != null) {
            List changedElementState = valueChange.getMapListAttribute("value");
            for (Object element : changedElementState) {
                Map elementMap = (Map)element;
                String id = null;
                String value = null;
                for (Object sendedElement : elementMap.keySet()) {
                    if (Objects.equals("id", sendedElement)) {
                        id = elementMap.get(sendedElement).toString();
                        continue;
                    }
                    if (!Objects.equals("value", sendedElement)) continue;
                    value = elementMap.get(sendedElement).toString();
                }
                if (this.bindingCollection == null) continue;
                for (ModelElementWrapper modelWrapperElement : this.bindingCollection) {
                    if (!Objects.equals(modelWrapperElement.getModelElementAsFormElement().getId(), id)) continue;
                    modelWrapperElement.getModelElementReference().setChecked(Boolean.valueOf(value));
                }
            }
        }
    }

    public String getType() {
        return "OptionsList";
    }

    private ModelElementWrapper createWrappedElement(String value) {
        OptionsListElementModel listElementModel = new OptionsListElementModel();
        listElementModel.setValue(value);
        return this.createWrappedElement(listElementModel);
    }

    private ModelElementWrapper createWrappedElement(OptionsListElementModel listElement) {
        OptionsListElement label = new OptionsListElement(this.getForm());
        label.setGroupingParentComponent((IGroupingComponent)this);
        label.setValue(listElement.getValue());
        label.setChecked(listElement.isChecked());
        label.setIcon(listElement.getIcon());
        label.init();
        ModelElementWrapper modelElementWrapper = new ModelElementWrapper();
        modelElementWrapper.setModelElementAsFormElement(label);
        modelElementWrapper.setModelElementReference(listElement);
        return modelElementWrapper;
    }

    private static boolean isBinding(String expr) {
        return expr.contains("{") && expr.contains("}");
    }

    public OptionsListElement getTitle() {
        return this.titleLabel;
    }

    public Optional<ActionBinding> getEventHandler(InMessageEventData eventData) {
        if (ON_ICON_CLICK_ATTR.equals(eventData.getEventType())) {
            return Optional.ofNullable(this.onIconClick);
        }
        if (ON_CHANGE_ATTR.equals(eventData.getEventType())) {
            return Optional.ofNullable(this.onChange);
        }
        return super.getEventHandler(eventData);
    }

    public void setOnIconClick(ActionBinding onIconClick) {
        this.onIconClick = onIconClick;
    }

    public IActionCallbackContext setOnIconClick(IActionCallback onIconClick) {
        return CallbackActionBinding.createAndSet((IActionCallback)onIconClick, this::setOnIconClick);
    }

    public void setOnChange(ActionBinding onChange) {
        this.onChange = onChange;
    }

    public IActionCallbackContext setOnChange(IActionCallback onChange) {
        return CallbackActionBinding.createAndSet((IActionCallback)onChange, this::setOnChange);
    }

    public ModelBinding getValuesBinding() {
        return this.valuesBinding;
    }

    public void setValuesBinding(ModelBinding valuesBinding) {
        this.valuesBinding = valuesBinding;
    }

    public ModelBinding getTitleBinding() {
        return this.titleBinding;
    }

    public void setTitleBinding(ModelBinding titleBinding) {
        this.titleBinding = titleBinding;
    }

    public boolean isEmptyValue() {
        return this.emptyValue;
    }

    public void setEmptyValue(boolean emptyValue) {
        this.emptyValue = emptyValue;
    }

    public ModelBinding getEmptyValueBinding() {
        return this.emptyValueBinding;
    }

    public void setEmptyValueBinding(ModelBinding emptyValueBinding) {
        this.emptyValueBinding = emptyValueBinding;
    }

    public ActionBinding getOnIconClick() {
        return this.onIconClick;
    }

    public ActionBinding getOnChange() {
        return this.onChange;
    }

    private class ModelElementWrapper {
        private OptionsListElement modelElementAsFormElement;
        private OptionsListElementModel modelElementReference;

        private ModelElementWrapper() {
        }

        public boolean equals(Object obj) {
            return obj instanceof ModelElementWrapper && this.modelElementReference.equals(obj);
        }

        public int hashCode() {
            return this.modelElementReference.hashCode();
        }

        public OptionsListElement getModelElementAsFormElement() {
            return this.modelElementAsFormElement;
        }

        public OptionsListElementModel getModelElementReference() {
            return this.modelElementReference;
        }

        public void setModelElementAsFormElement(OptionsListElement modelElementAsFormElement) {
            this.modelElementAsFormElement = modelElementAsFormElement;
        }

        public void setModelElementReference(OptionsListElementModel modelElementReference) {
            this.modelElementReference = modelElementReference;
        }
    }
}

