/*
 * Decompiled with CFR 0.152.
 */
package pl.fhframework.model.forms;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Optional;
import pl.fhframework.core.forms.IterationContext;
import pl.fhframework.core.logging.FhLogger;
import pl.fhframework.core.util.ComponentsUtils;
import pl.fhframework.model.forms.Component;
import pl.fhframework.model.forms.Form;
import pl.fhframework.model.forms.FormElement;
import pl.fhframework.model.forms.IGroupingComponent;
import pl.fhframework.model.forms.Repeater;

public class BaseComponentUtils {
    public static FormElement find(FormElement component, String id) {
        return ComponentsUtils.find((FormElement)component, (String)id);
    }

    public static Optional<Form<?>> findForm(FormElement component) {
        IGroupingComponent group = component.getGroupingParentComponent();
        while (group != null) {
            if (group instanceof Form) {
                return Optional.of((Form)group);
            }
            group = ((FormElement)group).getGroupingParentComponent();
        }
        return Optional.empty();
    }

    public static Optional<Integer> getIterationIndex(Component element) {
        Optional<IterationContext> ctx = BaseComponentUtils.getIterationContext(element);
        if (ctx.isPresent()) {
            return Optional.of(ctx.get().getIndex());
        }
        return Optional.empty();
    }

    public static Optional<IterationContext> getIterationContext(Component element) {
        IGroupingComponent c = null;
        if (element instanceof IGroupingComponent) {
            c = (IGroupingComponent)element;
        } else {
            if (element.getGroupingParentComponent() == null) {
                return Optional.empty();
            }
            c = element.getGroupingParentComponent();
        }
        while (c != null) {
            if (c instanceof Repeater) {
                if (((Repeater)c).getBindedSubcomponents() != null) {
                    IterationContext currentContext = null;
                    for (IterationContext ctx : ((Repeater)c).getBindedSubcomponents()) {
                        if (!(ctx.getComponent() instanceof FormElement) || ComponentsUtils.find((FormElement)((FormElement)ctx.getComponent()), (String)element.getId()) == null) continue;
                        currentContext = ctx;
                    }
                    if (currentContext != null) {
                        return Optional.of(currentContext);
                    }
                } else {
                    return Optional.empty();
                }
            }
            c = ((FormElement)c).getGroupingParentComponent();
        }
        return Optional.empty();
    }

    public static void invokeMethod(Object target, Method m, Object params) {
        try {
            m.invoke(target, params);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            FhLogger.error((Throwable)e);
        }
    }
}

