/*
 * Decompiled with CFR 0.152.
 */
package pl.fhframework.model.forms.formatters;

import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.util.Locale;
import org.springframework.util.StringUtils;
import pl.fhframework.format.AutoRegisteredFormatter;
import pl.fhframework.format.FhFormatter;

@FhFormatter(value="IntegerFormatter")
public class IntegerFormatter
extends AutoRegisteredFormatter<Integer> {
    private static ThreadLocal<DecimalFormat> customFormat = ThreadLocal.withInitial(() -> new DecimalFormat(){
        {
            DecimalFormatSymbols pSymbols = this.getDecimalFormatSymbols();
            pSymbols.setDecimalSeparator(',');
            pSymbols.setGroupingSeparator(' ');
            this.setDecimalFormatSymbols(pSymbols);
            this.setGroupingUsed(false);
            this.setParseBigDecimal(true);
            this.setMinimumFractionDigits(0);
            this.setMaximumFractionDigits(2);
            this.setRoundingMode(RoundingMode.HALF_UP);
        }
    });

    public Integer parse(String s, Locale locale) throws ParseException {
        if (!StringUtils.isEmpty((Object)s)) {
            String[] a = s.split("\\.");
            s = a[0];
        }
        return Integer.parseInt(s);
    }

    public String print(Integer value, Locale locale) {
        String pRetVal = "";
        if (value != null) {
            pRetVal = value.toString();
        }
        return pRetVal;
    }
}

