/*
 * Decompiled with CFR 0.152.
 */
package pl.fhframework.model.forms.messages;

import java.util.function.Consumer;
import pl.fhframework.core.messages.Action;
import pl.fhframework.events.ViewEvent;
import pl.fhframework.model.forms.messages.Messages;

public class ActionButton {
    private Properties actionButtonProperties = null;

    private ActionButton(Properties actionButtonProperties) {
        this.actionButtonProperties = actionButtonProperties;
    }

    public String getButtonLabel() {
        return this.actionButtonProperties.buttonLabel;
    }

    public String getButtonId() {
        return this.actionButtonProperties.buttonId;
    }

    public Action getAction() {
        return this.actionButtonProperties.action;
    }

    public Consumer<? super ViewEvent> getViewEventAction() {
        return this.actionButtonProperties.viewEventAction;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ActionButton get(String buttonLabel, Action action) {
        return ActionButton.builder().withAction(action).withButtonLabel(buttonLabel).build();
    }

    public static ActionButton get(String buttonLabel, Consumer<? super ViewEvent> viewEventAction) {
        return ActionButton.builder().withViewEventAction(viewEventAction).withButtonLabel(buttonLabel).build();
    }

    public static ActionButton getClose(String buttonLabel) {
        return ActionButton.builder().withButtonLabel(buttonLabel).withViewEventAction(Messages::close).build();
    }

    public static class Builder {
        private Properties properties = new Properties();

        public Builder withButtonId(String buttonId) {
            this.properties.buttonId = buttonId;
            return this;
        }

        public Builder withButtonLabel(String buttonLabel) {
            this.properties.buttonLabel = buttonLabel;
            return this;
        }

        public Builder withAction(Action action) {
            this.properties.action = action;
            return this;
        }

        public Builder withViewEventAction(Consumer<? super ViewEvent> viewEventAction) {
            this.properties.viewEventAction = viewEventAction;
            return this;
        }

        public ActionButton build() {
            return new ActionButton(this.properties);
        }
    }

    private static class Properties {
        private String buttonLabel;
        private String buttonId;
        private Action action;
        private Consumer<? super ViewEvent> viewEventAction;

        private Properties() {
        }
    }
}

