/*
 * Decompiled with CFR 0.152.
 */
package pl.fhframework.model.forms;

import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.stereotype.Service;
import pl.fhframework.model.forms.Column;
import pl.fhframework.model.forms.CompactLayout;
import pl.fhframework.model.forms.Component;
import pl.fhframework.model.forms.Form;
import pl.fhframework.model.forms.FormElement;
import pl.fhframework.model.forms.IGroupingComponent;
import pl.fhframework.model.forms.Invisible;
import pl.fhframework.model.forms.Row;
import pl.fhframework.model.forms.Spacer;
import pl.fhframework.model.forms.SpacerService;
import pl.fhframework.model.forms.Table;
import pl.fhframework.model.forms.VirtualGrid;

@Service
public class SpacerServiceImpl
implements SpacerService {
    private static final Pattern sizePattern = Pattern.compile("md-\\d+");
    private static final String DEFAULT_SIZE = "40px";

    public FormElement getSpacerTemplate(Form form) {
        return new Spacer(form);
    }

    public void fillEmptyForm(Form form) {
        for (int i = 0; i < 3; ++i) {
            form.getSubcomponents().add(new Row(form));
        }
    }

    public FormElement getSingleSpacerClone(FormElement spacerTemplate, IGroupingComponent groupingComponent, String sizeClass, int size) {
        FormElement cloneSpacer = (FormElement)spacerTemplate.clone().get();
        cloneSpacer.setWidth(sizeClass + size);
        cloneSpacer.setHeight(DEFAULT_SIZE);
        cloneSpacer.setGroupingParentComponent(groupingComponent);
        cloneSpacer.init();
        return cloneSpacer;
    }

    public Integer getSize(FormElement formElement) {
        if (formElement.getWidth() != null) {
            Matcher matcher = sizePattern.matcher(formElement.getWidth());
            if (matcher.find()) {
                return Integer.valueOf(matcher.group().substring(3));
            }
            return 12;
        }
        if (formElement instanceof IGroupingComponent) {
            return 12;
        }
        return 2;
    }

    public Integer getSize(String size) {
        Matcher matcher = sizePattern.matcher(size);
        if (matcher.find()) {
            return Integer.valueOf(matcher.group().substring(3));
        }
        return 12;
    }

    public void replaceComponentWithSpacers(Form form, FormElement spacerTemplate, IGroupingComponent groupingParentFormElement, Component movedComponent, Integer index, boolean isAdded, boolean updateParent, String sizeClass) {
        IGroupingComponent originalParent = this.getParentComponent(movedComponent, form);
        if (isAdded) {
            if (groupingParentFormElement instanceof Table) {
                ((Table)groupingParentFormElement).getColumns().add((Column)movedComponent);
            } else {
                groupingParentFormElement.getSubcomponents().add(index, movedComponent);
            }
        } else {
            int indexOfElement = originalParent.getSubcomponents().indexOf(movedComponent);
            originalParent.getSubcomponents().remove(indexOfElement);
            groupingParentFormElement.getSubcomponents().add(index, movedComponent);
        }
    }

    private int getIndexOfFirstInLine(IGroupingComponent<Component> groupingComponent, int targetIndex) {
        int lineSize = 0;
        int firstInLine = 0;
        for (int index = 0; index < groupingComponent.getSubcomponents().size(); ++index) {
            Component component = (Component)groupingComponent.getSubcomponents().get(index);
            if (lineSize == 0) {
                firstInLine = index;
            }
            if (index >= targetIndex) {
                return firstInLine;
            }
            if ((lineSize += this.getSize((FormElement)component).intValue()) % 12 != 0) continue;
            lineSize = 0;
        }
        return firstInLine;
    }

    public IGroupingComponent getParentComponent(Component component, Form form) {
        if (component.getGroupingParentComponent() != null) {
            return component.getGroupingParentComponent();
        }
        return form;
    }

    public int getSpaceAvailableToAddNewElement(IGroupingComponent groupingParentFormElement, Optional<FormElement> componentToIgnore, Integer index) {
        VirtualGrid virtualGrid = new VirtualGrid(groupingParentFormElement, (SpacerService)this);
        virtualGrid.build();
        if (groupingParentFormElement instanceof CompactLayout) {
            return 0;
        }
        int counter = this.countComponentInline(groupingParentFormElement, index);
        return 12 - counter;
    }

    public boolean deleteDesignerRow(IGroupingComponent groupingComponent, int index) {
        int i;
        index = this.getIndexOfFirstInLine((IGroupingComponent<Component>)groupingComponent, index);
        for (i = 0; i < 12; ++i) {
            if (groupingComponent.getSubcomponents().get(index + i) instanceof Invisible) continue;
            return false;
        }
        for (i = 0; i < 12; ++i) {
            groupingComponent.getSubcomponents().remove(index);
        }
        return true;
    }

    public boolean isEnoughSpaceToAddNewElement(IGroupingComponent groupingParentFormElement, Optional<FormElement> componentToIgnore, Integer index, int componentSize) {
        if (groupingParentFormElement instanceof CompactLayout) {
            return true;
        }
        int counter = this.countComponentInline(groupingParentFormElement, index);
        if (counter == 12) {
            return true;
        }
        return componentSize <= 12 - counter;
    }

    private int countComponentInline(IGroupingComponent groupingParentFormElement, int index) {
        VirtualGrid virtualGrid = new VirtualGrid(groupingParentFormElement, (SpacerService)this);
        virtualGrid.build();
        if (groupingParentFormElement.getSubcomponents().isEmpty()) {
            return 0;
        }
        Component component = (Component)groupingParentFormElement.getSubcomponents().get(index);
        List lineOf = virtualGrid.getLineOf(component);
        int counter = 0;
        if (lineOf != null) {
            for (Object o : lineOf) {
                if (o instanceof FormElement) {
                    FormElement element = (FormElement)o;
                    counter += this.getSize(element).intValue();
                    continue;
                }
                if (!(o instanceof VirtualGrid)) continue;
                counter += this.getSize((FormElement)((VirtualGrid)o).getGroupingComponent()).intValue();
            }
        }
        return counter;
    }
}

