/*
 * Decompiled with CFR 0.152.
 */
package pl.fhframework.model.forms;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import pl.fhframework.BindingResult;
import pl.fhframework.ReflectionUtils;
import pl.fhframework.annotations.CompilationTraversable;
import pl.fhframework.annotations.Control;
import pl.fhframework.annotations.DocumentedComponent;
import pl.fhframework.annotations.XMLProperty;
import pl.fhframework.core.FhCL;
import pl.fhframework.core.FhException;
import pl.fhframework.core.logging.FhLogger;
import pl.fhframework.core.uc.Parameter;
import pl.fhframework.helper.AutowireHelper;
import pl.fhframework.model.dto.ElementChanges;
import pl.fhframework.model.forms.Column;
import pl.fhframework.model.forms.Combo;
import pl.fhframework.model.forms.ComponentStateSaver;
import pl.fhframework.model.forms.DictionaryComboParameter;
import pl.fhframework.model.forms.Form;
import pl.fhframework.model.forms.Group;
import pl.fhframework.model.forms.IGroupingComponent;
import pl.fhframework.model.forms.NonVisualFormElement;
import pl.fhframework.model.forms.PanelGroup;
import pl.fhframework.model.forms.Repeater;
import pl.fhframework.model.forms.Row;
import pl.fhframework.model.forms.Tab;
import pl.fhframework.model.forms.Table;
import pl.fhframework.model.forms.provider.IComboDataProvider;

@DocumentedComponent(value="Enables users to quickly find and select from a pre-populated list of values as they type, leveraging searching and filtering.", icon="fa fa-outdent")
@Control(parents={PanelGroup.class, Group.class, Column.class, Tab.class, Row.class, Form.class, Repeater.class}, invalidParents={Table.class}, canBeDesigned=false)
public class DictionaryCombo
extends Combo
implements IGroupingComponent<DictionaryComboParameter> {
    @XMLProperty
    private String provider;
    @JsonIgnore
    private IComboDataProvider dataProvider;
    @JsonIgnore
    private List<DictionaryComboParameter> subcomponents = new LinkedList<DictionaryComboParameter>();
    @JsonIgnore
    private ComponentStateSaver componentStateSaver = new ComponentStateSaver();
    @JsonIgnore
    private boolean processComponentChange = true;
    @JsonIgnore
    @CompilationTraversable
    private List<NonVisualFormElement> nonVisualSubcomponents = new ArrayList<NonVisualFormElement>();
    protected boolean multiselect = false;
    @JsonIgnore
    private Method getValues;
    @JsonIgnore
    private Method getValue;
    @JsonIgnore
    private List<DictionaryComboParameter> getValuesParamsList = new LinkedList<DictionaryComboParameter>();
    @JsonIgnore
    private List<DictionaryComboParameter> getValueParamsList = new LinkedList<DictionaryComboParameter>();

    public DictionaryCombo(Form form) {
        super(form);
    }

    @Override
    public void init() {
        super.init();
        try {
            this.resolveDataProvider();
            this.resolveMethods();
        }
        catch (Exception ex) {
            FhLogger.warn((String)"DictionaryCombo: Provider not found.", (Throwable)ex);
        }
    }

    @JsonIgnore
    public List<DictionaryComboParameter> getParameters() {
        return this.subcomponents;
    }

    private void resolveDataProvider() throws ClassNotFoundException {
        if (this.provider != null) {
            Class providerClass = FhCL.classLoader.loadClass(String.format(this.provider, new Object[0]));
            this.dataProvider = (IComboDataProvider)AutowireHelper.getBean((Class)providerClass);
        }
    }

    @Override
    protected boolean processValuesBinding() {
        boolean valuesChanged = false;
        if (this.values.isEmpty()) {
            valuesChanged = this.processValuesExternal(null);
        }
        return valuesChanged;
    }

    protected boolean processValuesExternal(String text) {
        LinkedList<Object> allParamsList = new LinkedList<Object>();
        allParamsList.add(text);
        allParamsList.addAll(this.getValuesFromDictionaryComboParameters(this.getValuesParamsList));
        List values = (List)ReflectionUtils.run((Method)this.getValues, (Object)this.dataProvider, (Object[])allParamsList.toArray());
        if (values != null) {
            List collection = values;
            if (!CollectionUtils.isEmpty((Collection)collection)) {
                this.modelType = collection.stream().findFirst().get().getClass();
            }
            this.values.put((Object)"", new LinkedList(collection));
            return true;
        }
        return false;
    }

    @Override
    protected void processFiltering(String text) {
        this.filteredObjectValues.clear();
        this.processValuesExternal(text);
        Map<String, List> filtered = this.values.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, p -> ((List)p.getValue()).stream().collect(Collectors.toList())));
        this.filteredObjectValues.putAll(filtered);
        this.filterInvoked = true;
    }

    private void resolveMethods() {
        if (this.provider != null) {
            this.getValues = (Method)ReflectionUtils.findMatchingPublicMethod(this.dataProvider.getClass(), (String)"getValues").get();
            LinkedList paramsList = new LinkedList();
            Integer paramsCount = this.getValues.getParameterCount();
            for (int idx = 0; idx < paramsCount; ++idx) {
                Optional p = ReflectionUtils.getMethodParamAnnotation((Executable)this.getValues, (int)idx, Parameter.class);
                if (!p.isPresent()) continue;
                String paramName = ((Parameter)p.get()).name();
                Optional<DictionaryComboParameter> optionalDictComboParam = this.subcomponents.stream().filter(e -> Objects.equals(e.getName(), paramName)).findFirst();
                if (optionalDictComboParam.isPresent()) {
                    DictionaryComboParameter dictComboParam = optionalDictComboParam.get();
                    this.getValuesParamsList.add(dictComboParam);
                    continue;
                }
                throw new FhException("No attribute for " + DictionaryComboParameter.class.getSimpleName() + " : " + paramName);
            }
            this.getValue = (Method)ReflectionUtils.findMatchingPublicMethod(this.dataProvider.getClass(), (String)"getValue").get();
            Integer paramsCount2 = this.getValue.getParameterCount();
            for (int idx = 0; idx < paramsCount2; ++idx) {
                Optional p = ReflectionUtils.getMethodParamAnnotation((Executable)this.getValue, (int)idx, Parameter.class);
                if (!p.isPresent()) continue;
                String paramName = ((Parameter)p.get()).name();
                Optional<DictionaryComboParameter> optionalDictComboParam = this.subcomponents.stream().filter(e -> Objects.equals(e.getName(), paramName)).findFirst();
                if (optionalDictComboParam.isPresent()) {
                    DictionaryComboParameter dictComboParam = optionalDictComboParam.get();
                    this.getValueParamsList.add(dictComboParam);
                    BindingResult bindingResult = dictComboParam.getModelBinding().getBindingResult();
                    continue;
                }
                throw new FhException("No attribute for " + DictionaryComboParameter.class.getSimpleName() + " : " + paramName);
            }
        }
    }

    public void addSubcomponent(DictionaryComboParameter component) {
        this.subcomponents.add(component);
    }

    public void removeSubcomponent(DictionaryComboParameter removedFormElement) {
        this.subcomponents.remove((Object)removedFormElement);
    }

    public List<DictionaryComboParameter> getSubcomponents() {
        return this.subcomponents;
    }

    @Override
    protected String objectToString(Object s) {
        if (s == null) {
            return "";
        }
        if (s.getClass().equals(String.class)) {
            return (String)s;
        }
        return this.dataProvider.getDisplayValue(s);
    }

    @Override
    protected void changeSelectedItemBinding() {
        if (this.getModelBinding() != null) {
            if (this.selectedItem == null) {
                this.getModelBinding().setValue(this.selectedItem);
            } else {
                this.getModelBinding().setValue(this.dataProvider.getCode(this.selectedItem));
            }
        }
    }

    @Override
    protected MultiValueMap<String, Combo.ComboItemDTO> collectValues(MultiValueMap<String, Object> valuesToConvert) {
        LinkedMultiValueMap filteredConvertedValues = new LinkedMultiValueMap();
        AtomicReference<Long> idx = new AtomicReference<Long>(0L);
        valuesToConvert.forEach((arg_0, arg_1) -> this.lambda$collectValues$4(idx, (MultiValueMap)filteredConvertedValues, arg_0, arg_1));
        return filteredConvertedValues;
    }

    @Override
    protected boolean processValueBinding(ElementChanges elementChanges) {
        Object value;
        BindingResult selectedBindingResult;
        if (this.getModelBinding() != null && (selectedBindingResult = this.getModelBinding().getBindingResult()) != null && !this.dataProvider.areObjectsEquals(value = selectedBindingResult.getValue(), this.selectedItem != null ? (Object)this.dataProvider.getCode(this.selectedItem) : null).booleanValue()) {
            LinkedList<Object> allParamsList = new LinkedList<Object>();
            allParamsList.add(value);
            allParamsList.addAll(this.getValuesFromDictionaryComboParameters(this.getValueParamsList));
            this.selectedItem = ReflectionUtils.run((Method)this.getValue, (Object)this.dataProvider, (Object[])allParamsList.toArray());
            this.rawValue = this.toRawValue(this.selectedItem);
            elementChanges.addChange("rawValue", (Object)this.rawValue);
            this.filterText = this.rawValue != null ? this.rawValue : "";
            this.updateFilterTextBinding();
            return true;
        }
        return false;
    }

    List<Object> getValuesFromDictionaryComboParameters(List<DictionaryComboParameter> dcp) {
        LinkedList<Object> l = new LinkedList<Object>();
        dcp.forEach(dictionaryComboParameter -> {
            BindingResult br = dictionaryComboParameter.getModelBinding().getBindingResult();
            if (br == null) {
                throw new FhException("No attribute for " + DictionaryComboParameter.class.getSimpleName() + " : " + dictionaryComboParameter.getName());
            }
            l.add(br.getValue());
        });
        return l;
    }

    public ElementChanges comboParameterModelRefreash() {
        ElementChanges elementChanges = super.updateView();
        this.processFiltering("");
        this.processFilterBinding(elementChanges, true);
        this.refreshView();
        return elementChanges;
    }

    public String getProvider() {
        return this.provider;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public boolean isProcessComponentChange() {
        return this.processComponentChange;
    }

    public List<NonVisualFormElement> getNonVisualSubcomponents() {
        return this.nonVisualSubcomponents;
    }

    public void setNonVisualSubcomponents(List<NonVisualFormElement> nonVisualSubcomponents) {
        this.nonVisualSubcomponents = nonVisualSubcomponents;
    }

    private /* synthetic */ void lambda$collectValues$4(AtomicReference idx, MultiValueMap filteredConvertedValues, String key, List values) {
        values.forEach(value -> {
            Combo.ComboItemDTO item = new Combo.ComboItemDTO(this.dataProvider.getCode(value), (Long)idx.get(), false, this.dataProvider.getDisplayValue(value));
            idx.getAndSet((Long)idx.get() + 1L);
            filteredConvertedValues.add((Object)key, (Object)item);
        });
    }
}

