/*
 * Decompiled with CFR 0.152.
 */
package pl.fhframework.model.forms;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import pl.fhframework.events.IEventSource;
import pl.fhframework.model.dto.ElementChanges;
import pl.fhframework.model.forms.FormElement;
import pl.fhframework.model.forms.optimized.ColumnOptimized;
import pl.fhframework.model.forms.optimized.TableCellOptimized;
import pl.fhframework.model.forms.optimized.TableOptimized;
import pl.fhframework.model.forms.table.LowLevelRowMetadata;

public class TableRowOptimized {
    @JsonIgnore
    private TableOptimized table;
    private List<FormElement> tableCells = new ArrayList<FormElement>();

    public TableRowOptimized(TableOptimized table, LowLevelRowMetadata lowLevelRowMetadata) {
        this.table = table;
        for (ColumnOptimized column : table.getColumns()) {
            this.tableCells.addAll(column.createTableCells(lowLevelRowMetadata));
        }
    }

    public void updateFormComponents(Set<ElementChanges> formComponentsChanges) {
        for (FormElement tableCell : this.tableCells) {
            if (tableCell instanceof TableCellOptimized) {
                ((TableCellOptimized)tableCell).doActionForEverySubcomponent(component -> this.updateFromComponent((FormElement)component, formComponentsChanges));
                continue;
            }
            this.updateFromComponent(tableCell, formComponentsChanges);
        }
    }

    public IEventSource getEventSource(String elementId) {
        IEventSource[] result = new IEventSource[1];
        for (FormElement tableCell : this.tableCells) {
            if (tableCell instanceof TableCellOptimized) {
                ((TableCellOptimized)tableCell).doActionForEverySubcomponent(component -> {
                    if (component.getId().equals(elementId)) {
                        result[0] = component;
                    }
                });
            } else if (tableCell.getId().equals(elementId)) {
                result[0] = tableCell;
            }
            if (result[0] == null) continue;
            break;
        }
        return result[0];
    }

    private void updateFromComponent(FormElement formElement, Set<ElementChanges> formComponentsChanges) {
        ElementChanges elementChanges = formElement.updateView();
        if (!elementChanges.getChangedAttributes().isEmpty()) {
            formComponentsChanges.add(elementChanges);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TableRowOptimized other = (TableRowOptimized)obj;
        if (this.table == null ? other.table != null : !this.table.equals((Object)other.table)) {
            return false;
        }
        return !(this.tableCells == null ? other.tableCells != null : !this.tableCells.equals(other.tableCells));
    }

    public List<FormElement> getTableCells() {
        return this.tableCells;
    }
}

