/*
 * Decompiled with CFR 0.152.
 */
package pl.fhframework.model.forms.validation;

import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import pl.fhframework.model.forms.BaseInputField;
import pl.fhframework.model.forms.Combo;
import pl.fhframework.model.forms.FileUpload;
import pl.fhframework.model.forms.SelectComboMenu;
import pl.fhframework.model.forms.validation.impl.CheckBoxIsRequired;
import pl.fhframework.model.forms.validation.impl.ComboIsRequired;
import pl.fhframework.model.forms.validation.impl.FiledUploadRequired;
import pl.fhframework.model.forms.validation.impl.IsRequired;
import pl.fhframework.model.forms.validation.impl.IsValidConversion;
import pl.fhframework.model.forms.validation.impl.RadioOptionIsRequired;
import pl.fhframework.model.forms.validation.impl.RegExRequired;
import pl.fhframework.model.forms.validation.impl.SelectComboIsRequired;
import pl.fhframework.model.forms.validation.impl.ValidationRule;
import pl.fhframework.validation.ValidationManager;
import pl.fhframework.validation.Validator;

@Component
public class ValidationFactory
implements InitializingBean {
    private static ValidationFactory validationFactory;
    @Autowired
    private IsRequired isRequired;
    @Autowired
    private IsValidConversion isValidConversion;
    @Autowired
    private ValidationRule validationRule;
    @Autowired
    private CheckBoxIsRequired checkBoxIsRequired;
    @Autowired
    private RadioOptionIsRequired radioOptionIsRequired;
    @Autowired
    private RegExRequired regExRequired;
    @Autowired
    private FiledUploadRequired filedUploadRequired;
    @Autowired
    private ComboIsRequired comboIsRequired;
    @Autowired
    private SelectComboIsRequired selectComboIsRequired;

    public ValidationManager<BaseInputField> getBasicValidationProcess() {
        ValidationManager vm = new ValidationManager(false);
        vm.addValidator((Validator)this.isRequired).addValidator((Validator)this.validationRule).addValidator((Validator)this.isValidConversion);
        return vm;
    }

    public ValidationManager<BaseInputField> getCheckBoxValidationProcess() {
        ValidationManager vm = new ValidationManager(false);
        vm.addValidator((Validator)this.checkBoxIsRequired).addValidator((Validator)this.validationRule);
        return vm;
    }

    public ValidationManager<BaseInputField> getInputTextValidationProcess() {
        ValidationManager vm = new ValidationManager(false);
        vm.addValidator((Validator)this.isRequired).addValidator((Validator)this.regExRequired).addValidator((Validator)this.validationRule).addValidator((Validator)this.isValidConversion);
        return vm;
    }

    public ValidationManager<FileUpload> getFileUploadValidationProcess() {
        ValidationManager vm = new ValidationManager(false);
        vm.addValidator((Validator)this.filedUploadRequired);
        return vm;
    }

    public ValidationManager<Combo> getComboValidationProcess() {
        ValidationManager vm = new ValidationManager();
        vm.addValidator((Validator)this.comboIsRequired).addValidator((Validator)this.isValidConversion);
        return vm;
    }

    public ValidationManager<SelectComboMenu> getSelectComboValidationProcess() {
        ValidationManager vm = new ValidationManager();
        vm.addValidator((Validator)this.selectComboIsRequired).addValidator((Validator)this.isValidConversion);
        return vm;
    }

    public ValidationManager<BaseInputField> getRadioOptionValidationProcess() {
        ValidationManager vm = new ValidationManager();
        vm.addValidator((Validator)this.radioOptionIsRequired);
        return vm;
    }

    public void afterPropertiesSet() throws Exception {
        validationFactory = this;
    }

    public static ValidationFactory getInstance() {
        return validationFactory;
    }
}

