/*
 * Decompiled with CFR 0.152.
 */
package pl.fhframework.model.forms;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public interface Styleable {
    public static final String ATTR_STYLE = "style";

    public static enum Style {
        DEFAULT,
        PRIMARY,
        SUCCESS,
        INFO,
        WARNING,
        DANGER,
        LINK,
        LIGHT;

        private static Map<String, Style> stylesMap;

        @JsonValue
        public String toValue() {
            for (Map.Entry<String, Style> entry : stylesMap.entrySet()) {
                if (entry.getValue() != this) continue;
                return entry.getKey();
            }
            return null;
        }

        @JsonCreator
        public static Style forValue(String value) {
            Style style = stylesMap.get(value);
            return style != null ? style : PRIMARY;
        }

        static {
            stylesMap = new HashMap<String, Style>(6);
            stylesMap.put("default", DEFAULT);
            stylesMap.put("primary", PRIMARY);
            stylesMap.put("success", SUCCESS);
            stylesMap.put("info", INFO);
            stylesMap.put("warning", WARNING);
            stylesMap.put("danger", DANGER);
            stylesMap.put("link", LINK);
            stylesMap.put("light", LIGHT);
        }
    }
}

