/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.runtime.version.system;

import java.util.SortedSet;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.decerto.hyperon.runtime.dao.VersionJdbcDao;
import pl.decerto.hyperon.runtime.version.system.SystemVersionCache;
import pl.decerto.hyperon.runtime.version.system.SystemVersionProvider;

public class SystemVersionProviderImpl
implements SystemVersionProvider {
    private static final Logger log = LoggerFactory.getLogger(SystemVersionProviderImpl.class);
    private final SystemVersionCache systemVersionCache;
    private final VersionJdbcDao dao;

    @Override
    public SortedSet<Integer> get(@NotNull String profileCode, @NotNull SortedSet<Integer> versionIdsToOmit) {
        return this.systemVersionCache.get(profileCode, versionIdsToOmit).orElseGet(() -> this.getFromDB(profileCode, versionIdsToOmit));
    }

    private SortedSet<Integer> getFromDB(String profileCode, SortedSet<Integer> versionIdsToOmit) {
        log.debug("cache hit miss, getting system versions for profile code:{} from db", (Object)profileCode);
        SortedSet<Integer> systemVersions = this.dao.getSystemVersions(profileCode, versionIdsToOmit);
        this.systemVersionCache.put(profileCode, versionIdsToOmit, systemVersions);
        return systemVersions;
    }

    public SystemVersionProviderImpl(SystemVersionCache systemVersionCache, VersionJdbcDao dao) {
        this.systemVersionCache = systemVersionCache;
        this.dao = dao;
    }
}

