/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.runtime.sync;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.smartparam.engine.core.function.Function;
import org.smartparam.engine.core.function.FunctionCache;
import org.smartparam.engine.core.prepared.CacheEntry;
import pl.decerto.hyperon.runtime.model.MpFunction;
import pl.decerto.hyperon.runtime.provider.MpFunctionProvider;
import pl.decerto.hyperon.runtime.sync.RuntimeWatcher;
import pl.decerto.hyperon.runtime.sync.RuntimeWatcherHelper;
import pl.decerto.hyperon.runtime.sync.Trackable;
import pl.decerto.hyperon.runtime.sync.event.ElementType;

public class FunctionRuntimeWatcher
extends RuntimeWatcher {
    private final MpFunctionProvider provider;
    private final FunctionCache cache;

    public FunctionRuntimeWatcher(MpFunctionProvider provider, FunctionCache cache) {
        this.provider = provider;
        this.cache = cache;
    }

    @Override
    protected String getWatcherName() {
        return "function-watcher";
    }

    @Override
    public List<Trackable> getAllCached() {
        List<CacheEntry<Function>> all = this.cache.list();
        this.log.trace("fetched {} functions from cache", (Object)all.size());
        ArrayList<Trackable> result = new ArrayList<Trackable>(all.size());
        for (CacheEntry<Function> entry : all) {
            String key = entry.getKey();
            MpFunction f = (MpFunction)entry.getValue();
            result.add(new Trackable(f.getId(), key, f.getLastupdate()));
        }
        return result;
    }

    @Override
    public void invalidate(int id) {
        RuntimeWatcherHelper.invalidateFunction(this.cache, id);
    }

    @Override
    public Date getLastUpdate() {
        return this.provider.getLastUpdate();
    }

    @Override
    public List<Trackable> getAllLastUpdates() {
        return this.provider.getAllLastUpdates();
    }

    @Override
    public ElementType getElementType() {
        return ElementType.FUNCTION;
    }
}

