/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.runtime.sql.dialect;

import java.util.Locale;
import pl.decerto.hyperon.runtime.sql.dialect.DefaultDialect;

public class MsSQL2012HyperonDialect
extends DefaultDialect {
    public MsSQL2012HyperonDialect() {
        this.withColumnAliases("external", "externalFlag", "key", "keyName");
        this.withTableAliases("Function", "FunctionTBL", "Function_Category", "FunctionTBL_Category");
        this.withHint("ix_pe_pid", "with(index=ix_pe_pid)");
    }

    @Override
    public String selectFromSequence(String sequence, String schema) {
        return "SELECT NEXT VALUE FOR " + this.concatenateSchema(schema, sequence);
    }

    @Override
    public String validationQuery() {
        return "select 1";
    }

    @Override
    public String jdbcDriverClassName() {
        return "com.microsoft.sqlserver.jdbc.SQLServerDriver";
    }

    @Override
    public String hibernateDialect() {
        return "pl.decerto.hyperon.sqldialect.SQLServer2012DialectFixed";
    }

    @Override
    public String table(String table) {
        String normalizedTable = this.normalizeIdentifier(table);
        if (this.tableAliases.containsKey(normalizedTable)) {
            return this.decapitalizeFirstLetter((String)this.tableAliases.get(normalizedTable));
        }
        return table.toLowerCase(Locale.ENGLISH);
    }

    private String decapitalizeFirstLetter(String code) {
        if (code == null || code.length() == 0) {
            return code;
        }
        char[] characters = code.toCharArray();
        characters[0] = Character.toLowerCase(characters[0]);
        return new String(characters);
    }
}

