/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.runtime.provider;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.decerto.hyperon.runtime.dao.FunctionJdbcDao;
import pl.decerto.hyperon.runtime.dao.VersionJdbcDao;
import pl.decerto.hyperon.runtime.dao.parameter.ParameterJdbcDao;
import pl.decerto.hyperon.runtime.model.MpElement;
import pl.decerto.hyperon.runtime.model.MpFunction;
import pl.decerto.hyperon.runtime.model.MpParameter;
import pl.decerto.hyperon.runtime.model.MpSchedule;
import pl.decerto.hyperon.runtime.model.MpVersion;
import pl.decerto.hyperon.runtime.model.region.ScheduleContainer;
import pl.decerto.hyperon.runtime.sync.ScheduleCache;

public class MpScheduleProvider {
    private static final Logger log = LoggerFactory.getLogger(MpScheduleProvider.class);
    private final VersionJdbcDao vdao;
    private final ParameterJdbcDao pdao;
    private final FunctionJdbcDao fdao;
    private AtomicReference<ScheduleCache> cache = new AtomicReference();

    public MpScheduleProvider(VersionJdbcDao vdao, ParameterJdbcDao pdao, FunctionJdbcDao fdao) {
        this.vdao = vdao;
        this.pdao = pdao;
        this.fdao = fdao;
    }

    public ScheduleCache createScheduleCache() {
        log.debug("creating schedule cache...");
        Map<Integer, MpVersion> versionMap = this.vdao.getAllRegionVersions();
        Map<String, ScheduleContainer> scheduleMap = this.vdao.getAllSchedules();
        List<MpParameter> params = this.pdao.getAllHeads();
        List<MpFunction> functions = this.fdao.getAllHeads();
        Map<String, MpSchedule> parSchedules = this.mapCodesToSchedules(params, versionMap, scheduleMap);
        Map<String, MpSchedule> funSchedules = this.mapCodesToSchedules(functions, versionMap, scheduleMap);
        int hash = this.computeHash(scheduleMap);
        ScheduleCache scheduleCache = new ScheduleCache(parSchedules, funSchedules, scheduleMap, hash, versionMap.values());
        log.debug("created schedule cache: {}", (Object)scheduleCache);
        return scheduleCache;
    }

    public int computeHash() {
        Map<String, ScheduleContainer> scheduleMap = this.vdao.getAllSchedules();
        return this.computeHash(scheduleMap);
    }

    public int computeHash(Map<String, ScheduleContainer> scheduleMap) {
        Date parLastupdate = this.pdao.getMaxLastUpdate();
        Date funLastupdate = this.fdao.getMaxLastUpdate();
        return this.computeHash(scheduleMap, parLastupdate, funLastupdate);
    }

    public int hash() {
        ScheduleCache scheduleCache = this.cache.get();
        return scheduleCache != null ? scheduleCache.getHash() : 0;
    }

    public void reload() {
        this.cache.set(this.createScheduleCache());
    }

    public ScheduleCache cache() {
        if (this.cache.get() == null) {
            this.reload();
        }
        return this.cache.get();
    }

    private int computeHash(Map<String, ScheduleContainer> scheduleMap, Date ... lastupdates) {
        int hash = scheduleMap.hashCode();
        for (Date date : lastupdates) {
            hash = 31 * hash + this.h(date != null ? date.getTime() : 0L);
        }
        return hash;
    }

    private int h(long v) {
        int h = (int)(v ^ v >>> 32);
        return h ^ h >>> 7 ^ h >>> 4;
    }

    private <E extends MpElement> Map<String, MpSchedule> mapCodesToSchedules(List<E> items, Map<Integer, MpVersion> versionMap, Map<String, ScheduleContainer> scheduleMap) {
        HashMap<String, MpSchedule> result = new HashMap<String, MpSchedule>();
        for (MpElement item : items) {
            int rvid = item.getRegionVersionId();
            MpVersion rv = versionMap.get(rvid);
            if (rv == null || rv.getRegion() == null) continue;
            MpSchedule sch = this.getSchedule(scheduleMap, rv.getProfileCode(), rv.getRegion());
            result.put(item.getName(), sch);
        }
        return result;
    }

    private MpSchedule getSchedule(Map<String, ScheduleContainer> map, String profileCode, String regionCode) {
        return map.computeIfAbsent(profileCode, code -> this.createScheduleContainerWithSchedule((String)code, regionCode)).getSchedule(regionCode).orElseGet(this.createSchedule(map, profileCode, regionCode));
    }

    private ScheduleContainer createScheduleContainerWithSchedule(String profileCode, String regionCode) {
        ScheduleContainer container = new ScheduleContainer();
        MpSchedule schedule = new MpSchedule(profileCode, regionCode);
        container.add(regionCode, schedule);
        return container;
    }

    private Supplier<MpSchedule> createSchedule(Map<String, ScheduleContainer> map, String profileCode, String regionCode) {
        return () -> {
            MpSchedule schedule = new MpSchedule(profileCode, regionCode);
            ((ScheduleContainer)map.get(profileCode)).add(regionCode, schedule);
            return schedule;
        };
    }
}

