/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.runtime.profiler.jdbc.proxy;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.decerto.hyperon.runtime.profiler.jdbc.JdbcProfiler;

public class StatementProxy
implements InvocationHandler {
    private static final Logger log = LoggerFactory.getLogger((String)"jdbc_profiler");
    private static final Class<?>[] INTERFACES = new Class[]{Statement.class};
    private Statement stmt;

    private StatementProxy(Statement stmt) {
        this.stmt = stmt;
    }

    public static Statement newInstance(Statement stmt) {
        return (Statement)Proxy.newProxyInstance(stmt.getClass().getClassLoader(), INTERFACES, (InvocationHandler)new StatementProxy(stmt));
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        long t = System.currentTimeMillis();
        try {
            Object object = method.invoke((Object)this.stmt, args);
            return object;
        }
        catch (InvocationTargetException e) {
            log.error("failed to execute statement:\n {}, {}", args[0], (Object)e);
            throw e;
        }
        finally {
            if (method.getName().startsWith("execute")) {
                this.onExecute(t, System.currentTimeMillis(), (String)args[0]);
            }
        }
    }

    private void onExecute(long t1, long t2, String sql) {
        JdbcProfiler.getSingleton().sqlExecuted(sql, t2 - t1);
    }
}

