/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.runtime.prefetch;

import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smartparam.engine.util.Printer;
import pl.decerto.hyperon.runtime.prefetch.Initializer;
import pl.decerto.hyperon.runtime.prefetch.PrefetchStrategy;

public abstract class AbstractPrefetchStrategy
implements PrefetchStrategy {
    private static final Logger log = LoggerFactory.getLogger(AbstractPrefetchStrategy.class);
    private static final int DEFAULT_PAUSE_AFTER_FAILURE_SECONDS = 10;
    private final Initializer initializer;

    @Override
    public void prefetch() {
        List<String> codes = this.getCodes();
        if (log.isDebugEnabled()) {
            log.debug(Printer.print(codes, "code to be prefetched"));
        }
        long t = System.nanoTime();
        this.processCodes(codes);
        log.debug("finished code initialization, time={} ms", (Object)(System.nanoTime() - t));
    }

    protected abstract List<String> getCodes();

    private void processCodes(List<String> codes) {
        int i = 0;
        int sizeOfTheListToPrefetch = codes.size();
        for (String code : codes) {
            log.debug("initializing {}/{} - {}", new Object[]{++i, sizeOfTheListToPrefetch, code});
            try {
                this.initializer.initialize(code);
            }
            catch (RuntimeException e) {
                log.error("failed to initialize code", (Throwable)e);
                this.pauseAfterFailure();
            }
        }
    }

    private void pauseAfterFailure() {
        this.pause(10L);
    }

    private void pause(long seconds) {
        try {
            TimeUnit.SECONDS.sleep(seconds);
        }
        catch (InterruptedException e) {
            log.error("pause interrupted", (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }

    public AbstractPrefetchStrategy(Initializer initializer) {
        this.initializer = initializer;
    }
}

