/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.runtime.license;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.smartparam.engine.types.date.SimpleDateFormatPool;

public class HyperonLicenseDetailsDto {
    public static final String STRING_SEPARATOR = ":";
    private final Date validFrom;
    private final Date validTo;
    private final String licenseNumber;
    private final String licensee;
    private final Integer permittedCpuCores;
    private final String specialConditions;

    private HyperonLicenseDetailsDto(Builder builder) {
        this.validFrom = builder.from;
        this.validTo = builder.to;
        this.licenseNumber = builder.licenseNumber;
        this.licensee = builder.licensee;
        this.permittedCpuCores = builder.permittedCpuCores;
        this.specialConditions = builder.specialConditions;
    }

    public String getDetailsAsKeyValueString() {
        SimpleDateFormat dateFormat = SimpleDateFormatPool.get("yyyy-MM-dd");
        String details = "validFrom=" + dateFormat.format(this.validFrom) + STRING_SEPARATOR;
        details = details + "validTo=" + (this.validTo == null ? null : dateFormat.format(this.validTo)) + STRING_SEPARATOR;
        details = details + "licenseNumber=" + this.licenseNumber + STRING_SEPARATOR;
        details = details + "licensee=" + this.licensee + STRING_SEPARATOR;
        details = details + "permittedCpuCores=" + this.permittedCpuCores + STRING_SEPARATOR;
        details = details + "specialConditions=" + this.specialConditions;
        return details;
    }

    public Date getValidFrom() {
        return this.validFrom;
    }

    public Date getValidTo() {
        return this.validTo;
    }

    public String getLicenseNumber() {
        return this.licenseNumber;
    }

    public String getLicensee() {
        return this.licensee;
    }

    public Integer getPermittedCpuCores() {
        return this.permittedCpuCores;
    }

    public String getSpecialConditions() {
        return this.specialConditions;
    }

    public String toString() {
        return "HyperonLicenseDetailsDto(validFrom=" + this.getValidFrom() + ", validTo=" + this.getValidTo() + ", licenseNumber=" + this.getLicenseNumber() + ", licensee=" + this.getLicensee() + ", permittedCpuCores=" + this.getPermittedCpuCores() + ", specialConditions=" + this.getSpecialConditions() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HyperonLicenseDetailsDto)) {
            return false;
        }
        HyperonLicenseDetailsDto other = (HyperonLicenseDetailsDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Date this$validFrom = this.getValidFrom();
        Date other$validFrom = other.getValidFrom();
        if (this$validFrom == null ? other$validFrom != null : !((Object)this$validFrom).equals(other$validFrom)) {
            return false;
        }
        Date this$validTo = this.getValidTo();
        Date other$validTo = other.getValidTo();
        if (this$validTo == null ? other$validTo != null : !((Object)this$validTo).equals(other$validTo)) {
            return false;
        }
        String this$licenseNumber = this.getLicenseNumber();
        String other$licenseNumber = other.getLicenseNumber();
        if (this$licenseNumber == null ? other$licenseNumber != null : !this$licenseNumber.equals(other$licenseNumber)) {
            return false;
        }
        String this$licensee = this.getLicensee();
        String other$licensee = other.getLicensee();
        if (this$licensee == null ? other$licensee != null : !this$licensee.equals(other$licensee)) {
            return false;
        }
        Integer this$permittedCpuCores = this.getPermittedCpuCores();
        Integer other$permittedCpuCores = other.getPermittedCpuCores();
        if (this$permittedCpuCores == null ? other$permittedCpuCores != null : !((Object)this$permittedCpuCores).equals(other$permittedCpuCores)) {
            return false;
        }
        String this$specialConditions = this.getSpecialConditions();
        String other$specialConditions = other.getSpecialConditions();
        return !(this$specialConditions == null ? other$specialConditions != null : !this$specialConditions.equals(other$specialConditions));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HyperonLicenseDetailsDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Date $validFrom = this.getValidFrom();
        result = result * 59 + ($validFrom == null ? 43 : ((Object)$validFrom).hashCode());
        Date $validTo = this.getValidTo();
        result = result * 59 + ($validTo == null ? 43 : ((Object)$validTo).hashCode());
        String $licenseNumber = this.getLicenseNumber();
        result = result * 59 + ($licenseNumber == null ? 43 : $licenseNumber.hashCode());
        String $licensee = this.getLicensee();
        result = result * 59 + ($licensee == null ? 43 : $licensee.hashCode());
        Integer $permittedCpuCores = this.getPermittedCpuCores();
        result = result * 59 + ($permittedCpuCores == null ? 43 : ((Object)$permittedCpuCores).hashCode());
        String $specialConditions = this.getSpecialConditions();
        result = result * 59 + ($specialConditions == null ? 43 : $specialConditions.hashCode());
        return result;
    }

    public static class Builder {
        private Date from;
        private Date to;
        private String licenseNumber;
        private String licensee;
        private Integer permittedCpuCores;
        private String specialConditions;

        public Builder from(Date from) {
            this.from = from;
            return this;
        }

        public Builder to(Date to) {
            this.to = to;
            return this;
        }

        public Builder licenseNumber(String licenseNumber) {
            this.licenseNumber = licenseNumber;
            return this;
        }

        public Builder licensee(String licensee) {
            this.licensee = licensee;
            return this;
        }

        public Builder permittedCpuCores(Integer cores) {
            this.permittedCpuCores = cores;
            return this;
        }

        public Builder specialConditions(String specialConditions) {
            this.specialConditions = specialConditions;
            return this;
        }

        public HyperonLicenseDetailsDto build() {
            if (this.from == null) {
                throw new IllegalStateException("validFrom date cannot be null");
            }
            if (this.licenseNumber == null || this.licenseNumber.length() != 8) {
                throw new IllegalStateException("licenseNumber cannot be null and must contain 8 characters");
            }
            if (this.licensee == null) {
                throw new IllegalStateException("licensee cannot be null");
            }
            return new HyperonLicenseDetailsDto(this);
        }
    }
}

